/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.formula;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.bos.ctrl.excel.model.util.SortedParameterArray;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.newrpt.formula.IReportPropertyAdapter;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.eas.fi.rpt.batch.FormulaValueBackfill;
import com.kingdee.eas.tm.td.TDUtils;
import com.kingdee.eas.tm.td.basedata.TaxItemTypeInfo;
import com.kingdee.eas.tm.td.est.EstCalculateRecordCollection;
import com.kingdee.eas.tm.td.est.EstCalculateRecordFactory;
import com.kingdee.eas.tm.td.est.RealEstateGroupInfo;
import com.kingdee.eas.tm.td.est.TaxMethodEnum;
import com.kingdee.eas.tm.td.est.util.EstConstant;
import com.kingdee.eas.tm.td.formula.AbstractBatchCalculater;
import com.kingdee.eas.tm.td.formula.ParamsInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class EstCalculateRecordCalculater
extends AbstractBatchCalculater {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.td.formula.EstCalculateRecordCalculater");

    public EstCalculateRecordCalculater(ICalculateContextProvider contextProvider) {
        this.contextProvider = contextProvider;
    }

    @Override
    public void execute(SortedParameterArray paramArray) {
        super.execute(paramArray);
        IReportPropertyAdapter reportAdapter = this.contextProvider.getReportAdapter();
        int querySize = paramArray.size();
        String rptID = reportAdapter.getReportProperty("Report.ID").toString();
        ReportBaseInfo info = null;
        try {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("*"));
            info = TDUtils.getReportValue(this.ctx, rptID, sic);
        }
        catch (Exception e) {
            FormulaValueBackfill.setException((Parameter)paramArray.getParameter(0), (Throwable)e);
        }
        if (info == null) {
            return;
        }
        for (int i = 0; i < querySize; ++i) {
            Parameter params = paramArray.getParameter(i);
            ParamsInfo formulaParam = new ParamsInfo();
            formulaParam.buildEstCalculateRecordParam(params);
            formulaParam.setInfo(info);
            this.innerExecute(formulaParam);
        }
    }

    protected void innerExecute(ParamsInfo param) {
        String periodTo;
        String company = param.getCompany();
        ReportBaseInfo info = param.getInfo();
        String periodFrom = param.getPeriodFrom();
        if (periodFrom.isEmpty()) {
            Date startDate = info.getStartDate();
            periodFrom = String.valueOf((startDate.getYear() + 1900) * 100 + startDate.getMonth() + 1);
        }
        if ((periodTo = param.getPeriodTo()).isEmpty()) {
            Date endDate = info.getEndDate();
            periodTo = String.valueOf((endDate.getYear() + 1900) * 100 + endDate.getMonth() + 1);
        }
        String taxItemType = param.getTaxItemType();
        String landData = param.getLandData();
        String buildingTaxesGroup = param.getRealEstateGroup();
        String realEstate = param.getRealEstate();
        String rentalEstate = param.getRentalEstate();
        String contractNumber = param.getContractNumber();
        String taxMethod = param.getTaxMethod();
        String dataField = param.getDataField();
        TaxMethodEnum taxMethodEnum = null;
        if (EstConstant.PRICE.equals(taxMethod)) {
            taxMethodEnum = TaxMethodEnum.PRICE;
        } else if (EstConstant.RENT.equals(taxMethod)) {
            taxMethodEnum = TaxMethodEnum.RENT;
        }
        if (TaxMethodEnum.RENT.equals((Object)taxMethodEnum) && contractNumber.isEmpty()) {
            param.getBackFiller().setValue((Object)"");
            return;
        }
        EntityObjectInfo entity = this.getEntity("9E3F8034");
        if (dataField.isEmpty()) {
            param.getBackFiller().setValue((Object)"");
            return;
        }
        boolean isSum = false;
        if (EstConstant.VATNUMBER.equals(taxItemType) && (EstConstant.TAXBASIS.equals(dataField) || EstConstant.TAXAMOUNT.equals(dataField))) {
            isSum = true;
        }
        EstCalculateRecordCollection recordColls = null;
        try {
            StringBuffer sql = new StringBuffer();
            sql.append(" Select Record.FID as ID from T_TD_EstCalculateRecord Record ");
            sql.append(" Left join T_TD_LandData LandData on Record.FLandDataID = LandData.FID ");
            sql.append(" Left join T_TD_RealEstateGroup RealEstateGroup on Record.FRealEstateGroupID = RealEstateGroup.FID ");
            sql.append(" Left join T_TD_RealEstate EstReal on Record.FRealEstateID=EstReal.FID");
            sql.append(" Left join T_TD_RentalEstate EstRental on Record.FRentalEstateID=EstRental.FID");
            sql.append(" Left join T_TM_TaxItemType TaxItemType on Record.FTaxItemTypeID = TaxItemType.FID ");
            sql.append(" Left join T_ORG_COMPANY Company on Record.FCompanyID = Company.FID ");
            sql.append(" Left join T_BD_Period Period on Record.FirstPeriodID = Period.FID ");
            sql.append(" where ");
            if (company.isEmpty()) {
                sql.append(" Company.FID = '").append(((CompanyOrgUnitInfo)info.get("companyOrgUnit")).getId().toString()).append("' ");
            } else {
                sql.append(" Company.FNumber = '").append(company).append("' ");
            }
            sql.append(" and  Record.FTaxPeriodID in ");
            sql.append(" (Select Period.FID from T_BD_PERIOD Period ");
            sql.append(" left join T_ORG_COMPANY Company on Period.FTypeID = Company.FAccountPeriodID ");
            sql.append(" where FIsAdjustPeriod = 0  ");
            sql.append(" and (FPeriodYear * 100 + FPeriodNumber) Between " + periodFrom + " and " + periodTo);
            if (company.isEmpty()) {
                sql.append(" and Company.FID = '").append(((CompanyOrgUnitInfo)info.get("companyOrgUnit")).getId().toString()).append("' )");
            } else {
                sql.append(" and Company.FNumber = '").append(company).append("' )");
            }
            if (taxItemType.isEmpty()) {
                if (info.get("taxType") != null) {
                    sql.append(" and TaxItemType.FID = '").append(((TaxItemTypeInfo)info.get("taxType")).getId().toString()).append("' ");
                }
            } else {
                sql.append(" and  TaxItemType.FNumber = '").append(taxItemType).append("' ");
            }
            if (!landData.isEmpty()) {
                sql.append(" and LandData.FNumber = '").append(landData).append("' ");
            }
            if (buildingTaxesGroup.isEmpty()) {
                if (info.get("buildingTaxesGroup") != null) {
                    sql.append(" and RealEstateGroup.FID = '").append(((RealEstateGroupInfo)info.get("buildingTaxesGroup")).getId().toString()).append("'");
                }
            } else {
                sql.append(" and RealEstateGroup.FNumber = '").append(buildingTaxesGroup).append("' ");
            }
            if (!realEstate.isEmpty()) {
                sql.append(" and EstReal.FNumber = '").append(realEstate).append("' ");
            }
            if (taxMethodEnum != null) {
                sql.append(" and Record.FTaxMethod = '").append(taxMethodEnum.getValue()).append("' ");
            } else {
                sql.append(" and Record.FTaxMethod IS NULL ");
            }
            if (!rentalEstate.isEmpty()) {
                sql.append(" and EstRental.FNumber = '").append(rentalEstate).append("' ");
            }
            if (!contractNumber.isEmpty()) {
                sql.append(" and Record.FContractNumber = '").append(contractNumber).append("' ");
            }
            sql.append(" order by Period.FNumber DESC ");
            IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
            String fid = null;
            HashSet<String> ids = new HashSet<String>();
            while (rs.next()) {
                fid = rs.getString("ID");
                ids.add(fid);
            }
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", ids, CompareType.INCLUDE));
            view.setFilter(filter);
            recordColls = EstCalculateRecordFactory.getLocalInstance(this.ctx).getEstCalculateRecordCollection(view);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            param.getBackFiller().setException((Throwable)e);
        }
        if (recordColls == null || recordColls.size() == 0) {
            param.getBackFiller().setValue((Object)"");
            return;
        }
        String[] props = dataField.split("\\.");
        IObjectValue seftInfo = null;
        if (isSum) {
            BigDecimal value = BigDecimal.ZERO;
            for (int i = 0; i < recordColls.size(); ++i) {
                seftInfo = recordColls.getObject(i);
                value = value.add((BigDecimal)this.getValue(entity, props, seftInfo));
            }
            param.getBackFiller().setValue((Object)value);
        } else {
            seftInfo = recordColls.getObject(0);
            param.getBackFiller().setValue(this.getValue(entity, props, seftInfo));
        }
    }

    private Object getValue(EntityObjectInfo tempEntity, String[] props, IObjectValue seftInfo) {
        String value = "";
        for (int j = 0; j < props.length; ++j) {
            PropertyInfo property = tempEntity.getPropertyByName(props[j]);
            if (j == props.length - 1) {
                return this.getPropertyValue(property, seftInfo.get(props[j]));
            }
            if (property instanceof LinkPropertyInfo) {
                tempEntity = ((LinkPropertyInfo)property).getRelationship().getSupplierObject();
            }
            if (seftInfo.get(props[j]) instanceof IObjectValue) {
                IObjectValue tempInfo = (IObjectValue)seftInfo.get(props[j]);
                String id = tempInfo.getString("id");
                IDynamicObject iDynamicObject = DynamicObjectFactory.getLocalInstance((Context)this.ctx);
                try {
                    seftInfo = iDynamicObject.getValue(tempInfo.getBOSType(), (IObjectPK)new ObjectUuidPK(id));
                    continue;
                }
                catch (BOSException e) {
                    return value;
                }
            }
            return value;
        }
        return value;
    }
}

