/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.formula;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.io.BookIOUtil;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.bos.ctrl.excel.model.util.SortedParameterArray;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.newrpt.formula.IReportPropertyAdapter;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.eas.tm.td.TDUtils;
import com.kingdee.eas.tm.td.TaxOtherReportCollection;
import com.kingdee.eas.tm.td.TaxOtherReportFactory;
import com.kingdee.eas.tm.td.TaxOtherReportInfo;
import com.kingdee.eas.tm.td.basedata.TaxReportTypeInfo;
import com.kingdee.eas.tm.td.formula.AbstractBatchCalculater;
import com.kingdee.eas.tm.td.formula.ParamsInfo;
import com.kingdee.util.StringUtils;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class OtherReportDataBatchCalculater
extends AbstractBatchCalculater {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.td.formula.OtherReportDataBatchCalculater");

    public OtherReportDataBatchCalculater(ICalculateContextProvider contextProvider) {
        this.contextProvider = contextProvider;
    }

    @Override
    public void execute(SortedParameterArray paramArray) {
        super.execute(paramArray);
        IReportPropertyAdapter reportAdapter = this.contextProvider.getReportAdapter();
        int querySize = paramArray.size();
        String rptID = reportAdapter.getReportProperty("Report.ID").toString();
        ReportBaseInfo info = (ReportBaseInfo)reportAdapter.getReportProperty("editData");
        for (int i = 0; i < querySize; ++i) {
            Parameter params = paramArray.getParameter(i);
            ParamsInfo formulaParam = new ParamsInfo();
            formulaParam.buildOtherReportDataParam(params);
            formulaParam.setInfo(info);
            this.innerExecute(formulaParam);
        }
    }

    protected void innerExecute(ParamsInfo param) {
        ReportBaseInfo seftInfo = param.getInfo();
        String companyOrgNumber = param.getCompany();
        String reportType = param.getReportType();
        String periodValue = param.getPeriodValue();
        if ("".equals(periodValue)) {
            periodValue = "0";
        }
        if (StringUtils.isEmpty((String)reportType) && seftInfo.get("reportType") != null) {
            reportType = ((TaxReportTypeInfo)seftInfo.get("reportType")).getNumber();
        }
        int value = Integer.parseInt(periodValue);
        String periodID = ((PeriodInfo)seftInfo.get("rptPeriod")).getId().toString();
        PeriodInfo prePeriod = (PeriodInfo)seftInfo.get("rptPeriod");
        try {
            FilterInfo filter;
            EntityViewInfo ev;
            for (int i = 0; i < value; ++i) {
                prePeriod = PeriodUtils.getPrePeriodInfo((Context)this.ctx, (IObjectPK)new ObjectUuidPK(periodID));
                if (prePeriod == null) {
                    String destPeriodIsNotExists = TDUtils.getString("com.kingdee.eas.tm.td.TDResource", "destPeriodIsNotExists", this.ctx.getLocale());
                    String badFuntion = TDUtils.getString("com.kingdee.eas.tm.td.TDResource", "BADFUNCTION", this.ctx.getLocale(), new Object[]{destPeriodIsNotExists});
                    param.getBackFiller().setValue((Object)badFuntion);
                    return;
                }
                if (prePeriod.isIsAdjustPeriod() && (prePeriod = PeriodUtils.getPrePeriodInfo((Context)this.ctx, (IObjectPK)new ObjectUuidPK(prePeriod.getId().toString()))) == null) {
                    String destPeriodIsNotExists = TDUtils.getString("com.kingdee.eas.tm.td.TDResource", "destPeriodIsNotExists", this.ctx.getLocale());
                    String badFuntion = TDUtils.getString("com.kingdee.eas.tm.td.TDResource", "BADFUNCTION", this.ctx.getLocale(), new Object[]{destPeriodIsNotExists});
                    param.getBackFiller().setValue((Object)badFuntion);
                    return;
                }
                periodID = prePeriod.getId().toString();
            }
            String companyID = ((CompanyOrgUnitInfo)seftInfo.get("companyOrgUnit")).getId().toString();
            if (companyOrgNumber != null && !"".equals(companyOrgNumber)) {
                ev = new EntityViewInfo();
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)companyOrgNumber, CompareType.EQUALS));
                ev.setFilter(filter);
                CompanyOrgUnitCollection coll = CompanyOrgUnitFactory.getLocalInstance((Context)this.ctx).getCompanyOrgUnitCollection(ev);
                if (coll != null && coll.size() > 0) {
                    companyID = coll.get(0).getId().toString();
                }
            }
            ev = new EntityViewInfo();
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("rptPeriod.id", (Object)prePeriod.getId().toString(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", (Object)companyID, CompareType.EQUALS));
            if (!StringUtils.isEmpty((String)reportType)) {
                filter.getFilterItems().add(new FilterItemInfo("reportType.number", (Object)reportType, CompareType.EQUALS));
            }
            ev.setFilter(filter);
            TaxOtherReportCollection rtpcoll = TaxOtherReportFactory.getLocalInstance(this.ctx).getTaxOtherReportCollection(ev);
            if (rtpcoll == null || rtpcoll.size() == 0) {
                param.getBackFiller().setValue((Object)"");
                return;
            }
            TaxOtherReportInfo info = rtpcoll.get(0);
            if (info.getId().toString().equals(seftInfo.getId().toString())) {
                info = (TaxOtherReportInfo)seftInfo;
            }
            byte[] data = info.getData();
            String key = (param.getSheetName() + "!" + param.getCellName()).toUpperCase();
            HashMap map = new HashMap();
            map.put(key, null);
            try {
                BookIOUtil.loadSomeCellValues((byte[])data, map);
            }
            catch (Exception e) {
                return;
            }
            if (map.get(key) == null) {
                param.getBackFiller().setValue((Object)"");
            } else {
                param.getBackFiller().setValue(map.get(key));
            }
        }
        catch (Exception e) {
            param.getBackFiller().setException((Throwable)e);
        }
    }
}

