/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.formula;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.bos.ctrl.excel.model.util.SortedParameterArray;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ep.depend.MetadataUtils;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.newrpt.formula.IReportPropertyAdapter;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.eas.tm.td.TDUtils;
import com.kingdee.eas.tm.td.basedata.TaxBaseCollection;
import com.kingdee.eas.tm.td.basedata.TaxBaseFactory;
import com.kingdee.eas.tm.td.basedata.TaxBaseInfo;
import com.kingdee.eas.tm.td.formula.AbstractBatchCalculater;
import com.kingdee.eas.tm.td.formula.ParamsInfo;
import com.kingdee.util.LowTimer;
import com.kingdee.util.enums.Enum;
import java.text.SimpleDateFormat;
import org.apache.log4j.Logger;

public class ReportTaxBaseCalculater
extends AbstractBatchCalculater {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.td.formula.ReportTaxBaseCalculater");
    private static EntityObjectInfo entity = null;

    public ReportTaxBaseCalculater(ICalculateContextProvider contextProvider) {
        this.contextProvider = contextProvider;
    }

    @Override
    public void execute(SortedParameterArray paramArray) {
        LowTimer time = new LowTimer();
        super.execute(paramArray);
        IReportPropertyAdapter reportAdapter = this.contextProvider.getReportAdapter();
        int querySize = paramArray.size();
        String rptID = reportAdapter.getReportProperty("Report.ID").toString();
        ReportBaseInfo info = null;
        info = (ReportBaseInfo)reportAdapter.getReportProperty("editData");
        if (info == null) {
            return;
        }
        for (int i = 0; i < querySize; ++i) {
            LowTimer innerTimer = new LowTimer();
            Parameter params = paramArray.getParameter(i);
            ParamsInfo formulaParam = new ParamsInfo();
            formulaParam.buildReportTaxBaseParam(params);
            formulaParam.setInfo(info);
            this.innerExecute(formulaParam);
            logger.error((Object)("[ReportTaxBaseCalculate_querySize]_" + i + "_Time:" + innerTimer.msValue()));
        }
        logger.error((Object)("[SWL_ReportTaxBaseCalculate_Time]:" + time.msValue()));
    }

    protected void innerExecute(ParamsInfo param) {
        ReportBaseInfo info = param.getInfo();
        String companyOrgNumber = param.getCompany();
        String fieldName = param.getFieldName();
        logger.error((Object)("[ReportTaxBaseCalculate_Params]:info:" + param.getInfo() + ";Company:" + param.getCompany() + ";fieldName:" + param.getFieldName() + ";"));
        if (fieldName.isEmpty()) {
            param.getBackFiller().setValue((Object)"");
            return;
        }
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)"1", CompareType.EQUALS));
        if (companyOrgNumber == null || "".equals(companyOrgNumber)) {
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)((CompanyOrgUnitInfo)info.get("companyOrgUnit")).getId().toString(), CompareType.EQUALS));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("company.number", (Object)companyOrgNumber, CompareType.EQUALS));
        }
        ev.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("taxBaseEntry.seq"));
        ev.setSorter(sorter);
        TaxBaseCollection taxBaseColl = null;
        try {
            taxBaseColl = TaxBaseFactory.getLocalInstance(this.ctx).getTaxBaseCollection(ev);
        }
        catch (BOSException e1) {
            param.getBackFiller().setValue((Object)"");
            return;
        }
        if (taxBaseColl == null || taxBaseColl.size() == 0) {
            param.getBackFiller().setValue((Object)"");
            return;
        }
        TaxBaseInfo taxBaseInfo = taxBaseColl.get(0);
        PropertyInfo property = null;
        String[] props = fieldName.split("\\.");
        if (props.length == 1) {
            if (taxBaseInfo.get(props[0]) == null) {
                param.getBackFiller().setValue((Object)"");
            } else {
                property = entity.getPropertyByName(fieldName);
                param.getBackFiller().setValue(this.getPropertyValue(property, taxBaseInfo.get(props[0])));
            }
            return;
        }
        int entrySeq = 1;
        boolean flag = true;
        String taxType = null;
        if (param.getTaxItemType() != null && !"".equals(param.getTaxItemType())) {
            taxType = param.getTaxItemType();
        }
        String companyId = null;
        if (param.getCompany() != null && !"".equals(param.getCompany())) {
            companyId = param.getCompany();
            flag = false;
        } else {
            companyId = taxBaseInfo.getCompany().getId().toString();
        }
        try {
            entrySeq = TaxBaseFactory.getLocalInstance(this.ctx).getSeqByTaxType(taxType, taxBaseInfo.getId().toString());
        }
        catch (EASBizException e) {
            param.getBackFiller().setValue((Object)"");
            return;
        }
        catch (BOSException e1) {
            param.getBackFiller().setValue((Object)"");
            return;
        }
        logger.error((Object)("[ReportTaxBaseCalculate_Params]:TaxItemType:" + param.getTaxItemType() + ";companyId:" + taxBaseInfo.getCompany().getId().toString() + ";entrySeq:" + entrySeq));
        IObjectValue tempInfo = null;
        IObjectCollection tempColl = null;
        TaxBaseInfo seftInfo = taxBaseInfo;
        EntityObjectInfo tempEntity = entity;
        for (int i = 0; i < props.length; ++i) {
            IDynamicObject iDynamicObject;
            String id;
            property = tempEntity.getPropertyByName(props[i]);
            if (i == props.length - 1) {
                if (this.getPropertyValue(property, seftInfo.get(props[i])) != null) {
                    param.getBackFiller().setValue(this.getPropertyValue(property, seftInfo.get(props[i])));
                    return;
                }
                param.getBackFiller().setValue((Object)"");
                return;
            }
            if (property instanceof LinkPropertyInfo) {
                tempEntity = ((LinkPropertyInfo)property).getRelationship().getSupplierObject();
            }
            if (seftInfo.get(props[i]) instanceof IObjectValue) {
                tempInfo = (IObjectValue)seftInfo.get(props[i]);
                id = tempInfo.getString("id");
                iDynamicObject = DynamicObjectFactory.getLocalInstance((Context)this.ctx);
                try {
                    seftInfo = iDynamicObject.getValue(tempInfo.getBOSType(), (IObjectPK)new ObjectUuidPK(id));
                    continue;
                }
                catch (BOSException e) {
                    param.getBackFiller().setValue((Object)"");
                    return;
                }
            }
            if (seftInfo.get(props[i]) instanceof IObjectCollection) {
                tempColl = (IObjectCollection)seftInfo.get(props[i]);
                if (entrySeq < 1 || entrySeq > tempColl.size()) {
                    param.getBackFiller().setValue((Object)"");
                    return;
                }
                tempInfo = tempColl.getObject(entrySeq - 1);
                id = tempInfo.getString("id");
                iDynamicObject = DynamicObjectFactory.getLocalInstance((Context)this.ctx);
                try {
                    seftInfo = iDynamicObject.getValue(tempInfo.getBOSType(), (IObjectPK)new ObjectUuidPK(id));
                    continue;
                }
                catch (BOSException e) {
                    param.getBackFiller().setValue((Object)"");
                    return;
                }
            }
            param.getBackFiller().setValue((Object)"");
            return;
        }
    }

    @Override
    protected Object getPropertyValue(PropertyInfo property, Object value) {
        Object retObj = value;
        SimpleDateFormat formatter = null;
        String dataType = (String)property.get("dataType");
        logger.error((Object)("[ReportTaxBaseCalculate_Params]:dataType:" + dataType + ";value:" + value));
        String enumSource = null;
        if ("Enum".equals(dataType)) {
            enumSource = (String)property.get("metadataRef");
            logger.error((Object)("[ReportTaxBaseCalculate_Params]:enumSource:" + enumSource));
            try {
                Enum retenum = TDUtils.getEnumValue(enumSource, value);
                retObj = retenum.getAlias();
            }
            catch (Exception e) {
                retObj = "";
                logger.error((Object)e.getMessage());
            }
        } else if ("Boolean".equals(dataType)) {
            retObj = value != null && (value.equals("1") || value.equals("\u662f") || value.equals("true")) || value.equals(true) ? TDUtils.getString("com.kingdee.eas.tm.td.TDCommonResource", "Data_True", this.ctx.getLocale()) : TDUtils.getString("com.kingdee.eas.tm.td.TDCommonResource", "Data_false", this.ctx.getLocale());
        } else if ("Date".equals(dataType)) {
            formatter = new SimpleDateFormat("yyyy-MM-dd");
            retObj = formatter.format(value);
        } else if ("TimeStamp".equals(dataType)) {
            formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            retObj = formatter.format(value);
        }
        logger.error((Object)("[ReportTaxBaseCalculate_Params]:retObj:" + retObj));
        return retObj;
    }

    static {
        entity = MetadataUtils.loadEntity((IMetaDataPK)MetaDataPK.create((String)"com.kingdee.eas.tm.td.basedata.app.TaxBase"));
    }
}

