/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.formula;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.bos.ctrl.excel.model.util.SortedParameterArray;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.newrpt.formula.IReportPropertyAdapter;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.eas.tm.td.RecordTypeEnum;
import com.kingdee.eas.tm.td.TDUtils;
import com.kingdee.eas.tm.td.basedata.TaxItemTypeInfo;
import com.kingdee.eas.tm.td.est.RealEstateGroupInfo;
import com.kingdee.eas.tm.td.formula.AbstractBatchCalculater;
import com.kingdee.eas.tm.td.formula.ParamsInfo;
import com.kingdee.eas.tm.td.structure.TaxReportSheetInfo;
import com.kingdee.eas.tm.td.structure.utils.StructureDynamicTableManager;
import com.kingdee.eas.tm.td.structure.utils.StructureUtils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;

public class TaxItemCalculater
extends AbstractBatchCalculater {
    public TaxItemCalculater(ICalculateContextProvider contextProvider) {
        this.contextProvider = contextProvider;
    }

    @Override
    public void execute(SortedParameterArray paramArray) {
        super.execute(paramArray);
        IReportPropertyAdapter reportAdapter = this.contextProvider.getReportAdapter();
        int querySize = paramArray.size();
        ReportBaseInfo info = (ReportBaseInfo)reportAdapter.getReportProperty("editData");
        for (int i = 0; i < querySize; ++i) {
            Parameter params = paramArray.getParameter(i);
            ParamsInfo formulaParam = new ParamsInfo();
            formulaParam.buildTaxItemParam(params);
            formulaParam.setInfo(info);
            this.innerExecute(formulaParam);
        }
    }

    protected void innerExecute(ParamsInfo param) {
        ReportBaseInfo seftInfo = param.getInfo();
        String companyNumber = param.getCompany();
        String taxTypeNumber = param.getTaxItemType();
        RecordTypeEnum recordTypeEnum = RecordTypeEnum.getEnum(param.getRecordType());
        String accountNumber = param.getAccountConfig();
        String buildingTaxesGroupNumber = param.getBuildingTaxesGroup();
        String periodValue = param.getPeriodValue();
        String reportSheetNumber = param.getReportSheet();
        String rowItemNumber = param.getRowItem();
        String columnItemNumber = param.getColumnItem();
        boolean isPeriodOff = true;
        if (StringUtils.isEmpty((String)reportSheetNumber) || StringUtils.isEmpty((String)rowItemNumber) || StringUtils.isEmpty((String)columnItemNumber)) {
            param.getBackFiller().setValue((Object)"");
            return;
        }
        try {
            TaxReportSheetInfo sheetInfo;
            if ("".equals(periodValue)) {
                periodValue = "0";
            }
            String periodID = null;
            if (periodValue.length() == 6) {
                isPeriodOff = false;
            } else {
                int valueOff = Integer.parseInt(periodValue);
                periodID = ((PeriodInfo)seftInfo.get("rptPeriod")).getId().toString();
                PeriodInfo prePeriod = (PeriodInfo)seftInfo.get("rptPeriod");
                for (int i = 0; i < valueOff; ++i) {
                    prePeriod = PeriodUtils.getPrePeriodInfo((Context)this.ctx, (IObjectPK)new ObjectUuidPK(periodID));
                    if (prePeriod == null) {
                        String destPeriodIsNotExists = TDUtils.getString("com.kingdee.eas.tm.td.TDResource", "destPeriodIsNotExists", this.ctx.getLocale());
                        String badFuntion = TDUtils.getString("com.kingdee.eas.tm.td.TDResource", "BADFUNCTION", this.ctx.getLocale(), new Object[]{destPeriodIsNotExists});
                        param.getBackFiller().setValue((Object)badFuntion);
                        return;
                    }
                    if (prePeriod.isIsAdjustPeriod() && (prePeriod = PeriodUtils.getPrePeriodInfo((Context)this.ctx, (IObjectPK)new ObjectUuidPK(prePeriod.getId().toString()))) == null) {
                        String destPeriodIsNotExists = TDUtils.getString("com.kingdee.eas.tm.td.TDResource", "destPeriodIsNotExists", this.ctx.getLocale());
                        String badFuntion = TDUtils.getString("com.kingdee.eas.tm.td.TDResource", "BADFUNCTION", this.ctx.getLocale(), new Object[]{destPeriodIsNotExists});
                        param.getBackFiller().setValue((Object)badFuntion);
                        return;
                    }
                    periodID = prePeriod.getId().toString();
                }
            }
            if (StringUtils.isEmpty((String)companyNumber) && seftInfo != null && seftInfo.get("companyOrgUnit") != null) {
                companyNumber = ((CompanyOrgUnitInfo)seftInfo.get("companyOrgUnit")).getNumber();
            }
            if (StringUtils.isEmpty((String)taxTypeNumber) && seftInfo != null && seftInfo.get("taxType") != null) {
                taxTypeNumber = ((TaxItemTypeInfo)seftInfo.get("taxType")).getNumber();
            }
            if (StringUtils.isEmpty((String)buildingTaxesGroupNumber) && seftInfo != null && seftInfo.get("buildingTaxesGroup") != null) {
                buildingTaxesGroupNumber = ((RealEstateGroupInfo)seftInfo.get("buildingTaxesGroup")).getNumber();
            }
            if ((sheetInfo = StructureUtils.getTaxReportSheetByNumber(this.ctx, reportSheetNumber)) == null) {
                param.getBackFiller().setValue((Object)"");
                return;
            }
            String tblName = StructureDynamicTableManager.getPhysicalTblName(this.ctx, sheetInfo.getId().toString());
            if (StringUtils.isEmpty((String)tblName)) {
                param.getBackFiller().setValue((Object)"");
                return;
            }
            ArrayList<Object> paramList = new ArrayList<Object>();
            StringBuffer sql = new StringBuffer();
            sql.append("SELECT ISNULL(FValue2,TOCHAR(FValue1)) as FValue,FValueType FROM ").append(tblName).append(" as tbl ").append("\n");
            sql.append("LEFT JOIN T_ORG_Company company on company.fid = tbl.FCompanyID ").append("\n");
            sql.append("LEFT JOIN T_TM_TaxItemType taxType on taxType.fid = tbl.FTaxTypeID ").append("\n");
            sql.append("LEFT JOIN T_BD_Period period on period.fid = tbl.FPeriodID ").append("\n");
            if (!StringUtils.isEmpty((String)accountNumber)) {
                sql.append("LEFT JOIN T_TM_AccountConfig account on account.fid = tbl.FAccountConfigID ").append("\n");
            }
            sql.append("LEFT JOIN T_TD_RealEstateGroup taxesGroup on taxesGroup.fid = tbl.FBuildingTaxesGroupID ").append("\n");
            sql.append("LEFT JOIN T_TD_TaxReportSheet reportSheet on reportSheet.fid = tbl.FSheetID ").append("\n");
            sql.append("LEFT JOIN T_TD_TaxReportItem rowItem on rowItem.fid = tbl.FRowItemID ").append("\n");
            sql.append("LEFT JOIN T_TD_TaxReportItem columnItem on columnItem.fid = tbl.FColumnItemID ").append("\n");
            sql.append("WHERE 1=1 ");
            sql.append("AND company.FNumber = ? ");
            sql.append("AND tbl.FRecordType = ? ");
            paramList.add(companyNumber);
            paramList.add(recordTypeEnum.getValue());
            if (!StringUtils.isEmpty((String)taxTypeNumber)) {
                sql.append("AND taxType.FNumber = ? ");
                paramList.add(taxTypeNumber);
            }
            if (isPeriodOff) {
                sql.append("AND tbl.FPeriodID = ? ");
                paramList.add(periodID);
            } else {
                sql.append("AND period.FNumber = ? ");
                paramList.add(periodValue);
            }
            if (!StringUtils.isEmpty((String)accountNumber)) {
                sql.append("and account.FNumber = ? ");
                paramList.add(accountNumber);
            }
            if (!StringUtils.isEmpty((String)buildingTaxesGroupNumber)) {
                sql.append("and taxesGroup.FNumber = ? ");
                paramList.add(buildingTaxesGroupNumber);
            } else {
                sql.append("and taxesGroup.FNumber is null ");
            }
            sql.append("and reportSheet.FNumber = ? ");
            sql.append("and rowItem.FNumber = ? ");
            sql.append("and columnItem.FNumber = ? ");
            sql.append("ORDER BY tbl.FDraftRecordType DESC ");
            paramList.add(reportSheetNumber);
            paramList.add(rowItemNumber);
            paramList.add(columnItemNumber);
            IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString(), (Object[])paramList.toArray());
            Object value = null;
            String valueType = null;
            if (rs.next()) {
                value = rs.getObject("FValue");
                valueType = rs.getString("FValueType");
                if ("MONEY".equals(valueType)) {
                    param.getBackFiller().setValue((Object)new BigDecimal((String)value));
                } else {
                    param.getBackFiller().setValue(value);
                }
            } else {
                param.getBackFiller().setValue((Object)"");
            }
        }
        catch (Exception e) {
            param.getBackFiller().setException((Throwable)e);
        }
    }
}

