/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.rpt.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTBlock;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.swing.resource.KDResourceManager;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.TreeBaseInfo;
import com.kingdee.eas.tm.td.cloud.GroupFactory;
import com.kingdee.eas.tm.td.cloud.IGroup;
import com.kingdee.eas.tm.td.rpt.TaxAnalysisThemeInfo;
import com.kingdee.eas.tm.td.rpt.TaxDimSettingsMemberInfo;
import com.kingdee.eas.tm.td.rpt.client.AbstractTaxDimMemberF7UI;
import com.kingdee.eas.tm.td.rpt.utils.NumberExpandInfo;
import com.kingdee.eas.tm.td.rpt.utils.NumberExpendRender;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.apache.log4j.Logger;

public class TaxDimMemberF7UI
extends AbstractTaxDimMemberF7UI {
    private static final Logger logger = CoreUIObject.getLogger(TaxDimMemberF7UI.class);
    private String dimNumber = null;
    private String dimName = null;
    private TaxAnalysisThemeInfo themeInfo = null;
    protected List<TaxDimSettingsMemberInfo> dimMembers = null;
    public static final String DIM_NUMBER = "dimNumber";
    public static final String DIM_NAME = "dimName";
    public static final String DIM_MEMBERS = "dimMembers";
    public static final String THEME = "theme";
    protected static final String COL_NUMBER = "number";
    protected static final String COL_NAME = "name";
    protected static final String COL_ORGVIEW_YTPE = "orgViewType";
    private List<TaxDimSettingsMemberInfo> data = null;
    public List<DataBaseInfo> leftList = new ArrayList<DataBaseInfo>();
    public List<TaxDimSettingsMemberInfo> rightList = new ArrayList<TaxDimSettingsMemberInfo>();
    protected Map<String, DataBaseInfo> treeItems = new HashMap<String, DataBaseInfo>();
    protected List<DataBaseInfo> tmpLeft = null;
    protected List<TaxDimSettingsMemberInfo> tmpRight = null;
    private NumberExpendRender render = null;

    public NumberExpendRender getRender() {
        return this.render;
    }

    public void setRender(NumberExpendRender render) {
        this.render = render;
    }

    public void onLoad() throws Exception {
        this.beforeLoad();
        super.onLoad();
        this.afterLoad();
    }

    protected void beforeLoad() throws Exception {
        this.tblLeft.checkParsed();
        this.tblRight.checkParsed();
        this.initContext();
    }

    protected void initContext() {
        this.dimNumber = (String)this.getUIContext().get(DIM_NUMBER);
        this.dimName = (String)this.getUIContext().get(DIM_NAME);
        this.dimMembers = (List)this.getUIContext().get(DIM_MEMBERS);
        this.themeInfo = (TaxAnalysisThemeInfo)this.getUIContext().get(THEME);
    }

    protected void afterLoad() throws Exception {
        this.setRender(new NumberExpendRender(1));
        this.tblLeft.getColumn(COL_NUMBER).setRenderer((IBasicRender)this.getRender());
        this.initcbxDimension();
        this.getMembers();
        this.initTable();
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancel_actionPerformed(e);
        this.getUIWindow().close();
    }

    @Override
    protected void tblLeft_tableClicked(KDTMouseEvent e) throws Exception {
        int clickCount;
        if (e.getType() == 1) {
            int rowIndex = e.getRowIndex();
            int colIndex = e.getColIndex();
            int clickCount2 = e.getClickCount();
            if (clickCount2 == 1) {
                if (!this.dimNumber.equals("GroupDim") && !this.dimNumber.equals("CompanyDim")) {
                    return;
                }
                IRow row = this.tblLeft.getRow(rowIndex);
                if (row != null && colIndex == this.tblLeft.getColumn(COL_NUMBER).getColumnIndex()) {
                    NumberExpandInfo expandInfo = (NumberExpandInfo)row.getCell(COL_NUMBER).getValue();
                    if (this.getRender().inRect(expandInfo, e.getX(), e.getY())) {
                        this.setTreeDisplayStyle(row, expandInfo);
                    }
                }
            } else if (e.getClickCount() == 2) {
                this.btnAdd_actionPerformed(new ActionEvent(this.btnAdd, 0, null));
            }
        }
        if (e.getType() == 0 && ((clickCount = e.getClickCount()) == 1 || clickCount == 2)) {
            return;
        }
    }

    protected void setTreeDisplayStyle(IRow row, NumberExpandInfo expandInfo) throws Exception {
        Object obj = row.getUserObject();
        boolean isLeaf = ((TreeBaseInfo)obj).isIsLeaf();
        if (!isLeaf) {
            this.tblLeft.setRefresh(false);
            this.expandTable(row, expandInfo);
            this.tblLeft.setRefresh(true);
            this.tblLeft.reLayoutAndPaint();
        }
    }

    @Override
    protected void btnAdd_actionPerformed(ActionEvent e) throws Exception {
        super.btnAdd_actionPerformed(e);
        DataBaseInfo item = null;
        ArrayList<DataBaseInfo> tmpList = new ArrayList<DataBaseInfo>();
        ArrayList blocks = this.tblLeft.getSelectManager().getBlocks();
        for (int i = 0; i < blocks.size(); ++i) {
            KDTBlock block = this.swapBlock((KDTBlock)blocks.get(i));
            int top = block.getTop();
            int bottom = block.getBottom();
            for (int j = top; j <= bottom; ++j) {
                if (j < 0) continue;
                item = (DataBaseInfo)this.tblLeft.getRow(j).getUserObject();
                tmpList.add(item);
            }
        }
        HashSet<String> existsNum = new HashSet<String>();
        for (TaxDimSettingsMemberInfo member : this.rightList) {
            existsNum.add(member.getNumber());
        }
        HashSet<DataBaseInfo> rmItem = new HashSet<DataBaseInfo>();
        for (DataBaseInfo dbInfo : tmpList) {
            if (!existsNum.contains(dbInfo.getNumber())) continue;
            rmItem.add(dbInfo);
        }
        tmpList.removeAll(rmItem);
        this.rightList.addAll(this.convertToMemberList(tmpList));
        this.refreshTableRight();
    }

    protected KDTBlock swapBlock(KDTBlock block) {
        int bottom;
        int top = block.getTop();
        if (top > (bottom = block.getBottom())) {
            int tmp = block.getTop();
            block.setTop(block.getBottom());
            block.setBottom(tmp);
        }
        return block;
    }

    @Override
    protected void btnAddAll_actionPerformed(ActionEvent e) throws Exception {
        super.btnAddAll_actionPerformed(e);
        HashSet<String> existsNum = new HashSet<String>();
        for (TaxDimSettingsMemberInfo member : this.rightList) {
            existsNum.add(member.getNumber());
        }
        ArrayList<DataBaseInfo> tmpList = new ArrayList<DataBaseInfo>(this.tmpLeft);
        HashSet<DataBaseInfo> rmItem = new HashSet<DataBaseInfo>();
        for (DataBaseInfo dbInfo : tmpList) {
            if (!existsNum.contains(dbInfo.getNumber())) continue;
            rmItem.add(dbInfo);
        }
        tmpList.removeAll(rmItem);
        this.rightList.addAll(this.convertToMemberList(tmpList));
        this.refreshTableRight();
    }

    @Override
    protected void btnRemove_actionPerformed(ActionEvent e) throws Exception {
        super.btnRemove_actionPerformed(e);
        TaxDimSettingsMemberInfo dim = null;
        ArrayList<TaxDimSettingsMemberInfo> tmpList = new ArrayList<TaxDimSettingsMemberInfo>();
        ArrayList blocks = this.tblRight.getSelectManager().getBlocks();
        for (int i = 0; i < blocks.size(); ++i) {
            KDTBlock block = this.swapBlock((KDTBlock)blocks.get(i));
            int top = block.getTop();
            int bottom = block.getBottom();
            for (int j = top; j <= bottom; ++j) {
                dim = (TaxDimSettingsMemberInfo)this.tblRight.getRow(j).getUserObject();
                tmpList.add(dim);
            }
        }
        this.removeMember(tmpList);
    }

    @Override
    protected void btnRemoveAll_actionPerformed(ActionEvent e) throws Exception {
        super.btnRemoveAll_actionPerformed(e);
        this.removeMember(this.tmpRight);
    }

    protected void removeMember(List<TaxDimSettingsMemberInfo> tmpList) throws Exception {
        if (tmpList == null) {
            return;
        }
        this.rightList.removeAll(tmpList);
        this.refreshTableRight();
    }

    private void expandTable(IRow row, NumberExpandInfo parentExpandInfo) throws Exception {
        if (row == null) {
            return;
        }
        IRow child = null;
        int parentLevel = parentExpandInfo.getLevel();
        String longNumber = null;
        String parentLongNumber = null;
        NumberExpandInfo expandInfo = null;
        parentLongNumber = parentExpandInfo.getLongNumber();
        boolean isExpandStatus = parentExpandInfo.isExpandStatus();
        if (isExpandStatus) {
            parentExpandInfo.setExpandStatus(false);
            int rowCount = this.tblLeft.getRowCount3();
            for (int rowIndex = row.getRowIndex() + 1; rowIndex < rowCount && (longNumber = (expandInfo = (NumberExpandInfo)(child = this.tblLeft.getRow(rowIndex)).getCell(COL_NUMBER).getValue()).getLongNumber()).startsWith(parentLongNumber + "!"); ++rowIndex) {
                child.getStyleAttributes().setHided(true);
            }
        } else {
            parentExpandInfo.setExpandStatus(true);
            int rowCount = this.tblLeft.getRowCount3();
            for (int rowIndex = row.getRowIndex() + 1; rowIndex < rowCount && (longNumber = (expandInfo = (NumberExpandInfo)(child = this.tblLeft.getRow(rowIndex)).getCell(COL_NUMBER).getValue()).getLongNumber()).startsWith(parentLongNumber + "!"); ++rowIndex) {
                if (expandInfo.getLevel() - parentLevel != 1) continue;
                child.getStyleAttributes().setHided(false);
                if (expandInfo.isLeaf()) continue;
                expandInfo.setExpandStatus(false);
            }
        }
    }

    protected void initTable() throws Exception {
        this.tblRight.getColumn(COL_ORGVIEW_YTPE).getStyleAttributes().setHided(true);
        if (this.dimMembers != null) {
            this.data = new ArrayList<TaxDimSettingsMemberInfo>();
            this.data.addAll(this.dimMembers);
            TaxDimSettingsMemberInfo tmpMember = null;
            for (TaxDimSettingsMemberInfo member : this.dimMembers) {
                tmpMember = new TaxDimSettingsMemberInfo();
                tmpMember.setId(member.getId());
                tmpMember.setMemberId(member.getMemberId());
                tmpMember.setNumber(member.getNumber());
                tmpMember.setName(member.getName());
                tmpMember.setType(member.getType());
                this.rightList.add(tmpMember);
            }
        }
        this.refreshTableLeft();
        this.refreshTableRight();
        this.tblLeft.getSelectManager().select(0, 0);
    }

    public void refreshTableLeft() {
        this.tblLeft.removeRows();
        this.tmpLeft = this.leftList;
        String queryLeft = StringUtils.trim((String)this.txtQuickQueryInputLeft.getText());
        if (!StringUtils.isEmpty((String)queryLeft) && !queryLeft.equals("\u8bf7\u8f93\u5165\u8fc7\u6ee4\u6761\u4ef6")) {
            this.tmpLeft = this.filterLeft(this.leftList, queryLeft);
        }
        for (int i = 0; i < this.tmpLeft.size(); ++i) {
            DataBaseInfo item = this.tmpLeft.get(i);
            IRow row = this.tblLeft.addRow();
            row.setUserObject((Object)item);
            row.getCell(COL_NUMBER).setValue((Object)item.getNumber());
            row.getCell(COL_NAME).setValue((Object)item.getName());
        }
        this.afterDataFill();
    }

    protected void afterDataFill() {
        if (!this.dimNumber.equals("GroupDim") && !this.dimNumber.equals("CompanyDim")) {
            return;
        }
        String id = null;
        String number = null;
        String longNumber = null;
        String name = null;
        int level = 0;
        IRow row = null;
        TreeBaseInfo tbInfo = null;
        NumberExpandInfo expandInfo = null;
        for (int index = 0; index < this.tblLeft.getRowCount(); ++index) {
            row = this.tblLeft.getRow(index);
            if (row == null) continue;
            tbInfo = (TreeBaseInfo)row.getUserObject();
            id = tbInfo.getId().toString();
            number = tbInfo.getNumber();
            longNumber = tbInfo.getLongNumber();
            level = tbInfo.getLevel();
            name = tbInfo.getName();
            boolean isLeaf = tbInfo.isIsLeaf();
            expandInfo = new NumberExpandInfo();
            expandInfo.setId(id);
            expandInfo.setLevel(level);
            expandInfo.setLeaf(isLeaf);
            expandInfo.setName(name);
            expandInfo.setNumber(number);
            expandInfo.setLongNumber(longNumber);
            expandInfo.setExpandStatus(true);
            row.getCell(COL_NUMBER).setValue((Object)expandInfo);
            row.getCell(COL_NUMBER).setRenderer((IBasicRender)this.getRender());
        }
    }

    protected List<DataBaseInfo> filterLeft(List<DataBaseInfo> list, String queryStr) {
        if (list == null || StringUtils.isEmpty((String)queryStr)) {
            return list;
        }
        ArrayList<DataBaseInfo> tmpList = new ArrayList<DataBaseInfo>();
        for (DataBaseInfo item : list) {
            if (!item.getNumber().toLowerCase().contains(queryStr.toLowerCase()) && !item.getName().toLowerCase().contains(queryStr.toLowerCase())) continue;
            tmpList.add(item);
        }
        return tmpList;
    }

    public void refreshTableRight() {
        this.tblRight.removeRows();
        this.tmpRight = new ArrayList<TaxDimSettingsMemberInfo>(this.rightList);
        String queryRight = StringUtils.trim((String)this.txtQuickQueryInputRight.getText());
        if (!StringUtils.isEmpty((String)queryRight) && !queryRight.equals("\u8bf7\u8f93\u5165\u8fc7\u6ee4\u6761\u4ef6")) {
            this.tmpRight = this.filterRight(this.rightList, queryRight);
        }
        for (int i = 0; i < this.tmpRight.size(); ++i) {
            TaxDimSettingsMemberInfo item = this.tmpRight.get(i);
            IRow row = this.tblRight.addRow();
            row.setUserObject((Object)item);
            row.getCell(COL_NUMBER).setValue((Object)item.getNumber());
            row.getCell(COL_NAME).setValue((Object)item.getName());
        }
    }

    protected List<TaxDimSettingsMemberInfo> filterRight(List<TaxDimSettingsMemberInfo> list, String queryStr) {
        if (list == null || StringUtils.isEmpty((String)queryStr)) {
            return list;
        }
        ArrayList<TaxDimSettingsMemberInfo> tmpList = new ArrayList<TaxDimSettingsMemberInfo>();
        for (TaxDimSettingsMemberInfo item : list) {
            if (!item.getNumber().toLowerCase().contains(queryStr.toLowerCase()) && !item.getName().toLowerCase().contains(queryStr.toLowerCase())) continue;
            tmpList.add(item);
        }
        return tmpList;
    }

    protected void getMembers() throws Exception {
        CoreBaseCollection coll = null;
        EntityViewInfo view = new EntityViewInfo();
        view.getSorter().add(new SorterItemInfo(COL_NUMBER));
        if (this.dimNumber.equals("GroupDim")) {
            view.getSorter().clear();
            view.getSorter().add(new SorterItemInfo("longnumber"));
        }
        coll = this.getInterface().getCollection(view);
        for (int i = 0; i < coll.size(); ++i) {
            DataBaseInfo dbInfo = (DataBaseInfo)coll.get(i);
            this.leftList.add(dbInfo);
            this.treeItems.put(dbInfo.getId().toString(), dbInfo);
        }
    }

    protected void initcbxDimension() {
        this.cbxDimension.addItem((Object)this.dimName);
        this.cbxDimension.setEnabled(false);
    }

    public void initWorkButton() {
        super.initWorkButton();
        this.btnAdd.setIcon(EASResource.getIcon((String)"imgTbtn_move_right"));
        this.btnAddAll.setIcon(EASResource.getIcon((String)"imgTbtn_moveall_right"));
        this.btnRemove.setIcon(EASResource.getIcon((String)"imgTbtn_move_left"));
        this.btnRemoveAll.setIcon(EASResource.getIcon((String)"imgTbtn_moveall_left"));
        this.txtQuickQueryInputLeft.setText("\u8bf7\u8f93\u5165\u8fc7\u6ee4\u6761\u4ef6");
        this.txtQuickQueryInputRight.setText("\u8bf7\u8f93\u5165\u8fc7\u6ee4\u6761\u4ef6");
        this.quickQueryButtonLeft.setIcon((Icon)new ImageIcon(KDResourceManager.getImageOfRapid((String)"prompt_off.gif")));
        this.quickQueryButtonLeft.setBackground(new Color(7645403));
        this.quickQueryButtonLeft.setDisabledIcon((Icon)new ImageIcon(KDResourceManager.getImageOfRapid((String)"prompt_disable.gif")));
        this.quickQueryButtonRight.setIcon((Icon)new ImageIcon(KDResourceManager.getImageOfRapid((String)"prompt_off.gif")));
        this.quickQueryButtonRight.setBackground(new Color(7645403));
        this.quickQueryButtonRight.setDisabledIcon((Icon)new ImageIcon(KDResourceManager.getImageOfRapid((String)"prompt_disable.gif")));
    }

    protected ICoreBase getInterface() throws Exception {
        IGroup remoteIns = null;
        if (this.dimNumber.equals("GroupDim")) {
            remoteIns = GroupFactory.getRemoteInstance();
        } else if (this.dimNumber.equals("CompanyDim")) {
            remoteIns = CompanyOrgUnitFactory.getRemoteInstance();
        }
        return remoteIns;
    }

    protected List<TaxDimSettingsMemberInfo> convertToMemberList(List<DataBaseInfo> items) {
        ArrayList<TaxDimSettingsMemberInfo> memberList = new ArrayList<TaxDimSettingsMemberInfo>();
        for (DataBaseInfo item : items) {
            TaxDimSettingsMemberInfo member = new TaxDimSettingsMemberInfo();
            member.setMemberId(item.getId().toString());
            member.setNumber(item.getNumber());
            member.setName(item.getName());
            memberList.add(member);
        }
        return memberList;
    }

    protected List<DataBaseInfo> convertToItemList(List<TaxDimSettingsMemberInfo> members) {
        ArrayList<DataBaseInfo> itemList = new ArrayList<DataBaseInfo>();
        DataBaseInfo item = null;
        for (TaxDimSettingsMemberInfo member : members) {
            item = this.treeItems.get(member.getMemberId().toString());
            itemList.add(item);
        }
        return itemList;
    }

    @Override
    protected void btnOk_actionPerformed(ActionEvent e) throws Exception {
        super.btnOk_actionPerformed(e);
        this.generateSeqForRightList();
        this.data = this.rightList.size() == 0 ? null : this.rightList;
        this.getUIWindow().close();
    }

    protected void generateSeqForRightList() {
        for (int i = 0; i < this.rightList.size(); ++i) {
            TaxDimSettingsMemberInfo member = this.rightList.get(i);
            member.setSeq(i + 1);
        }
    }

    public Object getData() {
        return this.data;
    }
}

