/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.solutionmgr.impexp.cache;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.tm.td.solutionmgr.impexp.util.DbUtils;
import com.kingdee.eas.tm.td.solutionmgr.tools.KSQDataExport;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ResultSetCache
implements Serializable {
    private static final long serialVersionUID = -1987376193369024133L;
    private String[] columns;
    private int[] types;
    private List<String> blobColumn = new ArrayList<String>();
    private Map columnIndexMap;
    private int recordCount;
    private List recordList;
    private int recordIndex;
    private List normalColumns = new ArrayList();

    public ResultSetCache(String[] columns, int[] types, List recordList) {
        this.columns = columns;
        this.recordList = recordList;
        this.initMe();
    }

    public boolean hasBlobFields() {
        return this.blobColumn.size() > 0;
    }

    private void initMe() {
        this.recordCount = this.recordList.size();
        this.recordIndex = -1;
        int n = this.columns.length;
        this.columnIndexMap = new HashMap((int)((float)n / 0.75f));
        for (int i = 0; i < this.columns.length; ++i) {
            this.columnIndexMap.put(this.columns[i].toLowerCase(), new Integer(i));
        }
    }

    public static ResultSetCache parse(Context ctx, ResultSet rs, Map params) throws SQLException, BOSException {
        String tblName = (String)params.get("tblName");
        ResultSetMetaData rsm = rs.getMetaData();
        String[] columns = new String[rsm.getColumnCount()];
        int[] types = new int[rsm.getColumnCount()];
        ArrayList<String> normalColumns = new ArrayList<String>();
        ArrayList<String> blobColumn = new ArrayList<String>();
        for (int i = 0; i < rsm.getColumnCount(); ++i) {
            columns[i] = rsm.getColumnName(i + 1);
            types[i] = rsm.getColumnType(i + 1);
            if (!rsm.isAutoIncrement(i + 1)) {
                normalColumns.add(columns[i]);
            }
            if (types[i] != 2004) continue;
            blobColumn.add(columns[i]);
        }
        ArrayList<Object> row = null;
        ArrayList recordList = new ArrayList(100);
        Blob bb = null;
        String columnName = null;
        while (rs.next()) {
            row = new ArrayList<Object>(rsm.getColumnCount());
            for (int i = 1; i <= rsm.getColumnCount(); ++i) {
                columnName = rsm.getColumnName(i);
                if (types[i - 1] == 2004) {
                    bb = rs.getBlob(i);
                    if (bb == null) {
                        row.add(null);
                        continue;
                    }
                    row.add(bb.getBytes(1L, (int)bb.length()));
                    continue;
                }
                String value = null;
                value = KSQDataExport.dealData(rs, rsm, i);
                if (value == null) {
                    value = "null";
                } else {
                    int isNullable = rsm.isNullable(i);
                    if (value.equals("null") && isNullable == 0) {
                        value = DbUtils.getDefaultValue(ctx, tblName, rsm, i);
                    }
                }
                row.add(value);
            }
            recordList.add(row);
        }
        ResultSetCache cache = new ResultSetCache(columns, types, recordList);
        cache.setBlobColumn(blobColumn);
        cache.setNormalColumns(normalColumns);
        return cache;
    }

    public int getRowCount() {
        return this.recordList.size();
    }

    public void reset() {
        this.recordIndex = -1;
    }

    public boolean next() {
        if (this.recordIndex >= this.recordCount - 1) {
            return false;
        }
        ++this.recordIndex;
        return true;
    }

    public boolean first() {
        if (this.recordCount > 0) {
            this.recordIndex = 0;
            return true;
        }
        this.recordIndex = -1;
        return false;
    }

    public boolean last() {
        this.recordIndex = this.recordCount - 1;
        return this.recordIndex >= 0;
    }

    public boolean previous() {
        if (this.recordIndex > 0) {
            --this.recordIndex;
            return true;
        }
        return false;
    }

    public Object getObject(int index, Object nullWith) {
        Object obj = this.getObject(index);
        return obj == null ? nullWith : obj;
    }

    public Object getObject(int index) {
        return ((List)this.recordList.get(this.recordIndex)).get(index);
    }

    public String getString(int index) {
        return (String)this.getObject(index);
    }

    public Object getObject(String columnName, Object nullWith) {
        Object obj = this.getObject(columnName);
        return obj == null ? nullWith : obj;
    }

    public Object getObject(String columnName) {
        return this.getObject(this.getColumnIndexByName(columnName));
    }

    public String getString(String columnName) {
        return this.getString(this.getColumnIndexByName(columnName));
    }

    public int getColumnIndexByName(String columnName) {
        Integer index = (Integer)this.columnIndexMap.get(columnName.toLowerCase());
        if (index == null) {
            throw new RuntimeException("Unknow column \"" + columnName + "\".");
        }
        return index;
    }

    public int getInt(int index) {
        Object obj = this.getObject(index);
        return this.convertToInt(obj);
    }

    private int convertToInt(Object obj) {
        if (obj instanceof BigDecimal) {
            return ((BigDecimal)obj).intValue();
        }
        if (obj instanceof Long) {
            return ((Long)obj).intValue();
        }
        if (obj instanceof Float) {
            return ((Float)obj).intValue();
        }
        if (obj instanceof Double) {
            return ((Double)obj).intValue();
        }
        return (Integer)obj;
    }

    public int getInt(int index, int nullWith) {
        Object obj = this.getObject(index);
        if (obj == null) {
            return nullWith;
        }
        return this.convertToInt(obj);
    }

    public long getLong(int index) {
        Object obj = this.getObject(index);
        if (obj instanceof BigDecimal) {
            return ((BigDecimal)obj).longValue();
        }
        return new Long(String.valueOf(obj));
    }

    public long getLong(int index, long nullWith) {
        Object obj = this.getObject(index);
        if (obj == null) {
            return nullWith;
        }
        if (obj instanceof BigDecimal) {
            return ((BigDecimal)obj).longValue();
        }
        return new Long(String.valueOf(obj));
    }

    public BigDecimal getBigDecimal(int index) {
        Object obj = this.getObject(index);
        if (obj == null) {
            return null;
        }
        if (obj instanceof BigDecimal) {
            return (BigDecimal)obj;
        }
        return new BigDecimal(String.valueOf(obj));
    }

    public float getFloat(int index) {
        Object obj = this.getObject(index);
        if (obj instanceof BigDecimal) {
            return ((BigDecimal)obj).floatValue();
        }
        return new Float(String.valueOf(obj)).floatValue();
    }

    public float getFloat(int index, float nullWith) {
        Object obj = this.getObject(index);
        if (obj == null) {
            return nullWith;
        }
        if (obj instanceof BigDecimal) {
            return ((BigDecimal)obj).floatValue();
        }
        return new Float(String.valueOf(obj)).floatValue();
    }

    public double getDouble(int index) {
        Object obj = this.getObject(index);
        if (obj instanceof BigDecimal) {
            return ((BigDecimal)obj).doubleValue();
        }
        return new Double(String.valueOf(obj));
    }

    public double getDouble(int index, double nullWith) {
        Object obj = this.getObject(index);
        if (obj == null) {
            return nullWith;
        }
        if (obj instanceof BigDecimal) {
            return ((BigDecimal)obj).doubleValue();
        }
        return new Double(String.valueOf(obj));
    }

    public boolean getBoolean(int index, boolean nullWith) {
        Object bb = this.getObject(index);
        if (bb == null) {
            return nullWith;
        }
        if (bb instanceof Boolean) {
            return (Boolean)bb;
        }
        return Boolean.valueOf(String.valueOf(bb));
    }

    public boolean isNull(int index) {
        return null == this.getObject(index);
    }

    public boolean isNumber(int index) {
        Object obj = this.getObject(index);
        return obj != null && (obj instanceof BigDecimal || obj instanceof Integer || obj instanceof Float || obj instanceof Double);
    }

    public int getColumnType(String columnName) {
        int columnIndex = this.getColumnIndexByName(columnName);
        return this.types[columnIndex];
    }

    public int getColumnType(int columnIndex) {
        return this.types[columnIndex];
    }

    public String[] getColumns() {
        return this.columns;
    }

    public void setColumns(String[] columns) {
        this.columns = columns;
    }

    public Map getColumnIndexMap() {
        return this.columnIndexMap;
    }

    public void setColumnIndexMap(Map columnIndexMap) {
        this.columnIndexMap = columnIndexMap;
    }

    public int getRecordCount() {
        return this.recordCount;
    }

    public void setRecordCount(int recordCount) {
        this.recordCount = recordCount;
    }

    public List getRecordList() {
        return this.recordList;
    }

    public void setRecordList(List recordList) {
        this.recordList = recordList;
    }

    public int getRecordIndex() {
        return this.recordIndex;
    }

    public void setRecordIndex(int recordIndex) {
        this.recordIndex = recordIndex;
    }

    public int[] getTypes() {
        return this.types;
    }

    public void setTypes(int[] types) {
        this.types = types;
    }

    public List getNormalColumns() {
        return this.normalColumns;
    }

    public void setNormalColumns(List normalColumns) {
        this.normalColumns = normalColumns;
    }

    public List<String> getBlobColumn() {
        return this.blobColumn;
    }

    public void setBlobColumn(List<String> blobColumn) {
        this.blobColumn = blobColumn;
    }
}

