/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.solutionmgr.impexp.model;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.td.solutionmgr.SolutionMgrFacadeFactory;
import com.kingdee.eas.tm.td.solutionmgr.impexp.cache.ResultSetCache;
import com.kingdee.eas.tm.td.solutionmgr.impexp.model.TableModel;
import com.kingdee.eas.tm.td.solutionmgr.impexp.util.FileUtil;
import com.kingdee.eas.tm.td.solutionmgr.impexp.util.ImpExpUtil;
import com.kingdee.eas.tm.td.utils.IOUtils;
import com.kingdee.util.StringUtils;
import java.io.BufferedWriter;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class TablePageModel
implements Serializable {
    private static final long serialVersionUID = 8218592319294890110L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.td.solutionmgr.impexp.model.TablePageModel");
    private TableModel model = null;
    private int pageNo = 0;

    public TablePageModel(TableModel model, int pageNo) {
        this.model = model;
        this.pageNo = pageNo;
    }

    public ResultSetCache getResultSet() throws EASBizException, BOSException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("sql", this.getSQL());
        params.put("from", this.getFrom());
        params.put("len", this.getLen());
        params.put("tblName", this.model.getTblName());
        Map ret = SolutionMgrFacadeFactory.getRemoteInstance().getRecordList(params);
        ResultSetCache rs = (ResultSetCache)ret.get("rs");
        return rs;
    }

    private String getSQL() {
        StringBuffer sql = new StringBuffer();
        sql.append(this.getModel().getSql());
        if (!StringUtils.isEmpty((String)this.getModel().getFilter())) {
            sql.append(this.getModel().getFilter());
        }
        return sql.toString();
    }

    private int getFrom() {
        return this.pageNo * this.getModel().getPageSize();
    }

    private int getLen() {
        return this.getModel().getPageSize();
    }

    public void out() throws EASBizException, BOSException {
        ResultSetCache rs = this.getResultSet();
        this.outTable(rs);
        this.outBlob(rs);
    }

    private void outTable(ResultSetCache rs) throws BOSException, EASBizException {
        File tempFile = FileUtil.createTableFile(this);
        String str = null;
        String fid = null;
        StringBuffer idStr = new StringBuffer();
        BufferedWriter out = null;
        try {
            out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(tempFile, true), "utf-8"));
            while (rs.next()) {
                fid = rs.getString("FID");
                if (rs.getRecordIndex() > 0) {
                    idStr.append(",");
                }
                idStr.append(fid);
                str = this.getConditionSQL(fid);
                out.write(str);
                out.newLine();
                out.flush();
                str = this.getInsertSQL(rs);
                out.write(str);
                out.newLine();
                out.flush();
            }
            str = this.getTotalStr();
            out.write(str);
            out.newLine();
            out.flush();
            FileUtil.writeEncodeFile(tempFile);
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.close(out);
                throw throwable;
            }
        }
        IOUtils.close(out);
        if (this.model.isMainTable() || rs.hasBlobFields()) {
            this.outTableId(idStr.toString());
        }
    }

    private void outTableId(String content) throws BOSException, EASBizException {
        BufferedWriter out = null;
        File tempFile = FileUtil.createTableIdFile(this);
        try {
            out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(tempFile, true), "utf-8"));
            out.write(content);
            out.flush();
            FileUtil.writeEncodeFile(tempFile);
        }
        catch (IOException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.close(out);
                throw throwable;
            }
        }
        IOUtils.close(out);
    }

    private void outBlob(ResultSetCache rs) throws BOSException {
        rs.reset();
        List<String> blobColumn = rs.getBlobColumn();
        String columnName = null;
        byte[] data = null;
        File file = null;
        while (rs.next()) {
            for (int i = 0; i < blobColumn.size(); ++i) {
                columnName = blobColumn.get(i);
                data = (byte[])rs.getObject(columnName);
                if (data == null) continue;
                file = FileUtil.createBlobFile(this, columnName, rs.getRecordIndex());
                DataOutputStream dos = null;
                try {
                    dos = new DataOutputStream(new FileOutputStream(file));
                    dos.write(data, 0, data.length);
                    dos.flush();
                }
                catch (Exception e) {
                    try {
                        throw new BOSException((Throwable)e);
                    }
                    catch (Throwable throwable) {
                        IOUtils.close(dos);
                        throw throwable;
                    }
                }
                IOUtils.close(dos);
                continue;
            }
        }
    }

    private String getConditionSQL(String fid) {
        return ImpExpUtil.getInsertConditionSQL(this.model.getTblName(), fid);
    }

    private String getInsertSQL(ResultSetCache rs) {
        StringBuffer sql = new StringBuffer();
        sql = new StringBuffer(" insert into ").append(this.model.getTblName());
        sql.append("(");
        sql.append(this.getColumns(rs)).append(") values (");
        sql.append(this.getColumnValues(rs)).append(")").append(";");
        return sql.toString();
    }

    private String getColumns(ResultSetCache rs) {
        List columns = rs.getNormalColumns();
        StringBuffer columnStr = new StringBuffer();
        int size = columns.size();
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                columnStr.append(",");
            }
            columnStr.append(columns.get(i));
        }
        return columnStr.toString();
    }

    private String getColumnValues(ResultSetCache rs) {
        List columns = rs.getNormalColumns();
        StringBuffer valuesBuff = new StringBuffer();
        String value = null;
        String columnName = null;
        for (int i = 0; i < columns.size(); ++i) {
            columnName = (String)columns.get(i);
            if (i > 0) {
                valuesBuff.append(",");
            }
            if (rs.getBlobColumn().contains(columnName)) {
                value = "null";
            } else {
                value = rs.getString(i);
                if (StringUtils.isEmpty((String)value)) {
                    value = "''";
                }
            }
            valuesBuff.append(value);
        }
        return valuesBuff.toString();
    }

    private String getTotalStr() {
        return "";
    }

    public TableModel getModel() {
        return this.model;
    }

    public void setModel(TableModel model) {
        this.model = model;
    }

    public int getPageNo() {
        return this.pageNo;
    }

    public void setPageNo(int pageNo) {
        this.pageNo = pageNo;
    }
}

