/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.structure.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.impl.facade.rangesel.RangeSelector;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.newrpt.client.designer.SpreadManager;
import com.kingdee.eas.tm.td.TDUtils;
import com.kingdee.eas.tm.td.structure.client.AbstractItemFormulaAnalysisUI;
import com.kingdee.eas.tm.td.structure.utils.TaxItemFormula;
import com.kingdee.eas.tm.td.utils.Location;
import com.kingdee.util.StringUtils;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public class ItemFormulaAnalysisUI
extends AbstractItemFormulaAnalysisUI {
    private static final Logger logger = CoreUIObject.getLogger(ItemFormulaAnalysisUI.class);
    private Sheet rptSheet = null;
    private SpreadManager spreadManager = null;
    private IObjectValue editData = null;
    private PropertyChangeListener propertyChangeListener = null;
    private RangeSelector selectorChooser = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.initContext();
        this.initControl();
        this.addListener();
    }

    private void initContext() {
        this.rptSheet = (Sheet)this.getUIContext().get("rptSheet");
        this.spreadManager = (SpreadManager)this.getUIContext().get("spreadManager");
        this.editData = (IObjectValue)this.getUIContext().get("editData");
    }

    private void initControl() {
        this.selectorChooser = this.initSelectedRange(this.selectorContainer);
        this.cbIsShowMark.setSelected(true);
    }

    private RangeSelector initSelectedRange(KDLabelContainer container) {
        RangeSelector chooser = this.spreadManager.createRangeSelector(TDUtils.getString("com.kingdee.eas.tm.td.structure.TaxStructureResource", "SELECTAREA", TDUtils.getLocale()));
        container.setBoundEditor((JComponent)chooser);
        return chooser;
    }

    protected void addListener() {
        if (this.propertyChangeListener == null) {
            this.propertyChangeListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    try {
                        ItemFormulaAnalysisUI.this.properyChange(e);
                    }
                    catch (Exception e1) {
                        ItemFormulaAnalysisUI.this.handUIException(e1);
                    }
                }
            };
            this.selectorChooser.addPropertyChangeListener("RangeSelected", this.propertyChangeListener);
        }
    }

    private void properyChange(PropertyChangeEvent e) throws EASBizException, BOSException {
        List<TaxItemFormula> formulaList = this.parseItemFormulaBySheetArea();
        if (formulaList == null) {
            this.txtColumnItems.setText("");
            this.txtRowItems.setText("");
        } else {
            ArrayList<String> rowItems = new ArrayList<String>();
            ArrayList<String> columnItems = new ArrayList<String>();
            TaxItemFormula itemFormula2 = null;
            for (TaxItemFormula itemFormula2 : formulaList) {
                if (!rowItems.contains(itemFormula2.getRowItem())) {
                    rowItems.add(itemFormula2.getRowItem());
                }
                if (columnItems.contains(itemFormula2.getColumnItem())) continue;
                columnItems.add(itemFormula2.getColumnItem());
            }
            this.txtColumnItems.setText(this.getItemString(columnItems));
            this.txtRowItems.setText(this.getItemString(rowItems));
        }
    }

    private String getItemString(List items) {
        boolean isShowMark = this.cbIsShowMark.isSelected();
        StringBuffer itemTxt = new StringBuffer();
        int size = items.size();
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                itemTxt.append(",");
            }
            if (isShowMark) {
                itemTxt.append("\"").append(items.get(i)).append("\"");
                continue;
            }
            itemTxt.append(items.get(i));
        }
        return itemTxt.toString();
    }

    public List<TaxItemFormula> parseItemFormulaBySheetArea() throws EASBizException, BOSException {
        String rangeText = this.selectorChooser.getText();
        if (StringUtils.isEmpty((String)rangeText)) {
            return null;
        }
        String[] str = rangeText.split("!");
        if (str.length <= 1) {
            return null;
        }
        String[] cells = str[1].split(":");
        int[] point1 = Location.getCellRowAndColumn(cells[0]);
        int[] point2 = null;
        if (cells.length > 1) {
            point2 = Location.getCellRowAndColumn(cells[1]);
        }
        int row1 = point1[0];
        int column1 = point1[1];
        int row2 = point1[0];
        int column2 = point1[1];
        if (point2 != null) {
            row2 = point2[0];
            column2 = point2[1];
        }
        ArrayList<TaxItemFormula> list = new ArrayList<TaxItemFormula>();
        Sheet.ICellsIterator iter = this.rptSheet.getCellsIterator(row1, column1, row2, column2, true, true);
        while (iter.hasNext()) {
            Cell cell = iter.next();
            Range range = this.rptSheet.getRange(cell);
            TaxItemFormula f = (TaxItemFormula)range.getUserObject("TAXITEM");
            if (f == null || f.getFormula() == null) continue;
            f.setSheet(this.rptSheet);
            f.setCell(cell);
            StringBuffer key = new StringBuffer();
            key.append(f.getReportSheet()).append("_");
            key.append(f.getRowItem()).append("_");
            key.append(f.getColumnItem()).append("_");
            key.append(f.getValueType());
            list.add(f);
        }
        return list;
    }
}

