/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.structure.client;

import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.PreChangeEvent;
import com.kingdee.bos.ctrl.swing.event.PreChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.fi.newrpt.client.designer.SpreadManager;
import com.kingdee.eas.fi.rpt.excelformula.ExcelFormulaPaserHelper;
import com.kingdee.eas.fi.rpt.excelformula.expr.Expression;
import com.kingdee.eas.fi.rpt.excelformula.expr.FunctionExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.StringExpr;
import com.kingdee.eas.tm.td.TDUtils;
import com.kingdee.eas.tm.td.TaxDraftRecordInfo;
import com.kingdee.eas.tm.td.cloud.utils.TDCloudUtil;
import com.kingdee.eas.tm.td.structure.ReportItemDimensionEnum;
import com.kingdee.eas.tm.td.structure.TaxItemFormulaFacadeFactory;
import com.kingdee.eas.tm.td.structure.TaxReportItemInfo;
import com.kingdee.eas.tm.td.structure.TaxReportSheetInfo;
import com.kingdee.eas.tm.td.structure.TaxReportTemplateInfo;
import com.kingdee.eas.tm.td.structure.TaxValueTypeEnum;
import com.kingdee.eas.tm.td.structure.client.AbstractItemFormulaWizardUI;
import com.kingdee.eas.tm.td.structure.client.TaxReportItemSelector;
import com.kingdee.eas.tm.td.structure.utils.StructureUtils;
import com.kingdee.eas.tm.td.structure.utils.TaxItemFormula;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class ItemFormulaWizardUI
extends AbstractItemFormulaWizardUI {
    private static final Logger logger = CoreUIObject.getLogger(ItemFormulaWizardUI.class);
    private Sheet rptSheet = null;
    private IObjectValue editData = null;
    private SpreadManager spreadManager = null;
    private Range cellRange = null;
    private DataChangeListener reportSheetChangeListener = null;
    private boolean isCanceled = false;

    protected void initListener() {
        this.reportSheetChangeListener = new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                if (TDCloudUtil.isEqual(e.getNewValue(), e.getOldValue())) {
                    return;
                }
                try {
                    ItemFormulaWizardUI.this.reportSheet_dataChanged(e);
                }
                catch (Exception e1) {
                    ItemFormulaWizardUI.this.handleException(e1);
                }
            }
        };
        this.prmtReportSheet.addDataChangeListener(this.reportSheetChangeListener);
    }

    protected void reportSheet_dataChanged(DataChangeEvent e) throws Exception {
        if (TDCloudUtil.isEqual(e.getNewValue(), e.getOldValue())) {
            return;
        }
        this.prmtReportRowItem.setValue(null);
        this.prmtReportColumnItem.setValue(null);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.afterLoad();
    }

    protected void afterLoad() throws Exception {
        this.initContext();
        this.initParamaters();
        this.initControl();
        this.setF7Filter();
    }

    protected void initContext() {
        this.rptSheet = (Sheet)this.getUIContext().get("rptSheet");
        this.spreadManager = (SpreadManager)this.getUIContext().get("spreadManager");
        this.editData = (IObjectValue)this.getUIContext().get("editData");
        this.cellRange = this.rptSheet.getActiveCellRange();
    }

    protected void initParamaters() throws Exception {
        TaxItemFormula itemFormula = (TaxItemFormula)this.cellRange.getUserObject("TAXITEM");
        if (itemFormula != null) {
            Expression exp;
            String formula = itemFormula.toString();
            FunctionExpr function = null;
            if (!StringUtils.isEmpty((String)formula) && (exp = ExcelFormulaPaserHelper.parse((String)formula)) instanceof FunctionExpr) {
                function = (FunctionExpr)exp;
            }
            if (function != null) {
                String[] params = new String[function.parameters.size()];
                for (int i = 0; i < function.parameters.size(); ++i) {
                    Expression e = (Expression)function.parameters.get(i);
                    params[i] = e instanceof StringExpr ? ((StringExpr)e).value : e.toString();
                }
                List paramList = TaxItemFormulaFacadeFactory.getRemoteInstance().loadItemParamaters(params);
                TaxReportSheetInfo sheetInfo = (TaxReportSheetInfo)paramList.get(0);
                TaxReportItemInfo rowItemInfo = (TaxReportItemInfo)paramList.get(1);
                TaxReportItemInfo columnItemInfo = (TaxReportItemInfo)paramList.get(2);
                TaxValueTypeEnum valueType = (TaxValueTypeEnum)((Object)paramList.get(3));
                this.prmtReportSheet.setValue((Object)sheetInfo);
                this.prmtReportRowItem.setValue((Object)rowItemInfo);
                this.prmtReportColumnItem.setValue((Object)columnItemInfo);
                this.cbDataType.setSelectedItem((Object)valueType);
            }
        }
    }

    protected void setF7Filter() {
        if (this.editData instanceof TaxReportTemplateInfo) {
            TaxReportTemplateInfo templateInfo = (TaxReportTemplateInfo)this.editData;
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("taxType.id", (Object)templateInfo.getTaxType().getId(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("recordType", (Object)templateInfo.getRecordType().getValue(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("state", (Object)"2", CompareType.EQUALS));
            view.setFilter(filter);
            this.prmtReportSheet.setEntityViewInfo(view);
        } else if (this.editData instanceof TaxDraftRecordInfo) {
            TaxDraftRecordInfo reportInfo = (TaxDraftRecordInfo)this.editData;
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("taxType.id", (Object)reportInfo.getTaxType().getId(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("recordType", (Object)reportInfo.getRecordType().getValue(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("state", (Object)"2", CompareType.EQUALS));
            view.setFilter(filter);
            this.prmtReportSheet.setEntityViewInfo(view);
        }
    }

    protected void initControl() {
        this.prmtReportSheet.setHistoryRecordEnabled(false);
        this.prmtReportRowItem.setHistoryRecordEnabled(false);
        this.prmtReportColumnItem.setHistoryRecordEnabled(false);
        this.initItemF7(this.prmtReportRowItem);
        this.initItemF7(this.prmtReportColumnItem);
    }

    protected void initItemF7(KDBizPromptBox box) {
        box.setEditable(false);
        box.setRefresh(false);
        box.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                KDPromptBox f7Box = (KDPromptBox)e.getSource();
                TaxReportSheetInfo sheetInfo = (TaxReportSheetInfo)ItemFormulaWizardUI.this.prmtReportSheet.getValue();
                if (sheetInfo == null) {
                    MsgBox.showInfo((String)TDUtils.getString("com.kingdee.eas.tm.td.structure.TaxStructureResource", "INPUTREPORTSHEET", TDUtils.getLocale()));
                    ItemFormulaWizardUI.this.prmtReportSheet.requestFocus();
                    SysUtil.abort();
                }
                ReportItemDimensionEnum itemDimension = null;
                ArrayList<Object> rptItemSelected = new ArrayList<Object>();
                if (f7Box.getValue() != null) {
                    rptItemSelected.add(f7Box.getValue());
                }
                if (f7Box.getName().equals("prmtReportRowItem")) {
                    itemDimension = ReportItemDimensionEnum.ROW;
                } else if (f7Box.getName().equals("prmtReportColumnItem")) {
                    itemDimension = ReportItemDimensionEnum.COLUMN;
                }
                TaxReportItemSelector selector = new TaxReportItemSelector(sheetInfo, itemDimension, rptItemSelected);
                selector.setEnabledMultiSelection(false);
                f7Box.setSelector((KDPromptSelector)selector);
            }
        });
        box.addPreChangeListener(new PreChangeListener(){

            public void preChange(PreChangeEvent e) {
                KDPromptBox f7Box = (KDPromptBox)e.getSource();
                e.setResult(1);
            }
        });
    }

    protected void checkRequiredFields() {
        StringBuffer sb = new StringBuffer();
        if (this.prmtReportSheet.getValue() == null) {
            sb.append(TDUtils.getString("com.kingdee.eas.tm.td.structure.TaxStructureResource", "ReportSheet", TDUtils.getLocale()));
        }
        if (this.prmtReportRowItem.getValue() == null) {
            if (sb.length() > 0) {
                sb.append("\u3001");
            }
            sb.append(TDUtils.getString("com.kingdee.eas.tm.td.structure.TaxStructureResource", "RowItem", TDUtils.getLocale()));
        }
        if (this.prmtReportColumnItem.getValue() == null) {
            if (sb.length() > 0) {
                sb.append("\u3001");
            }
            sb.append(TDUtils.getString("com.kingdee.eas.tm.td.structure.TaxStructureResource", "ColumnItem", TDUtils.getLocale()));
        }
        if (sb.length() > 0) {
            sb.append(TDUtils.getString("com.kingdee.eas.tm.td.structure.TaxStructureResource", "NotNull", TDUtils.getLocale()));
            MsgBox.showInfo((String)sb.toString());
            SysUtil.abort();
        }
        this.checkItemFormulaUnique();
    }

    private void checkItemFormulaUnique() {
        TaxReportSheetInfo sheetInfo = (TaxReportSheetInfo)this.prmtReportSheet.getValue();
        TaxReportItemInfo rowItem = (TaxReportItemInfo)this.prmtReportRowItem.getValue();
        TaxReportItemInfo columnItem = (TaxReportItemInfo)this.prmtReportColumnItem.getValue();
        Map itemData = StructureUtils.getItemformulaByBook(this.spreadManager.getSpreadContainer().getBook());
        StringBuffer key = new StringBuffer();
        StringBuffer sb = new StringBuffer();
        key.setLength(0);
        key.append(sheetInfo.getNumber()).append("_");
        key.append(rowItem.getNumber()).append("_");
        key.append(columnItem.getNumber());
        TaxItemFormula itemFormula = (TaxItemFormula)itemData.get(key.toString());
        String location = StructureUtils.getCellLocation(this.rptSheet, this.cellRange);
        if (itemFormula != null && !location.equals(itemFormula.getLocation())) {
            sb.append(TDUtils.getString("com.kingdee.eas.tm.td.structure.TaxStructureResource", "ItemFormulaSaveError", TDUtils.getLocale(), new Object[]{rowItem.getNumber() + "_" + columnItem.getNumber()}));
        }
        if (sb.length() > 0) {
            String error = TDUtils.getString("com.kingdee.eas.tm.td.structure.TaxStructureResource", "BatchSaveItemFormulaError", TDUtils.getLocale());
            String errorDetail = sb.toString();
            MsgBox.showDetailAndOK((Component)((Object)this), (String)error, (String)errorDetail, (int)8188);
            SysUtil.abort();
        }
    }

    @Override
    public void actionOK_actionPerformed(ActionEvent e) throws Exception {
        this.checkRequiredFields();
        TaxReportSheetInfo sheetInfo = (TaxReportSheetInfo)this.prmtReportSheet.getValue();
        TaxReportItemInfo rowItemInfo = (TaxReportItemInfo)this.prmtReportRowItem.getValue();
        TaxReportItemInfo columnItemInfo = (TaxReportItemInfo)this.prmtReportColumnItem.getValue();
        TaxValueTypeEnum valueType = (TaxValueTypeEnum)((Object)this.cbDataType.getSelectedItem());
        String itemFormula = StructureUtils.constructFormula(sheetInfo, rowItemInfo, columnItemInfo, valueType);
        this.cellRange.setUserObject("TAXITEM", (Object)new TaxItemFormula(itemFormula));
        this.spreadManager.getSpreadContainer().repaint();
        this.isCanceled = false;
        this.destroyWindow();
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.isCanceled = true;
        this.getUIWindow().close();
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }
}

