/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.structure.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.impl.facade.rangesel.RangeSelector;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.newrpt.client.designer.SpreadManager;
import com.kingdee.eas.tm.td.StatusEnum;
import com.kingdee.eas.tm.td.TDUtils;
import com.kingdee.eas.tm.td.TaxDraftRecordInfo;
import com.kingdee.eas.tm.td.cloud.utils.TDCloudUtil;
import com.kingdee.eas.tm.td.structure.AbstractTaxReportItemInfo;
import com.kingdee.eas.tm.td.structure.ReportItemDimensionEnum;
import com.kingdee.eas.tm.td.structure.TaxReportItemInfo;
import com.kingdee.eas.tm.td.structure.TaxReportSheetInfo;
import com.kingdee.eas.tm.td.structure.TaxReportTemplateInfo;
import com.kingdee.eas.tm.td.structure.TaxStructureFacadeFactory;
import com.kingdee.eas.tm.td.structure.client.AbstractTaxReportItemBatchEditUI;
import com.kingdee.eas.tm.td.structure.utils.StructureUtils;
import com.kingdee.eas.tm.td.utils.Location;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public class TaxReportItemBatchEditUI
extends AbstractTaxReportItemBatchEditUI {
    private static final Logger logger = CoreUIObject.getLogger(TaxReportItemBatchEditUI.class);
    private Sheet rptSheet = null;
    private SpreadManager spreadManager = null;
    private IObjectValue editData = null;
    private RangeSelector rowChooser = null;
    private RangeSelector columnChooser = null;
    private PropertyChangeListener propertyChangeListener = null;
    private DataChangeListener reportSheetChangeListener = null;
    public static final String TBL_NUMBER = "number";
    public static final String TBL_NAME = "name";
    public static final String TBL_HURDLE = "hurdle";
    public static final String TBL_PARENT = "parent";
    public static final String TBL_LEVEL = "level";
    public static final String TBL_DESCRIPTION = "description";
    public static final String TBL_OBJECT = "OBJECT";
    public List rowItemSelected = new ArrayList();
    public List columnItemSelected = new ArrayList();

    public void onLoad() throws Exception {
        this.rowTable.checkParsed();
        this.columnTable.checkParsed();
        super.onLoad();
        this.initContext();
        this.initControl();
        this.addListener();
        this.setF7Filter();
    }

    protected void setF7Filter() {
        if (this.editData instanceof TaxReportTemplateInfo) {
            TaxReportTemplateInfo templateInfo = (TaxReportTemplateInfo)this.editData;
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("taxType.id", (Object)templateInfo.getTaxType().getId(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("recordType", (Object)templateInfo.getRecordType().getValue(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("state", (Object)"2", CompareType.EQUALS));
            view.setFilter(filter);
            this.prmtReportSheet.setEntityViewInfo(view);
        } else if (this.editData instanceof TaxDraftRecordInfo) {
            TaxDraftRecordInfo reportInfo = (TaxDraftRecordInfo)this.editData;
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("taxType.id", (Object)reportInfo.getTaxType().getId(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("recordType", (Object)reportInfo.getRecordType().getValue(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("state", (Object)"2", CompareType.EQUALS));
            view.setFilter(filter);
            this.prmtReportSheet.setEntityViewInfo(view);
        }
    }

    private void initContext() {
        this.rptSheet = (Sheet)this.getUIContext().get("rptSheet");
        this.spreadManager = (SpreadManager)this.getUIContext().get("spreadManager");
        this.editData = (IObjectValue)this.getUIContext().get("editData");
    }

    private void initControl() {
        this.prmtReportSheet.setHistoryRecordEnabled(false);
        this.rowChooser = this.initSelectedRange(this.rowSelectedContainer);
        this.columnChooser = this.initSelectedRange(this.columnSelectedContainer);
        Color color = new Color(192, 192, 192);
        this.rowTable.getSelectManager().setSelectMode(10);
        this.rowTable.getColumn(TBL_NUMBER).getStyleAttributes().setLocked(true);
        this.rowTable.getColumn(TBL_NUMBER).getStyleAttributes().setBackground(color);
        this.rowTable.getColumn(TBL_PARENT).getStyleAttributes().setLocked(true);
        this.rowTable.getColumn(TBL_PARENT).getStyleAttributes().setBackground(color);
        this.rowTable.getColumn(TBL_LEVEL).getStyleAttributes().setLocked(true);
        this.rowTable.getColumn(TBL_LEVEL).getStyleAttributes().setBackground(color);
        this.columnTable.getSelectManager().setSelectMode(10);
        this.columnTable.getColumn(TBL_NUMBER).getStyleAttributes().setLocked(true);
        this.columnTable.getColumn(TBL_NUMBER).getStyleAttributes().setBackground(color);
        this.columnTable.getColumn(TBL_PARENT).getStyleAttributes().setLocked(true);
        this.columnTable.getColumn(TBL_PARENT).getStyleAttributes().setBackground(color);
        this.columnTable.getColumn(TBL_LEVEL).getStyleAttributes().setLocked(true);
        this.columnTable.getColumn(TBL_LEVEL).getStyleAttributes().setBackground(color);
    }

    private RangeSelector initSelectedRange(KDLabelContainer container) {
        RangeSelector chooser = this.spreadManager.createRangeSelector(TDUtils.getString("com.kingdee.eas.tm.td.structure.TaxStructureResource", "SELECTAREA", TDUtils.getLocale()));
        container.setBoundEditor((JComponent)chooser);
        return chooser;
    }

    protected void addListener() {
        if (this.propertyChangeListener == null) {
            this.propertyChangeListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    try {
                        TaxReportItemBatchEditUI.this.properyChange(e);
                    }
                    catch (Exception e1) {
                        TaxReportItemBatchEditUI.this.handUIException(e1);
                    }
                }
            };
            this.rowChooser.addPropertyChangeListener("RangeSelected", this.propertyChangeListener);
            this.columnChooser.addPropertyChangeListener("RangeSelected", this.propertyChangeListener);
        }
        if (this.reportSheetChangeListener == null) {
            this.reportSheetChangeListener = new DataChangeListener(){

                public void dataChanged(DataChangeEvent e) {
                    if (TDCloudUtil.isEqual(e.getNewValue(), e.getOldValue())) {
                        return;
                    }
                    try {
                        TaxReportItemBatchEditUI.this.reportSheet_dataChanged(e);
                    }
                    catch (Exception e1) {
                        TaxReportItemBatchEditUI.this.handUIException(e1);
                    }
                }
            };
            this.prmtReportSheet.addDataChangeListener(this.reportSheetChangeListener);
        }
    }

    private void properyChange(PropertyChangeEvent e) throws EASBizException, BOSException {
        if (e.getSource().equals(this.rowChooser)) {
            this.parseRowItemBySheetArea();
        } else if (e.getSource().equals(this.columnChooser)) {
            this.parseColumnItemBySheetArea();
        }
        this.setSummaryMessage();
    }

    protected void reportSheet_dataChanged(DataChangeEvent e) throws EASBizException, BOSException {
        this.parseRowItemBySheetArea();
        this.parseColumnItemBySheetArea();
        this.setSummaryMessage();
    }

    public void parseRowItemBySheetArea() throws EASBizException, BOSException {
        TaxReportSheetInfo sheetInfo = (TaxReportSheetInfo)this.prmtReportSheet.getValue();
        if (sheetInfo == null) {
            MsgBox.showInfo((String)TDUtils.getString("com.kingdee.eas.tm.td.structure.TaxStructureResource", "INPUTREPORTSHEET", TDUtils.getLocale()));
            this.prmtReportSheet.requestFocus();
            return;
        }
        String rangeText = this.rowChooser.getText();
        if (StringUtils.isEmpty((String)rangeText)) {
            return;
        }
        String[] str = rangeText.split("!");
        if (str.length <= 1) {
            return;
        }
        int itemDimension = 0;
        Map retMap = TaxStructureFacadeFactory.getRemoteInstance().getNextItemNumberBySheet(sheetInfo.getId().toString(), itemDimension);
        String number = (String)retMap.get(TBL_NUMBER);
        int seq = (Integer)retMap.get("seq");
        String[] cells = str[1].split(":");
        int[] point1 = Location.getCellRowAndColumn(cells[0]);
        int[] point2 = null;
        if (cells.length > 1) {
            point2 = Location.getCellRowAndColumn(cells[1]);
        }
        int row1 = point1[0];
        int column1 = point1[1];
        int row2 = point1[0];
        int column2 = point1[1];
        if (point2 != null) {
            row2 = point2[0];
            column2 = point2[1];
        }
        this.rowItemSelected = new ArrayList();
        AbstractTaxReportItemInfo parentInfo = null;
        TaxReportItemInfo itemInfo = null;
        CellBlock cellBlock = null;
        for (int i = row1; i <= row2; ++i) {
            cellBlock = null;
            for (int j = column1; j <= column2; ++j) {
                Object value;
                Range cell = this.rptSheet.getRange(i, j);
                cellBlock = this.rptSheet.getMergeBlock(i, j);
                if (cellBlock != null) {
                    j = j + cellBlock.getWidth() - 1;
                }
                if ((value = cell.getValue().getValue()) != null) {
                    String valueStr = StructureUtils.trim(value.toString());
                    if (j + 1 > column2 && this.rowHurdleSelected.isSelected()) {
                        if (parentInfo == null) continue;
                        parentInfo.setHurdleOrder(valueStr);
                        continue;
                    }
                    itemInfo = this.createNewData();
                    itemInfo.setItemDimension(ReportItemDimensionEnum.ROW);
                    itemInfo.setReportSheet(sheetInfo);
                    itemInfo.setParent((TaxReportItemInfo)parentInfo);
                    if (itemInfo.getParent() != null) {
                        itemInfo.setLevel(itemInfo.getParent().getLevel() + 1);
                        itemInfo.setName(itemInfo.getParent().getName() + "." + valueStr);
                        if (parentInfo != null) {
                            ((TaxReportItemInfo)parentInfo).getChildren().add(itemInfo);
                            itemInfo.setNumber(parentInfo.getNumber() + "." + StructureUtils.getFixSequenceNumber(((TaxReportItemInfo)parentInfo).getChildren().size(), 4));
                        }
                    } else {
                        itemInfo.setNumber(number + StructureUtils.getFixSequenceNumber(seq, 4));
                        itemInfo.setLevel(1);
                        itemInfo.setName(valueStr);
                        ++seq;
                    }
                    this.rowItemSelected.add(itemInfo);
                    parentInfo = itemInfo;
                    cell.setUserObject("TMPITEM", (Object)itemInfo);
                    continue;
                }
                if (cellBlock == null || (cell = this.rptSheet.getRange(cellBlock.getRow(), cellBlock.getCol())) == null) continue;
                TaxReportItemInfo item = (TaxReportItemInfo)cell.getUserObject("TMPITEM");
                parentInfo = item;
            }
            parentInfo = null;
            if (cellBlock == null) continue;
            i = i + cellBlock.getHeight() - 1;
        }
        this.addArrayListToTable(this.rowItemSelected, this.rowTable);
        this.rptSheet.getRange(0, 0, this.rptSheet.getMaxRowIndex(), this.rptSheet.getMaxColIndex()).clear(false, false, false, false, new String[]{"TMPITEM"});
    }

    public void parseColumnItemBySheetArea() throws EASBizException, BOSException {
        TaxReportSheetInfo sheetInfo = (TaxReportSheetInfo)this.prmtReportSheet.getValue();
        if (sheetInfo == null) {
            MsgBox.showInfo((String)TDUtils.getString("com.kingdee.eas.tm.td.structure.TaxStructureResource", "INPUTREPORTSHEET", TDUtils.getLocale()));
            this.prmtReportSheet.requestFocus();
            return;
        }
        String rangeText = this.columnChooser.getText();
        if (StringUtils.isEmpty((String)rangeText)) {
            return;
        }
        String[] str = rangeText.split("!");
        if (str.length <= 1) {
            return;
        }
        int itemDimension = 1;
        Map retMap = TaxStructureFacadeFactory.getRemoteInstance().getNextItemNumberBySheet(sheetInfo.getId().toString(), itemDimension);
        String number = (String)retMap.get(TBL_NUMBER);
        int seq = (Integer)retMap.get("seq");
        String[] cells = str[1].split(":");
        int[] point1 = Location.getCellRowAndColumn(cells[0]);
        int[] point2 = null;
        if (cells.length > 1) {
            point2 = Location.getCellRowAndColumn(cells[1]);
        }
        int row1 = point1[0];
        int column1 = point1[1];
        int row2 = point1[0];
        int column2 = point1[1];
        if (point2 != null) {
            row2 = point2[0];
            column2 = point2[1];
        }
        this.columnItemSelected = new ArrayList();
        AbstractTaxReportItemInfo parentInfo = null;
        TaxReportItemInfo itemInfo = null;
        CellBlock cellBlock = null;
        for (int i = column1; i <= column2; ++i) {
            cellBlock = null;
            for (int j = row1; j <= row2; ++j) {
                Object value;
                Range cell = this.rptSheet.getRange(j, i);
                cellBlock = this.rptSheet.getMergeBlock(j, i);
                if (cellBlock != null) {
                    j = j + cellBlock.getHeight() - 1;
                }
                if ((value = cell.getValue().getValue()) != null) {
                    String valueStr = StructureUtils.trim(value.toString());
                    if (j + 1 > row2 && this.columnHurdleSelected.isSelected()) {
                        if (parentInfo == null) continue;
                        parentInfo.setHurdleOrder(valueStr);
                        continue;
                    }
                    itemInfo = this.createNewData();
                    itemInfo.setReportSheet(sheetInfo);
                    itemInfo.setParent((TaxReportItemInfo)parentInfo);
                    itemInfo.setItemDimension(ReportItemDimensionEnum.COLUMN);
                    if (itemInfo.getParent() != null) {
                        itemInfo.setLevel(itemInfo.getParent().getLevel() + 1);
                        itemInfo.setName(itemInfo.getParent().getName() + "." + valueStr);
                        if (parentInfo != null) {
                            ((TaxReportItemInfo)parentInfo).getChildren().add(itemInfo);
                            parentInfo.setIsLeaf(false);
                            itemInfo.setNumber(parentInfo.getNumber() + "." + StructureUtils.getFixSequenceNumber(((TaxReportItemInfo)parentInfo).getChildren().size(), 4));
                        }
                        itemInfo.setLongNumber(itemInfo.getNumber());
                        itemInfo.setDisplayName(itemInfo.getName());
                    } else {
                        itemInfo.setLevel(1);
                        itemInfo.setName(valueStr);
                        itemInfo.setNumber(number + StructureUtils.getFixSequenceNumber(seq, 4));
                        itemInfo.setLongNumber(itemInfo.getNumber());
                        itemInfo.setDisplayName(itemInfo.getName());
                        itemInfo.setIsLeaf(true);
                        ++seq;
                    }
                    this.columnItemSelected.add(itemInfo);
                    parentInfo = itemInfo;
                    cell.setUserObject("TMPITEM", (Object)itemInfo);
                    continue;
                }
                if (cellBlock == null || (cell = this.rptSheet.getRange(cellBlock.getRow(), cellBlock.getCol())) == null) continue;
                TaxReportItemInfo item = (TaxReportItemInfo)cell.getUserObject("TMPITEM");
                parentInfo = item;
            }
            parentInfo = null;
            if (cellBlock == null) continue;
            i = i + cellBlock.getWidth() - 1;
        }
        this.addArrayListToTable(this.columnItemSelected, this.columnTable);
        this.rptSheet.getRange(0, 0, this.rptSheet.getMaxRowIndex(), this.rptSheet.getMaxColIndex()).clear(false, false, false, false, new String[]{"TMPITEM"});
    }

    protected TaxReportItemInfo createNewData() {
        TaxReportItemInfo info = new TaxReportItemInfo();
        info.setId(BOSUuid.create((String)"854ABC7C"));
        info.setState(StatusEnum.SAVE);
        info.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
        return info;
    }

    @Override
    public void actionRowTableDelRow_actionPerformed(ActionEvent e) throws Exception {
        this.checkRemoveItem(this.rowTable);
        int rowIndex = this.removeSelected(this.rowTable, this.rowItemSelected);
        this.innerStoreFields(this.rowTable);
        this.addArrayListToTable(this.rowItemSelected, this.rowTable);
        this.scrollToRow(this.rowTable, rowIndex);
        this.setSummaryMessage();
    }

    @Override
    public void actionColumnTableDelRow_actionPerformed(ActionEvent e) throws Exception {
        this.checkRemoveItem(this.columnTable);
        int rowIndex = this.removeSelected(this.columnTable, this.columnItemSelected);
        this.innerStoreFields(this.columnTable);
        this.addArrayListToTable(this.columnItemSelected, this.columnTable);
        this.scrollToRow(this.columnTable, rowIndex);
        this.setSummaryMessage();
    }

    protected void scrollToRow(KDTable table, int row_index) {
        if (table.getRow(row_index) != null) {
            table.getSelectManager().select(row_index, 0);
            table.getLayoutManager().scrollRowToShow(row_index);
        } else {
            table.getSelectManager().removeAll();
        }
    }

    private void checkRemoveItem(KDTable table) {
        StringBuffer sb1 = new StringBuffer();
        int size = table.getSelectManager().size();
        for (int i = 0; i < size; ++i) {
            KDTSelectBlock sb = table.getSelectManager().get(i);
            int n = sb.getBottom();
            for (int j = sb.getTop(); j <= n; ++j) {
                TaxReportItemInfo info = (TaxReportItemInfo)table.getRow(j).getCell(TBL_OBJECT).getValue();
                if (info.getChildren().size() <= 0) continue;
                sb1.append(TDUtils.getString("com.kingdee.eas.tm.td.structure.TaxStructureResource", "EXISTCHILDRENITEM", TDUtils.getLocale(), new Object[]{info.getNumber()})).append("\n");
            }
        }
        String error = TDUtils.getString("com.kingdee.eas.tm.td.structure.TaxStructureResource", "EXISTCHILDREN", TDUtils.getLocale());
        String errorDetail = sb1.toString();
        if (sb1.length() > 0) {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)error, (String)errorDetail, (int)8188);
            SysUtil.abort();
        }
    }

    private int removeSelected(KDTable table, List itemSelected) {
        KDTSelectBlock sb = null;
        int size = table.getSelectManager().size();
        for (int i = 0; i < size; ++i) {
            sb = table.getSelectManager().get(i);
            int n = sb.getBottom();
            for (int j = sb.getTop(); j <= n; ++j) {
                TaxReportItemInfo info = (TaxReportItemInfo)table.getRow(j).getCell(TBL_OBJECT).getValue();
                itemSelected.remove(info);
                if (info.getParent() == null) continue;
                info.getParent().getChildren().remove(info);
            }
        }
        if (sb == null) {
            return -1;
        }
        return sb.getTop() - 1;
    }

    private void addArrayListToTable(List rptArr, KDTable table) {
        table.checkParsed();
        table.removeRows();
        int count = rptArr.size();
        TaxReportItemInfo itemInfo = null;
        IRow row = null;
        for (int i = 0; i < count; ++i) {
            itemInfo = (TaxReportItemInfo)rptArr.get(i);
            row = table.addRow();
            row.getCell(TBL_NUMBER).setValue((Object)itemInfo.getNumber());
            row.getCell(TBL_NAME).setValue((Object)itemInfo.getName());
            row.getCell(TBL_HURDLE).setValue((Object)itemInfo.getHurdleOrder());
            row.getCell(TBL_PARENT).setValue((Object)itemInfo.getParent());
            row.getCell(TBL_LEVEL).setValue((Object)itemInfo.getLevel());
            row.getCell(TBL_DESCRIPTION).setValue((Object)itemInfo.getDescription());
            row.getCell(TBL_OBJECT).setValue((Object)itemInfo);
        }
    }

    private void setSummaryMessage() {
        int rowCount = this.rowTable.getRowCount();
        int columnCount = this.columnTable.getRowCount();
        String summaryMessage = TDUtils.getString("com.kingdee.eas.tm.td.structure.TaxStructureResource", "SUMMARYMESSAGE", TDUtils.getLocale(), new Object[]{rowCount, columnCount});
        this.summaryText.setText(summaryMessage);
    }

    protected void checkRequiredFields() {
        int rowCount = this.rowTable.getRowCount();
        int columnCount = this.columnTable.getRowCount();
        if (rowCount == 0 && columnCount == 0) {
            MsgBox.showInfo((String)TDUtils.getString("com.kingdee.eas.tm.td.structure.TaxStructureResource", "ROWCOLUMNISNULL", TDUtils.getLocale()));
            SysUtil.abort();
        }
    }

    protected void innerStoreFields(KDTable table) {
        TaxReportItemInfo itemInfo = null;
        IRow row = null;
        int count = table.getRowCount();
        String name = null;
        String hurdle = null;
        String description = null;
        for (int i = 0; i < count; ++i) {
            row = table.getRow(i);
            itemInfo = (TaxReportItemInfo)row.getCell(TBL_OBJECT).getValue();
            name = (String)row.getCell(TBL_NAME).getValue();
            hurdle = (String)row.getCell(TBL_HURDLE).getValue();
            description = (String)row.getCell(TBL_DESCRIPTION).getValue();
            itemInfo.setName(name);
            itemInfo.setHurdleOrder(hurdle);
            itemInfo.setDescription(description);
        }
    }

    @Override
    public void actionOK_actionPerformed(ActionEvent e) throws Exception {
        this.checkRequiredFields();
        this.innerStoreFields(this.rowTable);
        this.innerStoreFields(this.columnTable);
        ArrayList itemSelected = new ArrayList();
        itemSelected.addAll(this.rowItemSelected);
        itemSelected.addAll(this.columnItemSelected);
        TaxStructureFacadeFactory.getRemoteInstance().saveReportItems(itemSelected);
        MsgBox.showInfo((String)TDUtils.getString("com.kingdee.eas.tm.td.structure.TaxStructureResource", "REPORTITEMSSAVESUCCESS", TDUtils.getLocale()));
        this.destroyWindow();
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.getUIWindow().close();
    }
}

