/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.structure.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tm.td.StatusEnum;
import com.kingdee.eas.tm.td.TDUtils;
import com.kingdee.eas.tm.td.cloud.utils.TDCloudUtil;
import com.kingdee.eas.tm.td.common.permsupport.IPermSupport4EditUI;
import com.kingdee.eas.tm.td.common.uihelper.EditUIHelper;
import com.kingdee.eas.tm.td.structure.ReportItemDimensionEnum;
import com.kingdee.eas.tm.td.structure.TaxReportItemFactory;
import com.kingdee.eas.tm.td.structure.TaxReportItemInfo;
import com.kingdee.eas.tm.td.structure.TaxReportSheetInfo;
import com.kingdee.eas.tm.td.structure.client.AbstractTaxReportItemEditUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.sql.Timestamp;
import org.apache.log4j.Logger;

public class TaxReportItemEditUI
extends AbstractTaxReportItemEditUI
implements IPermSupport4EditUI {
    private static final Logger logger = CoreUIObject.getLogger(TaxReportItemEditUI.class);
    private static final String TDRESOURCE = "com.kingdee.eas.tm.td.cloud.TDCloudResource";
    private EditUIHelper uiHelper = null;
    private String currentCUID;
    private DataChangeListener reportSheetChangeListener = null;
    private ItemListener itemDimensionChangeListener = null;
    private SelectorListener parentItemSelectorListener = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.afterLoad();
    }

    private void afterLoad() throws EASBizException, BOSException {
        this.uiHelper = new EditUIHelper(this);
        this.currentCUID = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
        this.setF7Filter();
    }

    protected void initBtnStatus() {
        this.chkMenuItemSubmitAndAddNew.setSelected(false);
        if (this.editData != null && this.editData.getId() != null) {
            if (StatusEnum.SAVE.equals((Object)this.editData.getState())) {
                this.actionCancelCancel.setEnabled(true);
                this.actionCancel.setEnabled(true);
                this.actionEdit.setEnabled(true);
                this.actionRemove.setEnabled(true);
            } else {
                this.actionCancelCancel.setEnabled(StatusEnum.DisEnable.equals((Object)this.editData.getState()));
                this.actionCancel.setEnabled(StatusEnum.Enable.equals((Object)this.editData.getState()));
                this.actionEdit.setEnabled(StatusEnum.DisEnable.equals((Object)this.editData.getState()));
                this.actionRemove.setEnabled(StatusEnum.DisEnable.equals((Object)this.editData.getState()));
            }
        }
        if (OprtState.EDIT.equals(this.getOprtState())) {
            this.prmtReportSheet.setEnabled(false);
            this.comboItemDimension.setEnabled(false);
        } else {
            this.prmtReportSheet.setEnabled(true);
            this.comboItemDimension.setEnabled(true);
        }
    }

    @Override
    public void loadFields() {
        this.removeEventLisener();
        super.loadFields();
        this.addEventLisener();
        this.setF7Filter();
        this.initBtnStatus();
    }

    private void removeEventLisener() {
        if (this.reportSheetChangeListener != null) {
            this.prmtReportSheet.removeDataChangeListener(this.reportSheetChangeListener);
        }
        if (this.itemDimensionChangeListener != null) {
            this.comboItemDimension.removeItemListener(this.itemDimensionChangeListener);
        }
        if (this.parentItemSelectorListener != null) {
            this.prmtParent.removeSelectorListener(this.parentItemSelectorListener);
        }
    }

    private void addEventLisener() {
        this.reportSheetChangeListener = new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                if (TDCloudUtil.isEqual(e.getNewValue(), e.getOldValue())) {
                    return;
                }
                try {
                    TaxReportItemEditUI.this.reportSheet_dataChanged(e);
                }
                catch (Exception e1) {
                    TaxReportItemEditUI.this.handUIException(e1);
                }
            }
        };
        this.prmtReportSheet.addDataChangeListener(this.reportSheetChangeListener);
        this.itemDimensionChangeListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                TaxReportItemEditUI.this.itemDimension_dataChanged(e);
            }
        };
        this.comboItemDimension.addItemListener(this.itemDimensionChangeListener);
        this.parentItemSelectorListener = new SelectorListener(){

            public void willShow(SelectorEvent e) {
                TaxReportItemEditUI.this.parentItem_selector(e);
            }
        };
        this.prmtParent.addSelectorListener(this.parentItemSelectorListener);
    }

    protected void reportSheet_dataChanged(DataChangeEvent e) throws EASBizException, BOSException {
        this.prmtParent.setValue(null);
        this.setParentReportItemF7Filter();
    }

    protected void itemDimension_dataChanged(ItemEvent e) {
        if (e.getStateChange() == 2) {
            this.prmtParent.setValue(null);
            this.setParentReportItemF7Filter();
        }
    }

    protected void parentItem_selector(SelectorEvent e) {
        if (this.prmtReportSheet.getValue() == null) {
            this.prmtReportSheet.requestFocus();
            MsgBox.showInfo((String)TDUtils.getString("com.kingdee.eas.tm.td.structure.TaxStructureResource", "INPUTREPORTSHEET", SysContext.getSysContext().getLocale()));
            SysUtil.abort();
        }
    }

    protected void setReportSheetF7Filter() {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)"2", CompareType.EQUALS));
        view.setFilter(filter);
        this.prmtReportSheet.setEntityViewInfo(view);
    }

    protected void setParentReportItemF7Filter() {
        ReportItemDimensionEnum itemDimension;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        TaxReportSheetInfo reportSheet = (TaxReportSheetInfo)this.prmtReportSheet.getValue();
        if (reportSheet != null) {
            filter.getFilterItems().add(new FilterItemInfo("reportSheet.id", (Object)reportSheet.getId().toString(), CompareType.EQUALS));
        }
        if ((itemDimension = (ReportItemDimensionEnum)((Object)this.comboItemDimension.getSelectedItem())) != null) {
            filter.getFilterItems().add(new FilterItemInfo("itemDimension", (Object)itemDimension.getValue(), CompareType.EQUALS));
        }
        if (this.editData.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)this.editData.getId().toString(), CompareType.NOTEQUALS));
        }
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)"2", CompareType.EQUALS));
        view.setFilter(filter);
        this.prmtParent.setEntityViewInfo(view);
    }

    protected void checkStateEnableEdit() throws Exception {
        if (this.editData.getState().equals((Object)StatusEnum.Enable)) {
            MsgBox.showInfo((String)TDUtils.getString("com.kingdee.eas.tm.td.structure.TaxStructureResource", "ENABLENOEDIT", SysContext.getSysContext().getLocale()));
            SysUtil.abort();
        }
        if (this.editData.isIsScheduled()) {
            MsgBox.showInfo((String)TDUtils.getString("com.kingdee.eas.tm.td.structure.TaxStructureResource", "BASEDATA_EIDT_SCHEDULEDERROR", SysContext.getSysContext().getLocale()));
            SysUtil.abort();
        }
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkStateEnableEdit();
        this.uiHelper.checkPermissionByEditUI(this.currentCUID, this.editData.getId().toString());
        super.actionEdit_actionPerformed(e);
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.uiHelper.checkPermissionByEditUI(this.currentCUID, this.editData.getId().toString());
        super.actionCancel_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.uiHelper.checkPermissionByEditUI(this.currentCUID, this.editData.getId().toString());
        super.actionRemove_actionPerformed(e);
    }

    private void checkRequiredFields() {
        StringBuffer sb = new StringBuffer();
        if (this.txtNumber.getText().isEmpty()) {
            sb.append(EASResource.getString((String)TDRESOURCE, (String)"NUMBER"));
        }
        if (this.txtName.getText().isEmpty()) {
            sb.append(EASResource.getString((String)TDRESOURCE, (String)"NAME"));
        }
        if (this.prmtReportSheet.getValue() == null) {
            sb.append(EASResource.getString((String)TDRESOURCE, (String)"REPORTSHEET"));
        }
        if (sb.length() > 0) {
            sb.append(EASResource.getString((String)TDRESOURCE, (String)"NOTNULL"));
            MsgBox.showWarning((String)sb.substring(1));
            SysUtil.abort();
        }
        try {
            if (this.txtDescription.getText().getBytes("utf8").length > 1024) {
                sb.append(EASResource.getString((String)TDRESOURCE, (String)"DESCRIPTION"));
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        if (sb.length() > 0) {
            sb.append(EASResource.getString((String)TDRESOURCE, (String)"OVER_LENGTH"));
            MsgBox.showWarning((String)sb.substring(1));
            SysUtil.abort();
        }
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.checkRequiredFields();
        super.actionSubmit_actionPerformed(e);
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        this.uiHelper.checkPermissionByEditUI(this.currentCUID, this.editData.getId().toString());
        super.actionCancelCancel_actionPerformed(e);
    }

    private void setF7Filter() {
        this.setReportSheetF7Filter();
        this.setParentReportItemF7Filter();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnSave.setVisible(false);
        this.menuItemSave.setVisible(false);
    }

    protected void setFieldsNull(AbstractObjectValue newData) {
        TaxReportItemInfo editData = (TaxReportItemInfo)newData;
        editData.setNumber(editData.getNumber() + "Copy");
        editData.setName(editData.getName() + "Copy");
        editData.setState(StatusEnum.SAVE);
        editData.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
        editData.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        editData.setCreateTime(new Timestamp(System.currentTimeMillis()));
        editData.setLastUpdateUser(null);
        editData.setLastUpdateTime(null);
    }

    protected IObjectValue createNewData() {
        TaxReportItemInfo editData = new TaxReportItemInfo();
        editData.setState(StatusEnum.SAVE);
        return editData;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return TaxReportItemFactory.getRemoteInstance();
    }

    @Override
    public String getBizOrgProperty(OrgType orgType) throws BOSException, EASBizException {
        return "CU";
    }

    @Override
    public ICoreBase getPermInterface() throws Exception {
        return this.getBizInterface();
    }

    @Override
    public String getPermItem(String status) {
        return null;
    }

    @Override
    public KDBizPromptBox getPermMainBizOrg() {
        return null;
    }

    @Override
    public IObjectValue getValueObject() {
        return this.editData;
    }
}

