/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.structure.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.framework.ITreeBase;
import com.kingdee.eas.framework.client.tree.DefaultLNTreeNodeCtrl;
import com.kingdee.eas.framework.client.tree.ILNTreeNodeCtrl;
import com.kingdee.eas.framework.client.tree.ITreeBuilder;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.framework.client.tree.TreeBuilderFactory;
import com.kingdee.eas.tm.td.TDUtils;
import com.kingdee.eas.tm.td.cloud.utils.TDCloudUtil;
import com.kingdee.eas.tm.td.structure.ReportItemDimensionEnum;
import com.kingdee.eas.tm.td.structure.TaxReportItemCollection;
import com.kingdee.eas.tm.td.structure.TaxReportItemFactory;
import com.kingdee.eas.tm.td.structure.TaxReportItemInfo;
import com.kingdee.eas.tm.td.structure.TaxReportSheetInfo;
import com.kingdee.eas.tm.td.structure.client.AbstractTaxReportItemSelectedUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class TaxReportItemSelectedUI
extends AbstractTaxReportItemSelectedUI {
    private static final Logger logger = CoreUIObject.getLogger(TaxReportItemSelectedUI.class);
    private static final String COL_NUMBER = "number";
    private static final String COL_NAME = "name";
    private static final String COL_ID = "id";
    private static final String COL_OBJECT = "object";
    private int rowsize = 0;
    private ITreeBuilder treeBuilder = null;
    private TreeSelectionListener treeSelectionListener = null;
    private KDTreeNode rootNode = null;
    private DataChangeListener reportSheetChangeListener = null;
    private ItemListener itemDimChangeListener = null;
    private boolean isCanceled = true;
    private boolean enabledMultiSelection = true;
    private ArrayList rptArrSelected = null;

    public void setRptArrSelected(ArrayList arr) {
        this.rptArrSelected = arr;
    }

    public ArrayList getRptArrSelected() {
        if (this.rptArrSelected == null) {
            this.rptArrSelected = new ArrayList();
        }
        return this.rptArrSelected;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.afterLoad();
    }

    protected void afterLoad() throws Exception {
        TaxReportSheetInfo sheetInfo = (TaxReportSheetInfo)this.getUIContext().get("reportSheet");
        ReportItemDimensionEnum itemDimension = (ReportItemDimensionEnum)((Object)this.getUIContext().get("itemDimension"));
        ArrayList arr = (ArrayList)this.getUIContext().get("rptItemSelected");
        if (this.getUIContext().containsKey("enabledMultiSelection")) {
            this.enabledMultiSelection = (Boolean)this.getUIContext().get("enabledMultiSelection");
        }
        this.setRptArrSelected(arr);
        this.addArrayListToTable(arr, this.tblMain);
        this.prmtReportSheet.setValue((Object)sheetInfo);
        this.comboItemDim.setSelectedItem((Object)itemDimension);
        this.prmtReportSheet.setEnabled(false);
        this.comboItemDim.setEnabled(false);
        this.initTree();
        this.tblMain.getSelectManager().setSelectMode(10);
        this.prmtReportSheet.setHistoryRecordEnabled(false);
    }

    protected void initListener() {
        this.reportSheetChangeListener = new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                if (TDCloudUtil.isEqual(e.getNewValue(), e.getOldValue())) {
                    return;
                }
                try {
                    TaxReportItemSelectedUI.this.reportSheet_dataChanged(e);
                }
                catch (Exception e1) {
                    TaxReportItemSelectedUI.this.handleException(e1);
                }
            }
        };
        this.prmtReportSheet.addDataChangeListener(this.reportSheetChangeListener);
        this.itemDimChangeListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                try {
                    TaxReportItemSelectedUI.this.itemDim_dataChanged(e);
                }
                catch (Exception e1) {
                    TaxReportItemSelectedUI.this.handleException(e1);
                }
            }
        };
        this.comboItemDim.addItemListener(this.itemDimChangeListener);
        this.treeMain.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    TaxReportItemSelectedUI.this.treeMain_mouseClicked(e);
                }
                catch (Exception e1) {
                    TaxReportItemSelectedUI.this.handleException(e1);
                }
            }
        });
    }

    protected void treeMain_mouseClicked(MouseEvent e) throws Exception {
        TreePath tp = this.treeMain.getSelectionPath();
        if (tp == null) {
            return;
        }
        DefaultKingdeeTreeNode treeNode = (DefaultKingdeeTreeNode)tp.getLastPathComponent();
        if (e.getClickCount() == 2 && treeNode.isLeaf()) {
            this.actionAdd_actionPerformed(null);
        }
    }

    protected void reportSheet_dataChanged(DataChangeEvent e) throws Exception {
        this.initTree();
        this.treeMain.setSelectionRow(0);
        this.actionReduceAll_actionPerformed(null);
    }

    protected void itemDim_dataChanged(ItemEvent e) throws Exception {
        this.initTree();
        this.treeMain.setSelectionRow(0);
        this.actionReduceAll_actionPerformed(null);
    }

    protected void initTree() throws Exception {
        TreeSelectionListener[] listeners = this.treeMain.getTreeSelectionListeners();
        if (listeners.length > 0) {
            this.treeSelectionListener = listeners[0];
            this.treeMain.removeTreeSelectionListener(this.treeSelectionListener);
        }
        this.treeBuilder = TreeBuilderFactory.createTreeBuilder((ILNTreeNodeCtrl)this.getLNTreeNodeCtrl(), (int)6, (int)this.getTreeExpandLevel(), (FilterInfo)this.getDefaultFilterForTree(), (SelectorItemCollection)this.getSelectorForTree());
        if (this.getRootName() != null) {
            this.rootNode = new KDTreeNode(this.getRootObject());
            ((DefaultTreeModel)this.treeMain.getModel()).setRoot((TreeNode)this.rootNode);
        } else {
            ((DefaultTreeModel)this.treeMain.getModel()).setRoot(null);
        }
        this.treeBuilder.buildTree(this.treeMain);
        this.treeMain.addTreeSelectionListener(this.treeSelectionListener);
        this.treeMain.setShowPopMenuDefaultItem(true);
    }

    @Override
    public void actionAdd_actionPerformed(ActionEvent e) throws Exception {
        KDTreeNode treeNode = (KDTreeNode)this.treeMain.getLastSelectedPathComponent();
        if (treeNode != null) {
            TaxReportItemSelectedUI.addArrayListToArrayList(this.getRptArrSelected(), this.getTreeSelected(false));
            Collections.sort(this.getRptArrSelected());
            this.addArrayListToTable(this.getRptArrSelected(), this.tblMain);
        }
    }

    private void checkTreeSelected() {
        KDTreeNode treeNode = (KDTreeNode)this.treeMain.getLastSelectedPathComponent();
        if (treeNode == null) {
            MsgBox.showInfo((String)TDUtils.getString("com.kingdee.eas.tm.td.structure.TaxStructureResource", "SelectItems", TDUtils.getLocale()));
            SysUtil.abort();
        }
    }

    @Override
    public void actionReduce_actionPerformed(ActionEvent e) throws Exception {
        int size = this.tblMain.getSelectManager().size();
        if (size != 0) {
            this.removeSelected(this.tblMain);
            Collections.sort(this.getRptArrSelected());
            this.addArrayListToTable(this.getRptArrSelected(), this.tblMain);
        }
    }

    protected void checkTableSelected() {
        int size = this.tblMain.getSelectManager().size();
        if (size == 0) {
            MsgBox.showInfo((String)TDUtils.getString("com.kingdee.eas.tm.td.structure.TaxStructureResource", "SelectItems", TDUtils.getLocale()));
            SysUtil.abort();
        }
    }

    private void removeSelected(KDTable table) {
        int size = table.getSelectManager().size();
        for (int i = 0; i < size; ++i) {
            KDTSelectBlock sb = table.getSelectManager().get(i);
            int n = sb.getBottom();
            for (int j = sb.getTop(); j <= n; ++j) {
                TaxReportItemInfo info = (TaxReportItemInfo)table.getRow(j).getCell(COL_OBJECT).getValue();
                this.getRptArrSelected().remove(info);
            }
        }
    }

    @Override
    public void actionAddAll_actionPerformed(ActionEvent e) throws Exception {
        TaxReportItemSelectedUI.addArrayListToArrayList(this.getRptArrSelected(), this.getTreeSelected(true));
        Collections.sort(this.getRptArrSelected());
        this.addArrayListToTable(this.getRptArrSelected(), this.tblMain);
    }

    @Override
    public void actionReduceAll_actionPerformed(ActionEvent e) throws Exception {
        this.getRptArrSelected().clear();
        this.addArrayListToTable(this.getRptArrSelected(), this.tblMain);
    }

    public ArrayList addCollectionToArrayList(ArrayList arr, IObjectCollection collection) {
        if (collection == null || collection.size() == 0) {
            return null;
        }
        int i = arr.size();
        Object obj2 = null;
        for (Object obj2 : collection) {
            if (obj2 != null) {
                arr.add(i, obj2);
            }
            ++i;
        }
        return arr;
    }

    @Override
    public void actionMoveUp_actionPerformed(ActionEvent e) throws Exception {
        super.actionMoveUp_actionPerformed(e);
        this.moveUp();
        IObjectCollection rptFieldcol = this.getCollectionFromTable(this.tblMain);
        this.addCollectionToArrayList(this.getRptArrSelected(), rptFieldcol);
    }

    @Override
    public void actionMoveDown_actionPerformed(ActionEvent e) throws Exception {
        super.actionMoveDown_actionPerformed(e);
        this.moveDown(null);
        IObjectCollection rptItemcol = this.getCollectionFromTable(this.tblMain);
        this.addCollectionToArrayList(this.getRptArrSelected(), rptItemcol);
    }

    @Override
    public void actionMoveTop_actionPerformed(ActionEvent e) throws Exception {
        super.actionMoveTop_actionPerformed(e);
        while (this.moveUp()) {
        }
        IObjectCollection rptItemcol = this.getCollectionFromTable(this.tblMain);
        this.addCollectionToArrayList(this.getRptArrSelected(), rptItemcol);
    }

    @Override
    public void actionMoveBottom_actionPerformed(ActionEvent e) throws Exception {
        super.actionMoveBottom_actionPerformed(e);
        while (this.moveDown("bottom")) {
        }
        this.rowsize = 0;
        IObjectCollection rptFieldcol = this.getCollectionFromTable(this.tblMain);
        this.addCollectionToArrayList(this.getRptArrSelected(), rptFieldcol);
    }

    private IObjectCollection getCollectionFromTable(KDTable table) {
        TaxReportItemCollection rptFieldcol = null;
        int size = table.getRowCount();
        for (int i = 0; i < size; ++i) {
            if (rptFieldcol == null) {
                rptFieldcol = new TaxReportItemCollection();
            }
            TaxReportItemInfo info = (TaxReportItemInfo)table.getRow(i).getCell(COL_OBJECT).getValue();
            rptFieldcol.add(info);
            this.getRptArrSelected().remove(info);
        }
        return rptFieldcol;
    }

    protected boolean moveUp() {
        IRow[] rows = this.getTableSelection(this.tblMain);
        Arrays.sort(rows, new RowIdxComparer());
        if (rows.length > 0) {
            if (rows[0].getRowIndex() == 0) {
                return false;
            }
        } else {
            return false;
        }
        this.tblMain.getSelectManager().removeAll();
        boolean moved = false;
        for (int i = 0; i < rows.length; ++i) {
            IRow row = rows[i];
            int r = rows[i].getRowIndex();
            if (r == 0) break;
            moved = true;
            this.tblMain.removeRow(r);
            this.tblMain.addRow(r - 1, row);
            KDTSelectBlock sel = new KDTSelectBlock();
            sel.setTable(this.tblMain);
            sel.setTop(r - 1);
            sel.setBottom(r - 1);
            sel.setMode(2);
            this.tblMain.getSelectManager().add(sel);
        }
        if (moved) {
            this.tblMain.setRefresh(true);
        }
        return true;
    }

    protected boolean moveDown(String bottom) {
        IRow row;
        int r;
        int rowcount = this.tblMain.getRowCount();
        IRow[] rows = this.getTableSelection(this.tblMain);
        Arrays.sort(rows, new RowIdxComparer());
        if (rows.length > 0) {
            if ("bottom".equals(bottom)) {
                if (this.rowsize == 0) {
                    this.rowsize = rows.length;
                } else if (this.rowsize != rows.length) {
                    return false;
                }
            }
            if (rows[rows.length - 1].getRowIndex() == rowcount - 1) {
                return false;
            }
        } else {
            return false;
        }
        this.tblMain.getSelectManager().removeAll();
        boolean moved = false;
        for (int i = rows.length - 1; i >= 0 && (r = (row = rows[i]).getRowIndex()) != rowcount - 1; --i) {
            moved = true;
            this.tblMain.removeRow(r);
            this.tblMain.addRow(r + 1, row);
            KDTSelectBlock sel = new KDTSelectBlock();
            sel.setTable(this.tblMain);
            sel.setTop(r + 1);
            sel.setBottom(r + 1);
            sel.setMode(2);
            this.tblMain.getSelectManager().add(sel);
        }
        if (moved) {
            this.tblMain.setRefresh(true);
        }
        return true;
    }

    protected IRow[] getTableSelection(KDTable tbl) {
        ArrayList blocks = tbl.getSelectManager().getBlocks();
        ArrayList<IRow> rows = new ArrayList<IRow>();
        for (int i = 0; i < blocks.size(); ++i) {
            KDTSelectBlock block = (KDTSelectBlock)blocks.get(i);
            if (block.getMode() == 8) {
                for (int j = 0; j < tbl.getRowCount(); ++j) {
                    rows.add(tbl.getRow(j));
                }
                break;
            }
            int smallLine = block.getBeginRow() < block.getEndRow() ? block.getBeginRow() : block.getEndRow();
            int bigLine = block.getBeginRow() > block.getEndRow() ? block.getBeginRow() : block.getEndRow();
            for (int row = smallLine; row <= bigLine; ++row) {
                rows.add(tbl.getRow(row));
            }
        }
        return rows.toArray(new IRow[rows.size()]);
    }

    public List<TaxReportItemInfo> getTreeSelected(boolean isAll) {
        ArrayList<TaxReportItemInfo> treeSelected = new ArrayList<TaxReportItemInfo>();
        KDTreeNode node = null;
        if (isAll) {
            node = this.rootNode;
            this.traversalChildNode((DefaultMutableTreeNode)node, treeSelected);
        } else {
            TreePath[] paths = this.treeMain.getSelectionPaths();
            TreePath path = null;
            for (int i = 0; i < paths.length; ++i) {
                path = paths[i];
                node = (KDTreeNode)path.getLastPathComponent();
                this.traversalChildNode((DefaultMutableTreeNode)node, treeSelected);
            }
        }
        return treeSelected;
    }

    protected void traversalChildNode(DefaultMutableTreeNode node, List<TaxReportItemInfo> treeSelected) {
        if (node.isLeaf() && node.getUserObject() instanceof TaxReportItemInfo) {
            TaxReportItemInfo info = (TaxReportItemInfo)node.getUserObject();
            treeSelected.add(info);
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getChildAt(i);
            this.traversalChildNode(child, treeSelected);
        }
    }

    public static List addArrayListToArrayList(List arrTo, List arrFrom) {
        if (arrFrom == null || arrFrom.size() == 0) {
            return null;
        }
        Object obj = null;
        int i = arrTo.size();
        int n = arrFrom.size();
        for (int j = 0; j < n; ++j) {
            obj = arrFrom.get(j);
            if (obj != null && !arrTo.contains(obj)) {
                arrTo.add(arrTo.size(), obj);
            }
            ++i;
        }
        return arrTo;
    }

    private void addArrayListToTable(ArrayList rptArr, KDTable table) {
        table.checkParsed();
        table.removeRows();
        table.getStyleAttributes().setLocked(true);
        int count = rptArr.size();
        TaxReportItemInfo info = null;
        IRow row = null;
        for (int i = 0; i < count; ++i) {
            info = (TaxReportItemInfo)rptArr.get(i);
            row = table.addRow();
            row.getCell(COL_NUMBER).setValue((Object)info.getNumber());
            row.getCell(COL_NAME).setValue((Object)info.getName());
            row.getCell(COL_ID).setValue((Object)info.getId().toString());
            row.getCell(COL_OBJECT).setValue((Object)info);
        }
    }

    protected SelectorItemCollection getSelectorForTree() {
        SelectorItemCollection sc = new SelectorItemCollection();
        sc.add(COL_NAME);
        sc.add(COL_NUMBER);
        sc.add("level");
        sc.add("longnumber");
        sc.add("isLeaf");
        return sc;
    }

    protected FilterInfo getDefaultFilterForTree() {
        FilterInfo filter = new FilterInfo();
        FilterInfo treeFilter = this.getLeftTreeFilter();
        try {
            if (treeFilter != null) {
                filter.mergeFilter(treeFilter, "AND");
            }
        }
        catch (BOSException ex) {
            MsgBox.showError((Component)((Object)this), (String)ex.getMessage());
            super.abort();
        }
        return filter;
    }

    protected FilterInfo getLeftTreeFilter() {
        FilterInfo filter = new FilterInfo();
        if (this.prmtReportSheet.getData() != null && this.prmtReportSheet.getData() instanceof TaxReportSheetInfo) {
            TaxReportSheetInfo reportSheetInfo = (TaxReportSheetInfo)this.prmtReportSheet.getData();
            filter.getFilterItems().add(new FilterItemInfo("reportSheet.id", (Object)reportSheetInfo.getId().toString(), CompareType.EQUALS));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("itemDimension", (Object)-1, CompareType.EQUALS));
        }
        if (this.comboItemDim.getSelectedItem() != null && this.comboItemDim.getSelectedItem() instanceof ReportItemDimensionEnum) {
            ReportItemDimensionEnum itemDimension = (ReportItemDimensionEnum)((Object)this.comboItemDim.getSelectedItem());
            filter.getFilterItems().add(new FilterItemInfo("itemDimension", (Object)itemDimension.getValue(), CompareType.EQUALS));
        }
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)"2", CompareType.EQUALS));
        return filter;
    }

    protected String getRootName() {
        return TDUtils.getString("com.kingdee.eas.tm.td.structure.TaxStructureResource", "RootName", TDUtils.getLocale());
    }

    protected Object getRootObject() {
        return this.getRootName();
    }

    protected int getTreeInitialLevel() {
        return 6;
    }

    protected int getTreeExpandLevel() {
        return 6;
    }

    protected ILNTreeNodeCtrl getLNTreeNodeCtrl() throws Exception {
        return new DefaultLNTreeNodeCtrl(this.getTreeInterface());
    }

    protected ITreeBase getTreeInterface() throws Exception {
        return TaxReportItemFactory.getRemoteInstance();
    }

    private void checkRequiredFields() {
        if (this.getRptArrSelected().size() == 0) {
            MsgBox.showInfo((String)TDUtils.getString("com.kingdee.eas.tm.td.structure.TaxStructureResource", "SelectItems", TDUtils.getLocale()));
            SysUtil.abort();
        }
        if (!this.enabledMultiSelection && this.getRptArrSelected().size() > 1) {
            MsgBox.showInfo((String)TDUtils.getString("com.kingdee.eas.tm.td.structure.TaxStructureResource", "SelectOne", TDUtils.getLocale()));
            SysUtil.abort();
        }
    }

    @Override
    public void actionOk_actionPerformed(ActionEvent e) throws Exception {
        this.checkRequiredFields();
        this.isCanceled = false;
        this.getUIWindow().close();
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.isCanceled = true;
        this.getUIWindow().close();
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }

    public Object getData() {
        return this.getRptArrSelected();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnAdd.setIcon(EASResource.getIcon((String)"imgTbtn_move_right"));
        this.btnReduce.setIcon(EASResource.getIcon((String)"imgTbtn_move_left"));
        this.btnAddAll.setIcon(EASResource.getIcon((String)"imgTbtn_moveall_right"));
        this.btnReduceAll.setIcon(EASResource.getIcon((String)"imgTbtn_moveall_left"));
        this.btnMoveUp.setIcon(EASResource.getIcon((String)"imgTbtn_movetop"));
        this.btnMoveDown.setIcon(EASResource.getIcon((String)"imgTbtn_movedown"));
        this.btnMoveTop.setIcon(EASResource.getIcon((String)"imgTbtn_movetop1"));
        this.btnMoveBottom.setIcon(EASResource.getIcon((String)"imgTbtn_movebottom"));
    }

    class RowIdxComparer
    implements Comparator {
        RowIdxComparer() {
        }

        public int compare(Object row1, Object row2) {
            return ((IRow)row1).getRowIndex() - ((IRow)row2).getRowIndex();
        }
    }
}

