/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.structure.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tm.td.RecordTypeEnum;
import com.kingdee.eas.tm.td.StatusEnum;
import com.kingdee.eas.tm.td.TDUtils;
import com.kingdee.eas.tm.td.basedata.TaxItemTypeFactory;
import com.kingdee.eas.tm.td.common.permsupport.IPermSupport4EditUI;
import com.kingdee.eas.tm.td.common.uihelper.EditUIHelper;
import com.kingdee.eas.tm.td.structure.TaxReportSheetFactory;
import com.kingdee.eas.tm.td.structure.TaxReportSheetInfo;
import com.kingdee.eas.tm.td.structure.client.AbstractTaxReportSheetEditUI;
import com.kingdee.eas.tm.td.structure.utils.StructureUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class TaxReportSheetEditUI
extends AbstractTaxReportSheetEditUI
implements IPermSupport4EditUI {
    private static final Logger logger = CoreUIObject.getLogger(TaxReportSheetEditUI.class);
    private static final String TDRESOURCE = "com.kingdee.eas.tm.td.cloud.TDCloudResource";
    private EditUIHelper uiHelper = new EditUIHelper(this);
    private String currentCUID;
    private Map btnMap = new HashMap();

    public TaxReportSheetEditUI() throws Exception {
        this.btnMap.put("actionRemove", this.actionRemove);
        this.btnMap.put("actionCancel", this.actionCancel);
        this.btnMap.put("actionCancelCancel", this.actionCancelCancel);
        this.btnMap.put("actionEdit", this.actionEdit);
        this.btnMap.put("actionSave", this.actionSubmit);
        this.btnMap.put("actionCopy", this.actionCopy);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.afterLoad();
        this.prmtCreator.setDisplayFormat("$name$");
        this.prmtLastUpdateUser.setDisplayFormat("$name$");
    }

    private void afterLoad() throws EASBizException, BOSException {
        this.currentCUID = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
        this.setF7Filter();
        this.chkMenuItemSubmitAndAddNew.setSelected(false);
    }

    private void setF7Filter() throws EASBizException, BOSException {
        StructureUtils.setTaxTypeFilter(this.prmtTaxType);
    }

    @Override
    public void loadFields() {
        this.removeEventLisener();
        super.loadFields();
        this.addEventLisener();
        try {
            this.setF7Filter();
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        this.initBtnStatus();
    }

    protected void initBtnStatus() {
        this.btnSave.setVisible(false);
        this.menuItemSave.setVisible(false);
        StatusEnum state = this.editData.getState();
        boolean isLight = false;
        if (StatusEnum.DisEnable.equals((Object)state) || StatusEnum.SAVE.equals((Object)state)) {
            isLight = true;
        }
        this.uiHelper.initBtnStatus(this.btnMap, isLight);
        if (StatusEnum.SAVE.equals((Object)state) && !this.getOprtState().equals(OprtState.ADDNEW)) {
            this.actionCancelCancel.setEnabled(true);
            this.actionCancel.setEnabled(true);
        }
    }

    private void checkRequiredFields() {
        StringBuffer sb = new StringBuffer();
        if (this.txtNumber.getText().isEmpty()) {
            sb.append(EASResource.getString((String)TDRESOURCE, (String)"NUMBER"));
        }
        if (this.txtName.getText().isEmpty()) {
            sb.append(EASResource.getString((String)TDRESOURCE, (String)"NAME"));
        }
        if (this.prmtTaxType.getValue() == null) {
            sb.append(EASResource.getString((String)TDRESOURCE, (String)"TAXTYPE"));
        }
        if (sb.length() > 0) {
            sb.append(EASResource.getString((String)TDRESOURCE, (String)"NOTNULL"));
            MsgBox.showWarning((String)sb.substring(1));
            SysUtil.abort();
        }
        try {
            if (this.txtDescription.getText().getBytes("utf8").length > 1024) {
                sb.append(EASResource.getString((String)TDRESOURCE, (String)"DESCRIPTION"));
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        if (sb.length() > 0) {
            sb.append(EASResource.getString((String)TDRESOURCE, (String)"OVER_LENGTH"));
            MsgBox.showWarning((String)sb.substring(1));
            SysUtil.abort();
        }
    }

    private void removeEventLisener() {
    }

    private void addEventLisener() {
    }

    protected void checkStateEnableEdit() throws Exception {
        if (this.editData.getState().equals((Object)StatusEnum.Enable)) {
            MsgBox.showInfo((String)TDUtils.getString("com.kingdee.eas.tm.td.structure.TaxStructureResource", "ENABLENOEDIT", SysContext.getSysContext().getLocale()));
            SysUtil.abort();
        }
        if (this.editData.isIsScheduled()) {
            MsgBox.showInfo((String)TDUtils.getString("com.kingdee.eas.tm.td.structure.TaxStructureResource", "BASEDATA_EIDT_SCHEDULEDERROR", SysContext.getSysContext().getLocale()));
            SysUtil.abort();
        }
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkStateEnableEdit();
        this.uiHelper.checkPermissionByEditUI(this.currentCUID, this.editData.getId().toString());
        super.actionEdit_actionPerformed(e);
        this.initBtnStatus();
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.uiHelper.checkPermissionByEditUI(this.currentCUID, this.editData.getId().toString());
        super.actionCancel_actionPerformed(e);
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        this.uiHelper.checkPermissionByEditUI(this.currentCUID, this.editData.getId().toString());
        if (!this.uiHelper.modifySaveOrExit((ItemAction)this.actionSubmit, this.btnSubmit, (ItemAction)this.actionSave, this.btnSave, this.isModifySave())) {
            return;
        }
        super.actionCancelCancel_actionPerformed(e);
        if (StatusEnum.Enable.equals((Object)this.editData.getState())) {
            this.setOprtState("VIEW");
        } else {
            this.setOprtState("EDIT");
        }
        this.setDataObject((IObjectValue)this.editData);
        this.loadFields();
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.uiHelper.checkPermissionByEditUI(this.currentCUID, this.editData.getId().toString());
        super.actionRemove_actionPerformed(e);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        this.uiHelper.checkCanAddnew(this.currentCUID);
        super.actionAddNew_actionPerformed(e);
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.checkRequiredFields();
        super.actionSubmit_actionPerformed(e);
        if (!this.getOprtState().equals(OprtState.ADDNEW)) {
            if (StatusEnum.Enable.equals((Object)this.editData.getState())) {
                this.setOprtState("VIEW");
            } else {
                this.setOprtState("EDIT");
            }
        }
        this.setDataObject((IObjectValue)this.editData);
        this.loadFields();
    }

    protected void setFieldsNull(AbstractObjectValue newData) {
        TaxReportSheetInfo editData = (TaxReportSheetInfo)newData;
        editData.setNumber(editData.getNumber() + "Copy");
        editData.setName(editData.getName() + "Copy");
        editData.setState(StatusEnum.SAVE);
        editData.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
        editData.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        editData.setCreateTime(new Timestamp(System.currentTimeMillis()));
        editData.setLastUpdateUser(null);
        editData.setLastUpdateTime(null);
        editData.setIsScheduled(false);
    }

    protected IObjectValue createNewData() {
        TaxReportSheetInfo editData = new TaxReportSheetInfo();
        editData.setState(StatusEnum.SAVE);
        try {
            editData.setTaxType(TaxItemTypeFactory.getRemoteInstance().getTaxItemTypeInfo((IObjectPK)new ObjectUuidPK("Xip0em3cA6rgU0ETqMAGKduK96Y=")));
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        editData.setRecordType(RecordTypeEnum.TaxDeclare);
        return editData;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return TaxReportSheetFactory.getRemoteInstance();
    }

    @Override
    public String getBizOrgProperty(OrgType orgType) throws BOSException, EASBizException {
        return "CU";
    }

    @Override
    public ICoreBase getPermInterface() throws Exception {
        return this.getBizInterface();
    }

    @Override
    public String getPermItem(String status) {
        return null;
    }

    @Override
    public KDBizPromptBox getPermMainBizOrg() {
        return null;
    }

    @Override
    public IObjectValue getValueObject() {
        return this.editData;
    }
}

