/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.structure.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchHandler.UtilRequest;
import com.kingdee.eas.framework.query.QuickFilteringSupportItems;
import com.kingdee.eas.tm.td.StatusEnum;
import com.kingdee.eas.tm.td.TDUtils;
import com.kingdee.eas.tm.td.common.uihelper.ListUIHelper;
import com.kingdee.eas.tm.td.structure.TaxReportTemplateFactory;
import com.kingdee.eas.tm.td.structure.TaxReportTemplateInfo;
import com.kingdee.eas.tm.td.structure.TaxStructureFacadeFactory;
import com.kingdee.eas.tm.td.structure.TaxTemplateTypeEnum;
import com.kingdee.eas.tm.td.structure.client.AbstractTaxReportTemplateListUI;
import com.kingdee.eas.tm.td.structure.client.TaxReportTemplateSynchUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class TaxReportTemplateListUI
extends AbstractTaxReportTemplateListUI {
    private static final Logger logger = CoreUIObject.getLogger(TaxReportTemplateListUI.class);
    private ListUIHelper uiHelper = null;
    private String currentCUID;
    public static final String TBL_STATE = "state";
    private QuickFilteringSupportItems qfsi = new QuickFilteringSupportItems(true, true);

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return TaxReportTemplateFactory.getRemoteInstance();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.uiHelper = new ListUIHelper(this);
        this.currentCUID = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
        this.afterLoad();
    }

    protected String getEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
    }

    protected QuickFilteringSupportItems getQuickFilteringSupport() {
        this.qfsi.setMustQueryAtFirst(true);
        return this.qfsi;
    }

    protected void afterLoad() {
        this.btnCancel.setEnabled(true);
        this.btnCancelCancel.setEnabled(true);
        this.btnCancel.setVisible(true);
        this.btnCancelCancel.setVisible(true);
        this.btnEditHead.setEnabled(true);
        this.menuItemEditHead.setEnabled(true);
    }

    protected FilterInfo getDefaultFilterForQuery() {
        int templateType = this.getTemplateType().getValue();
        String permissionName = "";
        if (0 == templateType) {
            permissionName = "td_accounttemplate_view";
        } else if (1 == templateType) {
            permissionName = "td_draftitemtemplate_view";
        } else if (2 == templateType) {
            permissionName = "td_taxdeclaretemplate_view";
        }
        BOSUuid orgId = this.getOrgUnitInfo().getId();
        BOSUuid userId = this.getUserInfo().getId();
        try {
            PermissionFactory.getRemoteInstance().checkFunctionPermission((IObjectPK)new ObjectUuidPK(userId), (IObjectPK)new ObjectUuidPK(orgId), permissionName);
        }
        catch (Exception e) {
            MsgBox.showWarning((String)e.getMessage());
            this.abort();
        }
        FilterInfo filter = super.getDefaultFilterForQuery();
        filter.getFilterItems().add(new FilterItemInfo("templateType", (Object)this.getTemplateType().getValue(), CompareType.EQUALS));
        return filter;
    }

    protected void tempMergeMainQuery() throws BOSException, Exception {
        this.mainQuery.getFilter().mergeFilter(this.getDefaultFilterForQuery(), "AND");
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.ControlUnit;
    }

    protected void checkStateEnableEdit() throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        TaxReportTemplateInfo info = TaxReportTemplateFactory.getRemoteInstance().getTaxReportTemplateInfo((IObjectPK)new ObjectUuidPK(id));
        if (StatusEnum.Enable.equals((Object)info.getState())) {
            MsgBox.showInfo((String)TDUtils.getString("com.kingdee.eas.tm.td.structure.TaxStructureResource", "ENABLENOEDIT", SysContext.getSysContext().getLocale()));
            SysUtil.abort();
        }
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        if (this.getTemplateTypeName() != null) {
            this.checkPermission("td_" + this.getTemplateTypeName() + "_new");
        }
        super.actionAddNew_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkStateEnableEdit();
        this.uiHelper.checkCanEdit(this.currentCUID, this.getSelectedKeyValue());
        if (this.getTemplateTypeName() != null) {
            this.checkPermission("td_" + this.getTemplateTypeName() + "_update");
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)this.getSelectedKeyValue());
        uiContext.put((Object)"OpenTemplate", (Object)true);
        IUIWindow window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(this.getProcessUIName(), (Map)uiContext, null, OprtState.EDIT);
        window.show();
    }

    @Override
    public void actionEditHead_actionPerformed(ActionEvent e) throws Exception {
        this.checkStateEnableEdit();
        this.uiHelper.checkCanEdit(this.currentCUID, this.getSelectedKeyValue());
        if (this.getTemplateTypeName() != null) {
            this.checkPermission("td_" + this.getTemplateTypeName() + "_update");
        }
        super.actionEdit_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.uiHelper.checkCanRemove(this.currentCUID, this.getSelectedIdValues());
        if (this.getTemplateTypeName() != null) {
            this.checkPermission("td_" + this.getTemplateTypeName() + "_delete");
        }
        super.actionRemove_actionPerformed(e);
    }

    protected abstract String getProcessUIName() throws Exception;

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)this.getSelectedKeyValue());
        uiContext.put((Object)"OpenTemplate", (Object)true);
        IUIWindow window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(this.getProcessUIName(), (Map)uiContext, null, OprtState.VIEW);
        window.show();
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        String cancelMsg;
        this.checkSelected();
        this.uiHelper.checkBaseDataPermission(this.currentCUID, this.getSelectedIdValues());
        if (this.getTemplateTypeName() != null) {
            this.checkPermission("td_" + this.getTemplateTypeName() + "_cancelcancel");
        }
        if (this.confirmDialog(cancelMsg = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_CancelCancel"))) {
            if (UtilRequest.isPrepare((String)"ActionCancelCancel", (CoreUIObject)this)) {
                this.prepareCancelCancel(null).callHandler();
            }
            this.cancelCancel();
            this.refreshList();
        }
    }

    protected KDTable getDetailTable() {
        return this.tblMain;
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.uiHelper.checkBaseDataPermission(this.currentCUID, this.getSelectedIdValues());
        if (this.getTemplateTypeName() != null) {
            this.checkPermission("td_" + this.getTemplateTypeName() + "_cancel");
        }
        super.actionCancel_actionPerformed(e);
        this.refreshList();
    }

    protected abstract TaxTemplateTypeEnum getTemplateType();

    @Override
    public void actionSynch_actionPerformed(ActionEvent e) throws Exception {
        int confirm;
        boolean isHasItemData;
        this.checkSelected();
        ArrayList ids = this.getSelectedIdValues();
        this.uiHelper.checkBaseDataPermission(this.currentCUID, this.getSelectedIdValues());
        if (this.getTemplateTypeName() != null) {
            this.checkPermission("td_" + this.getTemplateTypeName() + "_sync");
        }
        if (ids.size() > 1) {
            MsgBox.showInfo((String)TDUtils.getString("com.kingdee.eas.tm.td.structure.TaxStructureResource", "SynchNotSupportBatch", null));
            SysUtil.abort();
        }
        String reportId = this.getSelectedKeyValue();
        TaxReportTemplateInfo templateInfo = TaxReportTemplateFactory.getRemoteInstance().getTaxReportTemplateInfo((IObjectPK)new ObjectUuidPK(reportId));
        if (!StatusEnum.Enable.equals((Object)templateInfo.getState())) {
            MsgBox.showInfo((String)TDUtils.getString("com.kingdee.eas.tm.td.structure.TaxStructureResource", "SynchStatusError", null));
            SysUtil.abort();
        }
        if (!(isHasItemData = TaxReportTemplateFactory.getRemoteInstance().isHasItemData(reportId)) && !MsgBox.isYes((int)(confirm = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.tm.td.structure.TaxStructureResource", (String)"ItemData_Is_Null"))))) {
            SysUtil.abort();
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"taxType", (Object)templateInfo.getTaxType().getId().toString());
        uiContext.put((Object)"recordType", (Object)templateInfo.getRecordType().getValue());
        String uiClass = "com.kingdee.eas.tm.td.structure.client.TaxReportTemplateSynchUI";
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(uiClass, (Map)uiContext, null, OprtState.EDIT);
        uiWindow.show();
        TaxReportTemplateSynchUI ui = (TaxReportTemplateSynchUI)uiWindow.getUIObject();
        if (ui.isOk()) {
            HashMap params = ui.getRetMap();
            params.put("reportId", reportId);
            Map retMap = TaxStructureFacadeFactory.getRemoteInstance().synchFormulaData(params);
            List errorMsg = (List)retMap.get("errorMsg");
            List successMsg = (List)retMap.get("successMsg");
            String msg = TDUtils.getString("com.kingdee.eas.tm.td.structure.TaxStructureResource", "SynchItemData", null, new Object[]{successMsg.size(), errorMsg.size()});
            ArrayList detailMsg = new ArrayList();
            detailMsg.addAll(successMsg);
            detailMsg.addAll(errorMsg);
            MsgBox.showDetailAndOK((Component)((Object)this), (String)msg, (String)TDUtils.buildErrorMsg(detailMsg), (int)1);
        }
    }

    public String getTemplateTypeName() {
        return null;
    }

    private void checkPermission(String permItemName) {
        BOSUuid orgId = this.getOrgUnitInfo().getId();
        BOSUuid userId = this.getUserInfo().getId();
        try {
            PermissionFactory.getRemoteInstance().checkFunctionPermission((IObjectPK)new ObjectUuidPK(userId), (IObjectPK)new ObjectUuidPK(orgId), permItemName);
        }
        catch (Exception e) {
            MsgBox.showWarning((String)e.getMessage());
            this.abort();
        }
    }

    public void refreshList() throws Exception {
        this.saveCurrentLocation();
        super.refreshList();
        this.restoreCurrentLocation();
    }
}

