/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.structure.template.account.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.framework.DataBaseDException;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tm.td.common.permsupport.IPermSupport4ListUI;
import com.kingdee.eas.tm.td.common.uihelper.ListUIHelper;
import com.kingdee.eas.tm.td.structure.TaxTemplateTypeEnum;
import com.kingdee.eas.tm.td.structure.template.account.client.AbstractAccountTemplateListUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import org.apache.log4j.Logger;

public class AccountTemplateListUI
extends AbstractAccountTemplateListUI
implements IPermSupport4ListUI {
    private static final Logger logger = CoreUIObject.getLogger(AccountTemplateListUI.class);
    private ListUIHelper uiHelper = null;
    private String currentCUID;

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.uiHelper = new ListUIHelper(this);
        this.currentCUID = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
    }

    @Override
    protected String getEditUIName() {
        return "com.kingdee.eas.tm.td.structure.template.account.client.AccountTemplateEditUI";
    }

    @Override
    protected String getProcessUIName() throws Exception {
        return "com.kingdee.eas.tm.td.structure.template.account.client.AccountTemplateRptUI";
    }

    @Override
    protected TaxTemplateTypeEnum getTemplateType() {
        return TaxTemplateTypeEnum.ACCOUNT;
    }

    public void beforeActionPerformed(ActionEvent e) {
        try {
            if (e.getActionCommand().contains("$")) {
                String actionName = e.getActionCommand().split("\\$")[1];
                if (actionName.equalsIgnoreCase("actionaddnew")) {
                    this.checkPermission("td_accounttemplate_new");
                } else if (actionName.equalsIgnoreCase("actionedit") || actionName.equalsIgnoreCase("actionedithead")) {
                    this.checkSelected();
                    this.uiHelper.checkCanEdit(this.currentCUID, this.getSelectedKeyValue());
                    this.checkPermission("td_accounttemplate_update");
                } else if (actionName.equalsIgnoreCase("actionremove")) {
                    this.checkSelected();
                    this.uiHelper.checkCanRemove(this.currentCUID, this.getSelectedIdValues());
                    this.checkPermission("td_accounttemplate_delete");
                } else if (actionName.equalsIgnoreCase("actioncancel")) {
                    this.checkSelected();
                    this.uiHelper.checkBaseDataPermission(this.currentCUID, this.getSelectedIdValues());
                    this.checkPermission("td_accounttemplate_cancel");
                } else if (actionName.equalsIgnoreCase("actioncancelcancel")) {
                    this.checkSelected();
                    this.uiHelper.checkBaseDataPermission(this.currentCUID, this.getSelectedIdValues());
                    this.checkPermission("td_accounttemplate_cancelcancel");
                } else if (actionName.equalsIgnoreCase("actionsynch")) {
                    this.checkSelected();
                    this.checkPermission("td_accounttemplate_sync");
                }
            }
        }
        catch (Exception exc) {
            if (exc instanceof DataBaseDException) {
                MsgBox.showInfo((Component)((Object)this), (String)exc.getMessage());
            }
            SysUtil.abort();
        }
        super.beforeActionPerformed(e);
    }

    private void checkPermission(String permItemName) {
        BOSUuid orgId = this.getOrgUnitInfo().getId();
        BOSUuid userId = this.getUserInfo().getId();
        try {
            PermissionFactory.getRemoteInstance().checkFunctionPermission((IObjectPK)new ObjectUuidPK(userId), (IObjectPK)new ObjectUuidPK(orgId), permItemName);
        }
        catch (Exception e) {
            MsgBox.showWarning((String)e.getMessage());
            this.abort();
        }
    }

    @Override
    public String getBizOrgProperty(OrgType orgType) throws BOSException, EASBizException {
        return "CU";
    }

    @Override
    public void initPermActions() throws BOSException, EASBizException {
    }

    @Override
    public ICoreBase getPermInterface() throws Exception {
        return this.getBizInterface();
    }

    @Override
    public void initPermMainOrgContext(String orgID) throws Exception {
        this.initUIMainOrgContext(orgID);
    }

    @Override
    public String getTemplateTypeName() {
        return "accounttemplate";
    }
}

