/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.structure.utils;

import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.eas.fi.rpt.excelformula.ExcelFormulaPaserHelper;
import com.kingdee.eas.fi.rpt.excelformula.expr.Expression;
import com.kingdee.eas.fi.rpt.excelformula.expr.FunctionExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.StringExpr;
import com.kingdee.eas.fi.rpt.util.IObjectIterator;
import com.kingdee.eas.tm.td.structure.utils.StructureUtils;
import com.kingdee.eas.tm.td.structure.utils.TaxUserObjectTrans;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public final class TaxItemFormula
implements Externalizable,
Cloneable {
    private static final long serialVersionUID = 4344917138837205860L;
    private static final Logger logger = Logger.getLogger(TaxItemFormula.class);
    public static final String KEY_ITEM = "TaxItem";
    private static final String FORMULA_KEY = "Formula_Key";
    private static final String FLAG_KEY_VALUE = "\u0018";
    private static final String FLAG_CELL = "\u0012";
    public static final String ITEMDATA_INFO_FORMULASPLIT = ",";
    public static final String ITEMDATA_INFO_FORMULAHEAD = "=";
    public static final String ITEMDATA_INFO_REPORTSHEET = "0";
    public static final String ITEMDATA_INFO_ROWITEM = "1";
    public static final String ITEMDATA_INFO_COLUMNITEM = "2";
    public static final String ITEMDATA_INFO_VALUETYPE = "3";
    public static final String ITEMDATA_INFO_FORMULA = "13";
    public static final String ITEMDATA_INFO_VALUE = "14";
    transient Cell cell = null;
    transient Sheet sheet = null;
    private Map props = new HashMap();

    public TaxItemFormula() {
    }

    public TaxItemFormula(String formulaString) {
        this.formulaToObject(formulaString);
    }

    public TaxItemFormula formulaToObject(String formulaString) {
        Expression exp;
        this.props.put(FORMULA_KEY, KEY_ITEM);
        this.props.put(ITEMDATA_INFO_FORMULA, formulaString);
        try {
            exp = ExcelFormulaPaserHelper.parse((String)formulaString);
        }
        catch (Exception e) {
            return null;
        }
        FunctionExpr function = null;
        if (!(exp instanceof FunctionExpr)) {
            return null;
        }
        function = (FunctionExpr)exp;
        String[] params = new String[function.parameters.size()];
        for (int i = 0; i < function.parameters.size(); ++i) {
            Expression e = (Expression)function.parameters.get(i);
            params[i] = e instanceof StringExpr ? ((StringExpr)e).value : e.toString();
        }
        if (params.length != 4) {
            return null;
        }
        this.props.put(ITEMDATA_INFO_REPORTSHEET, params[0]);
        this.props.put(ITEMDATA_INFO_ROWITEM, params[1]);
        this.props.put(ITEMDATA_INFO_COLUMNITEM, params[2]);
        this.props.put(ITEMDATA_INFO_VALUETYPE, params[3]);
        return this;
    }

    public String toString() {
        return this.getFormula();
    }

    public String getReportSheet() {
        return (String)this.props.get(ITEMDATA_INFO_REPORTSHEET);
    }

    public String getRowItem() {
        return (String)this.props.get(ITEMDATA_INFO_ROWITEM);
    }

    public String getColumnItem() {
        return (String)this.props.get(ITEMDATA_INFO_COLUMNITEM);
    }

    public String getValueType() {
        return (String)this.props.get(ITEMDATA_INFO_VALUETYPE);
    }

    public String getFormulaKey() {
        if (this.props.containsKey(FORMULA_KEY)) {
            return this.props.get(FORMULA_KEY).toString();
        }
        return null;
    }

    public void setFormulaKey(String v) {
        if (this.props.containsKey(FORMULA_KEY)) {
            this.props.remove(FORMULA_KEY);
        }
        this.props.put(FORMULA_KEY, v);
    }

    public String getFormula() {
        if (this.props.containsKey(ITEMDATA_INFO_FORMULA)) {
            return this.props.get(ITEMDATA_INFO_FORMULA).toString();
        }
        return null;
    }

    public void setFormula(String formula) {
        this.props.put(ITEMDATA_INFO_FORMULA, formula);
    }

    public Cell getCell() {
        return this.cell;
    }

    public void setCell(Cell v) {
        this.cell = v;
    }

    public Sheet getSheet() {
        return this.sheet;
    }

    public void setSheet(Sheet s) {
        this.sheet = s;
    }

    public String getLocation() {
        if (this.sheet == null || this.cell == null) {
            return "";
        }
        return StructureUtils.getCellLocation(this.sheet, this.cell);
    }

    public Object getValue() {
        if (this.props.containsKey(ITEMDATA_INFO_VALUE)) {
            return this.props.get(ITEMDATA_INFO_VALUE).toString();
        }
        return null;
    }

    public void setValue(Object v) {
        if (this.props.containsKey(ITEMDATA_INFO_VALUE)) {
            this.props.remove(ITEMDATA_INFO_VALUE);
        }
        this.props.put(ITEMDATA_INFO_VALUE, v.toString());
    }

    public String getExt(String key) {
        Object o = this.props.get(key);
        if (o != null) {
            return o.toString();
        }
        return null;
    }

    public void putExt(String key, String value) {
        if (key == null) {
            return;
        }
        if (value == null) {
            value = "";
        }
        this.props.put(key, value);
    }

    public void removeExt(String key) {
        if (this.props.containsKey(key)) {
            this.props.remove(key);
        }
    }

    public void fromSerialString(String s) throws Exception {
        IObjectIterator it = TaxUserObjectTrans.createObjectIterator(s);
        if (it.hasNext()) {
            this.props = (HashMap)it.nextObject();
        }
        if (this.props == null) {
            this.props = new HashMap();
        }
    }

    public String toSerialString() throws Exception {
        StringBuffer sb = new StringBuffer();
        TaxUserObjectTrans.toString((HashMap)this.props, sb);
        return sb.toString();
    }

    public Map getExt() {
        HashMap map = new HashMap();
        for (Object key : this.props.keySet()) {
            map.put(key, this.props.get(key));
        }
        return map;
    }

    public Object clone() {
        try {
            TaxItemFormula o = (TaxItemFormula)super.clone();
            o.props = (HashMap)((HashMap)this.props).clone();
            return o;
        }
        catch (Exception e) {
            logger.debug((Object)("clone err:" + e.getLocalizedMessage()));
            return null;
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        StringBuffer buf = new StringBuffer();
        if (this.props != null && !this.props.isEmpty()) {
            Set s = this.props.keySet();
            Iterator iter = s.iterator();
            while (iter.hasNext()) {
                String temp = iter.next().toString();
                buf.append(FLAG_CELL + temp + FLAG_KEY_VALUE + this.props.get(temp));
            }
            out.writeObject(buf.toString());
        } else {
            out.writeObject(null);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        Object o = null;
        o = in.readObject();
        if (o == null) {
            this.props = new HashMap(1);
        } else if (o instanceof String) {
            String[] temp = o.toString().split(FLAG_CELL);
            if (temp != null) {
                for (int i = 1; i < temp.length; ++i) {
                    int index = temp[i].indexOf(FLAG_KEY_VALUE);
                    String key = temp[i].substring(0, index);
                    String value = temp[i].substring(index + 1, temp[i].length());
                    this.props.put(key, value);
                }
            }
        } else if (o instanceof HashMap) {
            int index;
            String f;
            HashMap m = (HashMap)o;
            Set s = m.keySet();
            Iterator iter = s.iterator();
            Object obj = null;
            while (iter.hasNext()) {
                obj = iter.next();
                this.props.put(obj.toString(), m.get(obj).toString());
            }
            if (this.props.containsKey(ITEMDATA_INFO_FORMULA) && (f = this.props.get(ITEMDATA_INFO_FORMULA).toString()) != null && f.length() != 0 && (index = f.indexOf(ITEMDATA_INFO_FORMULAHEAD)) == -1) {
                this.props.put(ITEMDATA_INFO_FORMULA, ITEMDATA_INFO_FORMULAHEAD + f);
            }
        } else {
            throw new ClassNotFoundException();
        }
    }
}

