/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.structure.utils;

import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.eas.fi.rpt.util.IObjectIterator;
import com.kingdee.eas.fi.rpt.util.NullUserObject;
import com.kingdee.eas.tm.td.structure.utils.TaxObjectIterator_20;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;

public class TaxUserObjectTrans
implements Book.IUserObjectProvider {
    private static final Logger logger = Logger.getLogger(TaxUserObjectTrans.class);
    static final char _SPLIT_1_0 = '\u0593';
    static final char _SPLIT_2_0 = '#';
    static Map TypeClassMapping = null;
    private static Map ClassTypeMapping = null;
    private static String[] Protected_UserObject_Keys = new String[]{"ITEM", "Foreign_Conv_Bala", "TAXITEM"};
    private boolean bProtectUserObject = false;

    public TaxUserObjectTrans() {
        this(false);
    }

    public TaxUserObjectTrans(boolean protectUO) {
        this.bProtectUserObject = protectUO;
    }

    private static void initSerialContext() {
        if (TypeClassMapping != null) {
            return;
        }
        TypeClassMapping = new HashMap(5);
        ClassTypeMapping = new HashMap(5);
        try {
            TaxUserObjectTrans.loadTypeDefine();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadTypeDefine() throws Exception {
        try (InputStream in = null;){
            in = TaxUserObjectTrans.class.getResourceAsStream("UserObjectTypeDefine.properties");
            Properties p = new Properties();
            p.load(in);
            for (Map.Entry<Object, Object> e : p.entrySet()) {
                Class<?> c = Class.forName((String)e.getValue());
                TypeClassMapping.put(e.getKey(), c);
                ClassTypeMapping.put(c, e.getKey());
            }
        }
    }

    public static String getSerialString(Object obj) {
        StringBuffer sb = new StringBuffer();
        if (obj == null) {
            TaxUserObjectTrans.nullObjectToString(sb);
            return sb.toString();
        }
        if (obj instanceof String) {
            TaxUserObjectTrans.toString((String)obj, sb);
        } else if (obj instanceof Integer) {
            TaxUserObjectTrans.toString((Integer)obj, sb);
        } else if (obj instanceof BigDecimal) {
            TaxUserObjectTrans.toString((BigDecimal)obj, sb);
        } else if (obj instanceof Boolean) {
            TaxUserObjectTrans.toString((Boolean)obj, sb);
        } else if (obj instanceof ArrayList) {
            TaxUserObjectTrans.toString((ArrayList)obj, sb);
        } else if (obj instanceof HashMap) {
            TaxUserObjectTrans.toString((HashMap)obj, sb);
        } else {
            Class<?> clazz = obj.getClass();
            String type = (String)ClassTypeMapping.get(clazz);
            if (type == null) {
                logger.warn((Object)("KDSpread UserObject: " + clazz.getName() + " has not registered, do not serialize."));
                return null;
            }
            String temp = null;
            try {
                Method method = clazz.getMethod("toSerialString", null);
                temp = (String)method.invoke(obj, null);
            }
            catch (NoSuchMethodException e) {
                UnsupportedOperationException u = new UnsupportedOperationException("User Object " + obj.getClass() + " must implement method 'String toSerialString()'");
                u.setStackTrace(e.getStackTrace());
                throw u;
            }
            catch (IllegalArgumentException e) {
                UnsupportedOperationException u = new UnsupportedOperationException();
                u.setStackTrace(e.getStackTrace());
                throw u;
            }
            catch (IllegalAccessException e) {
                UnsupportedOperationException u = new UnsupportedOperationException();
                u.setStackTrace(e.getStackTrace());
                throw u;
            }
            catch (InvocationTargetException e) {
                UnsupportedOperationException u = new UnsupportedOperationException();
                u.setStackTrace(e.getStackTrace());
                throw u;
            }
            if (temp == null) {
                return null;
            }
            sb.append(TaxUserObjectTrans.getSplit()).append(type).append(TaxUserObjectTrans.getSplit()).append(temp.length()).append(TaxUserObjectTrans.getSplit()).append(temp);
        }
        return sb.toString();
    }

    public static void toString(ArrayList l, StringBuffer sb) {
        if (l == null || l.size() < 1) {
            TaxUserObjectTrans.nullObjectToString(sb);
            return;
        }
        StringBuffer temp = new StringBuffer();
        for (int i = 0; i < l.size(); ++i) {
            temp.append(TaxUserObjectTrans.getSerialString(l.get(i)));
        }
        sb.append(TaxUserObjectTrans.getSplit()).append(ClassTypeMapping.get(ArrayList.class)).append(TaxUserObjectTrans.getSplit()).append(temp.length()).append(TaxUserObjectTrans.getSplit()).append(temp);
    }

    public static void toString(HashMap l, StringBuffer sb) {
        if (l == null || l.isEmpty()) {
            TaxUserObjectTrans.nullObjectToString(sb);
            return;
        }
        StringBuffer temp = new StringBuffer();
        for (Map.Entry e : l.entrySet()) {
            if (e.getValue() == null) continue;
            temp.append(TaxUserObjectTrans.getSerialString(e.getKey())).append(TaxUserObjectTrans.getSerialString(e.getValue()));
        }
        sb.append(TaxUserObjectTrans.getSplit()).append(ClassTypeMapping.get(HashMap.class)).append(TaxUserObjectTrans.getSplit()).append(temp.length()).append(TaxUserObjectTrans.getSplit()).append(temp);
    }

    public Object getObject(String key, String str) {
        if (str == null || str.length() < 1) {
            return null;
        }
        IObjectIterator i = TaxUserObjectTrans.createObjectIterator(str);
        if (i == null) {
            return str;
        }
        try {
            return i.nextObject();
        }
        catch (Exception e) {
            return str;
        }
    }

    public static IObjectIterator createObjectIterator(String s) {
        TaxObjectIterator_20 i = null;
        i = new TaxObjectIterator_20(s);
        return i;
    }

    public static void nullObjectToString(StringBuffer sb) {
        sb.append(TaxUserObjectTrans.getSplit()).append(ClassTypeMapping.get(NullUserObject.class)).append(TaxUserObjectTrans.getSplit()).append(0).append(TaxUserObjectTrans.getSplit());
    }

    public static void toString(Boolean b, StringBuffer sb) {
        if (b == null) {
            TaxUserObjectTrans.nullObjectToString(sb);
            return;
        }
        sb.append(TaxUserObjectTrans.getSplit()).append(ClassTypeMapping.get(Boolean.class)).append(TaxUserObjectTrans.getSplit()).append(1).append(TaxUserObjectTrans.getSplit()).append(b != false ? 1 : 0);
    }

    public static void toString(String s, StringBuffer sb) {
        if (s == null) {
            TaxUserObjectTrans.nullObjectToString(sb);
            return;
        }
        int length = s.length();
        sb.append(TaxUserObjectTrans.getSplit()).append(ClassTypeMapping.get(String.class)).append(TaxUserObjectTrans.getSplit()).append(length).append(TaxUserObjectTrans.getSplit()).append(s);
    }

    public static void toString(Integer i, StringBuffer sb) {
        if (i == null) {
            TaxUserObjectTrans.nullObjectToString(sb);
            return;
        }
        String s = i.toString();
        int length = s.length();
        sb.append(TaxUserObjectTrans.getSplit()).append(ClassTypeMapping.get(Integer.class)).append(TaxUserObjectTrans.getSplit()).append(length).append(TaxUserObjectTrans.getSplit()).append(s);
    }

    public static void toString(BigDecimal i, StringBuffer sb) {
        if (i == null) {
            TaxUserObjectTrans.nullObjectToString(sb);
            return;
        }
        String s = i.toString();
        int length = s.length();
        sb.append(TaxUserObjectTrans.getSplit()).append(ClassTypeMapping.get(BigDecimal.class)).append(TaxUserObjectTrans.getSplit()).append(length).append(TaxUserObjectTrans.getSplit()).append(s);
    }

    private static char getSplit() {
        return '#';
    }

    public String getString(String key, Object uo) {
        TaxUserObjectTrans.initSerialContext();
        return TaxUserObjectTrans.getSerialString(uo);
    }

    public String[] getKeepKeys() {
        if (this.bProtectUserObject) {
            return Protected_UserObject_Keys;
        }
        return null;
    }

    static {
        TaxUserObjectTrans.initSerialContext();
    }
}

