/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.taxes.land.client;

import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.tm.td.OwnerMenuEnum;
import com.kingdee.eas.tm.td.RecordTypeEnum;
import com.kingdee.eas.tm.td.basedata.AccountTypeFactory;
import com.kingdee.eas.tm.td.basedata.AccountTypeInfo;
import com.kingdee.eas.tm.td.basedata.TaxItemTypeFactory;
import com.kingdee.eas.tm.td.basedata.TaxItemTypeInfo;
import com.kingdee.eas.tm.td.taxes.land.client.AbstractLandAccountTaxDraftEditUI;
import com.kingdee.eas.tm.td.taxes.land.client.LandAccountTaxDraftRptUI;
import com.kingdee.eas.tm.td.utils.TDPermissionUtil;
import com.kingdee.eas.tm.td.utils.TDSelectorFactory;
import org.apache.log4j.Logger;

public class LandAccountTaxDraftEditUI
extends AbstractLandAccountTaxDraftEditUI {
    private static final Logger logger = CoreUIObject.getLogger(LandAccountTaxDraftEditUI.class);
    private AccountTypeInfo accountType = null;
    private TaxItemTypeInfo taxType = null;

    @Override
    protected String getPermissionItem(String actionType) {
        return TDPermissionUtil.getTaxDraftPermissionItem(actionType, "land", "taxaccount");
    }

    @Override
    public void loadFields() {
        this.removeListener();
        super.loadFields();
        this.addListener();
        this.initControl();
    }

    @Override
    public void storeFields() {
        super.storeFields();
        if (this.prmtPeriod.getValue() != null) {
            PeriodInfo period = (PeriodInfo)this.prmtPeriod.getValue();
            this.editData.setYear(period.getPeriodYear());
            this.editData.setPeriod((short)period.getPeriodNumber());
        }
    }

    @Override
    protected String getTaxDraftRptUI() {
        return LandAccountTaxDraftRptUI.class.getName();
    }

    @Override
    public SelectorItemCollection getSelectors() {
        return TDSelectorFactory.getTaxDraftRecordSelectors();
    }

    @Override
    protected AccountTypeInfo getAccountTypeInfo() throws Exception {
        if (this.accountType == null) {
            try {
                this.accountType = AccountTypeFactory.getRemoteInstance().getAccountTypeInfo((IObjectPK)new ObjectUuidPK("km27JnkseY/gUzA/qMDnRj2YoPU="));
            }
            catch (Exception e) {
                return null;
            }
        }
        return this.accountType;
    }

    @Override
    protected TaxItemTypeInfo getTaxTypeInfo() throws Exception {
        if (this.taxType == null) {
            try {
                this.taxType = TaxItemTypeFactory.getRemoteInstance().getTaxItemTypeInfo((IObjectPK)new ObjectUuidPK("d8umkg7qNn3gU0ETqMCsX9uK96Y="));
            }
            catch (Exception e) {
                return null;
            }
        }
        return this.taxType;
    }

    @Override
    protected RecordTypeEnum getRecordType() {
        return RecordTypeEnum.Account;
    }

    @Override
    protected OwnerMenuEnum getOwnerMenu() {
        return OwnerMenuEnum.LandAccountTaxDraft;
    }
}

