/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.message.common;

import com.kingdee.bos.message.common.KDMessage;
import com.kingdee.bos.message.common.KDMessageAddress;
import com.kingdee.bos.message.common.KDMessageType;

public class KDMessageTookit {
    private static final String FACILITY_STOP = "facility_stop";
    private static final String FACILITY_START = "facility_start";
    private static final String FACILITY_LOGIN_OK = "LOGIN_OK";
    private static final String FACILITY_LOGIN_FAILURE = "LOGIN_FAILURE";

    public static KDMessage getMsgForStop(String facilityId) {
        KDMessage msg = new KDMessage();
        msg.setType(KDMessageType.SYSTEM);
        msg.setTitle(FACILITY_STOP);
        KDMessageAddress sender = new KDMessageAddress(facilityId, facilityId);
        msg.setSender(sender);
        return msg;
    }

    public static boolean isFacilityStopMsg(KDMessage msg) {
        return KDMessageType.SYSTEM.equals(msg.getType()) && FACILITY_STOP.equals(msg.getTitle());
    }

    public static KDMessage getMsgForStart(String facilityId, String password) {
        KDMessage msg = new KDMessage();
        msg.setType(KDMessageType.SYSTEM);
        msg.setTitle(FACILITY_START);
        KDMessageAddress sender = new KDMessageAddress(facilityId, facilityId);
        msg.setContent(password);
        return msg;
    }

    public static boolean isFacilityStartMsg(KDMessage msg) {
        return KDMessageType.SYSTEM.equals(msg.getType()) && FACILITY_START.equals(msg.getTitle());
    }

    public static KDMessage getMsgForLoginOK(KDMessage msg) {
        msg.setType(KDMessageType.SYSTEM);
        msg.setTitle(FACILITY_LOGIN_OK);
        return msg;
    }

    public static boolean isMsgForLoginOK(KDMessage msg) {
        return KDMessageType.SYSTEM.equals(msg.getType()) && FACILITY_LOGIN_OK.equals(msg.getTitle());
    }

    public static KDMessage getMsgForLoginFailure(KDMessage msg, String cause) {
        msg.setType(KDMessageType.SYSTEM);
        msg.setTitle(FACILITY_LOGIN_FAILURE);
        msg.setContent(cause);
        return msg;
    }

    public static boolean isMsgForLoginFailure(KDMessage msg) {
        return KDMessageType.SYSTEM.equals(msg.getType()) && FACILITY_LOGIN_FAILURE.equals(msg.getTitle());
    }
}

