/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.message.common;

import com.kingdee.bos.message.common.KDMessage;
import com.kingdee.bos.message.common.KDMessageAddress;
import com.kingdee.bos.message.common.KDMsgCreator;
import com.kingdee.bos.message.common.util.StringUtil;

public class KDMsgCreatorImpl
extends KDMsgCreator {
    private static final KDMsgCreator INSTANCE = new KDMsgCreatorImpl();

    private KDMsgCreatorImpl() {
    }

    public static KDMsgCreator getInstance() {
        return INSTANCE;
    }

    public KDMessage createMsgForMail(String mailList, String title, String txtBody) {
        KDMessage msg = new KDMessage();
        msg.setTitle(title);
        msg.setContent(txtBody);
        msg.setReceivers(KDMsgCreatorImpl.getReceivers(mailList, "mp:mail"));
        return msg;
    }

    public KDMessage createMsgForSMS(String numberList, String title) {
        KDMessage msg = new KDMessage();
        msg.setTitle(title);
        msg.setReceivers(KDMsgCreatorImpl.getReceivers(numberList, "mp:sms"));
        return msg;
    }

    public KDMessage createMsgForRtx(String numberList, String title, String txtBody) {
        KDMessage msg = new KDMessage();
        msg.setTitle(title);
        msg.setContent(txtBody);
        msg.setReceivers(KDMsgCreatorImpl.getReceivers(numberList, "mp:im"));
        return msg;
    }

    private static final KDMessageAddress[] getReceivers(String receivers, String addressType) {
        if (receivers == null || receivers.trim().length() == 0) {
            return null;
        }
        String[] tos = KDMsgCreatorImpl.split(receivers);
        return KDMsgCreatorImpl.getReceivers(tos, addressType);
    }

    private static final String[] split(String receivers) {
        String temp = StringUtil.replace(receivers, ";", ",");
        String[] result = StringUtil.split(temp, ",");
        return result;
    }

    private static final KDMessageAddress[] getReceivers(String[] tos, String deviceType) {
        KDMessageAddress[] addrs = new KDMessageAddress[tos.length];
        for (int i = 0; tos != null && i < tos.length; ++i) {
            KDMessageAddress address;
            addrs[i] = address = new KDMessageAddress(deviceType, tos[i]);
        }
        return addrs;
    }

    public KDMessage createMsgForBiz(String title, String txtBody, String bizname) {
        KDMessage msg = new KDMessage();
        msg.setTitle(title);
        msg.setContent(txtBody);
        KDMessageAddress address = new KDMessageAddress(bizname, bizname);
        msg.setReceivers(new KDMessageAddress[]{address});
        return msg;
    }

    public void addMailTo(KDMessage msg, String mailAddress) {
        this.setMailAddress(msg, mailAddress, 0);
    }

    public void addMailCc(KDMessage msg, String mailAddress) {
        this.setMailAddress(msg, mailAddress, 1);
    }

    public void addMailBcc(KDMessage msg, String mailAddress) {
        this.setMailAddress(msg, mailAddress, 2);
    }

    private void setMailAddress(KDMessage msg, String mailAddress, int level) {
        KDMessageAddress[] temp = KDMsgCreatorImpl.getReceivers(mailAddress, "mp:mail");
        if (temp == null || temp.length == 0) {
            return;
        }
        for (int i = 0; temp != null && i < temp.length; ++i) {
            temp[i].setLevel(level);
        }
        KDMessageAddress[] receiver = msg.getReceivers();
        if (receiver == null || receiver.length == 0) {
            msg.setReceivers(temp);
            return;
        }
        KDMessageAddress[] temp2 = new KDMessageAddress[receiver.length + temp.length];
        System.arraycopy(receiver, 0, temp2, 0, receiver.length);
        System.arraycopy(temp, 0, temp2, receiver.length, temp.length);
        msg.setReceivers(temp2);
    }
}

