/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.message.common;

import com.kingdee.bos.message.common.KDMessage;
import com.kingdee.bos.message.common.KDMessageType;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class KDMsgStateWatcher {
    private static Map states = Collections.synchronizedMap(new HashMap());

    public static final String getState(String id) {
        Object obj = states.get(id);
        if (obj == null) {
            return "notCreated Or SendCompleted";
        }
        return obj.toString();
    }

    private static final void setState(String id, String state) {
        if (state == null) {
            return;
        }
        String prev = (String)states.get(id);
        if (prev == null) {
            states.put(id, state);
        } else {
            states.put(id, prev + "->" + state);
        }
    }

    public static void setInit(KDMessage msg) {
        if (msg.getType().equals(KDMessageType.TEST)) {
            KDMsgStateWatcher.setState(msg.getId(), "init");
        }
    }

    public static void setPooling(KDMessage msg) {
        if (msg.getType().equals(KDMessageType.TEST)) {
            KDMsgStateWatcher.setState(msg.getId(), "pooling");
        }
    }

    public static void setPersistent(KDMessage msg) {
        if (msg.getType().equals(KDMessageType.TEST)) {
            KDMsgStateWatcher.setState(msg.getId(), "persistent");
        }
    }

    public static void setSentting(KDMessage msg) {
        if (msg.getType().equals(KDMessageType.TEST)) {
            KDMsgStateWatcher.setState(msg.getId(), "Sendding");
        }
    }

    public static void setSent(KDMessage msg) {
        KDMsgStateWatcher.setState(msg.getId(), "Sent");
    }

    public static void setCompleted(KDMessage msg) {
        if (msg.getType().equals(KDMessageType.TEST)) {
            KDMsgStateWatcher.setState(msg.getId(), "Completed \r\n");
        }
    }

    public static void setSendFailured(KDMessage msg) {
        if (msg.getType().equals(KDMessageType.TEST)) {
            KDMsgStateWatcher.setState(msg.getId(), "SendFailured");
        }
    }
}

