/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.webservice;

import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.util.enums.Enum;
import java.math.BigDecimal;

public class BeanConvertUtil {
    public static Object convertToNative(OwnPropertyInfo ownerPropertyInfo, Object fieldValue) {
        DataType type = ownerPropertyInfo.getDataType();
        return BeanConvertUtil.convertToNative(type, fieldValue);
    }

    public static Object convertToNative(DataType type, Object fieldValue) {
        if (fieldValue == null) {
            return null;
        }
        if (type.equals((Object)DataType.SHORT)) {
            return fieldValue;
        }
        if (type.equals((Object)DataType.INTEGER)) {
            return fieldValue;
        }
        if (type.equals((Object)DataType.LONG)) {
            return fieldValue;
        }
        if (type.equals((Object)DataType.FLOAT)) {
            return fieldValue;
        }
        if (type.equals((Object)DataType.DOUBLE)) {
            return fieldValue;
        }
        if (type.equals((Object)DataType.DATE)) {
            return fieldValue.toString();
        }
        if (type.equals((Object)DataType.TIME)) {
            return fieldValue.toString();
        }
        if (type.equals((Object)DataType.TIMESTAMP)) {
            return fieldValue.toString();
        }
        if (type.equals((Object)DataType.CHAR)) {
            return fieldValue;
        }
        if (type.equals((Object)DataType.BOOLEAN)) {
            return fieldValue;
        }
        if (type.equals((Object)DataType.BYTE)) {
            return fieldValue;
        }
        if (type.equals((Object)DataType.STRING)) {
            return fieldValue;
        }
        if (type.equals((Object)DataType.OBJECTPK)) {
            return BeanConvertUtil.objectPK2Native(fieldValue);
        }
        if (type.equals((Object)DataType.BOSUUID)) {
            return fieldValue.toString();
        }
        if (type.equals((Object)DataType.UUID)) {
            return fieldValue.toString();
        }
        if (type.equals((Object)DataType.OBJECTCOLLECTION)) {
            return null;
        }
        if (type.equals((Object)DataType.BYTEARRAY)) {
            return fieldValue;
        }
        if (type.equals((Object)DataType.OBJECTVALUE)) {
            return null;
        }
        if (type.equals((Object)DataType.DECIMAL)) {
            return new Double(((BigDecimal)fieldValue).doubleValue());
        }
        if (type.equals((Object)DataType.ENUM)) {
            return ((Enum)fieldValue).getName();
        }
        if (type.equals((Object)DataType.ROWSET)) {
            return null;
        }
        return null;
    }

    private static Object objectPK2Native(Object fieldValue) {
        if (fieldValue instanceof IObjectPK) {
            IObjectPK pk = (IObjectPK)fieldValue;
            String[] rtnValues = new String[pk.getKeyFields().length * 2];
            int k = 0;
            for (int i = 0; i < pk.getKeyFields().length; ++i) {
                rtnValues[k] = pk.getKeyFields()[i];
                rtnValues[++k] = pk.getKeyValue(pk.getKeyFields()[i]).toString();
            }
            return rtnValues;
        }
        return null;
    }

    public static String getJavaType(DataType type) {
        if (type.equals((Object)DataType.SHORT)) {
            return "short";
        }
        if (type.equals((Object)DataType.INTEGER)) {
            return "int";
        }
        if (type.equals((Object)DataType.LONG)) {
            return "long";
        }
        if (type.equals((Object)DataType.FLOAT)) {
            return "float";
        }
        if (type.equals((Object)DataType.DOUBLE)) {
            return "double";
        }
        if (type.equals((Object)DataType.DATE)) {
            return "String";
        }
        if (type.equals((Object)DataType.TIME)) {
            return "String";
        }
        if (type.equals((Object)DataType.TIMESTAMP)) {
            return "String";
        }
        if (type.equals((Object)DataType.CHAR)) {
            return "char";
        }
        if (type.equals((Object)DataType.BOOLEAN)) {
            return "boolean";
        }
        if (type.equals((Object)DataType.BYTE)) {
            return "byte";
        }
        if (type.equals((Object)DataType.STRING)) {
            return "String";
        }
        if (type.equals((Object)DataType.OBJECTPK)) {
            return "String[]";
        }
        if (type.equals((Object)DataType.BOSUUID)) {
            return "String";
        }
        if (type.equals((Object)DataType.UUID)) {
            return "String";
        }
        if (type.equals((Object)DataType.OBJECTCOLLECTION)) {
            return IObjectCollection.class.getName();
        }
        if (type.equals((Object)DataType.BYTEARRAY)) {
            return "byte[]";
        }
        if (type.equals((Object)DataType.OBJECTVALUE)) {
            return IObjectValue.class.getName();
        }
        if (type.equals((Object)DataType.DECIMAL)) {
            return "double";
        }
        if (type.equals((Object)DataType.ENUM)) {
            return "String";
        }
        if (type.equals((Object)DataType.ROWSET)) {
            return null;
        }
        return null;
    }
}

