/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.webservice;

import com.kingdee.bos.webservice.WSConfig;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.log4j.Logger;

public class WSConfigListener
implements ServletContextListener {
    private static final Logger logger = Logger.getLogger(WSConfigListener.class);

    public void contextInitialized(ServletContextEvent e) {
        String configFile = e.getServletContext().getInitParameter("configfile");
        Properties prop = null;
        if (!StringUtils.isEmpty((String)configFile)) {
            String realPath = e.getServletContext().getRealPath("/");
            String configFileFullName = realPath + "/WEB-INF/" + configFile;
            logger.info((Object)("property file is:" + configFileFullName));
            try {
                prop = new Properties();
                prop.load(new FileInputStream(new File(configFileFullName)));
            }
            catch (FileNotFoundException ex) {
                logger.error((Object)("could not find file :" + configFileFullName));
            }
            catch (IOException ex) {
                logger.error((Object)("io error:" + configFileFullName));
            }
        }
        logger.info((Object)"init WSConfig");
        if (prop != null) {
            WSConfig.init(prop);
        } else {
            WSConfig.init();
        }
    }

    public void contextDestroyed(ServletContextEvent arg0) {
    }
}

