/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.netctrl.adapter;

import com.kingdee.bos.AbstractBOSObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.netctrl.DataLockParameter;
import com.kingdee.eas.base.netctrl.IJudgement;
import com.kingdee.eas.base.netctrl.IMutexServiceFacade;
import com.kingdee.eas.base.netctrl.IORMRPCMutextServiceControl;
import com.kingdee.eas.base.netctrl.MutexParameter;
import com.kingdee.eas.base.netctrl.MutexServiceFacadeFactory;
import com.kingdee.eas.base.netctrl.ObjectUpdateLock;
import com.kingdee.util.Uuid;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class MutexServiceDBAdapter
extends AbstractBOSObject
implements IORMRPCMutextServiceControl {
    private IMutexServiceFacade adaptee = null;
    private Logger logger = Logger.getLogger(MutexServiceDBAdapter.class);
    private final boolean bRetValue = true;

    private MutexServiceDBAdapter(IMutexServiceFacade facad) {
        this.adaptee = facad;
    }

    private MutexServiceDBAdapter() {
    }

    private IMutexServiceFacade getAdaptee(Context ctx) throws BOSException {
        if (this.adaptee == null) {
            Context threadCtx = ContextUtils.getContextFromSessionNoException();
            this.adaptee = threadCtx != null ? MutexServiceFacadeFactory.getLocalInstance(threadCtx) : MutexServiceFacadeFactory.getLocalInstance(ctx);
            if (this.adaptee == null) {
                throw new BOSException("adaptee is null");
            }
        }
        return this.adaptee;
    }

    public static IORMRPCMutextServiceControl getService(IMutexServiceFacade facad) {
        return new MutexServiceDBAdapter(facad);
    }

    public static IORMRPCMutextServiceControl getService() {
        return new MutexServiceDBAdapter();
    }

    @Override
    public boolean requestMutex(Context ctx, MutexParameter mutexParameter) {
        try {
            return this.getAdaptee(ctx).requestMutex(mutexParameter);
        }
        catch (BOSException e) {
            this.error("\u7533\u8bf7\u529f\u80fd\u4e92\u65a5\u9501\u53d1\u751f\u5f02\u5e38");
            return true;
        }
    }

    @Override
    public void releaseMutex(Context ctx, Uuid requestId) {
        try {
            this.getAdaptee(ctx).releaseMutex(requestId);
        }
        catch (BOSException e) {
            this.error("\u91ca\u653e\u529f\u80fd\u4e92\u65a5\u9501\u53d1\u751f\u5f02\u5e38");
        }
    }

    @Override
    public Map getMutexList(Context ctx) {
        HashMap map;
        try {
            map = this.getAdaptee(ctx).getMutexList();
        }
        catch (BOSException e) {
            map = new HashMap();
            this.error("\u83b7\u53d6\u529f\u80fd\u4e92\u65a5\u5217\u8868\u5931\u8d25");
        }
        return map;
    }

    @Override
    public void clearAllMutex(Context ctx) {
        try {
            this.getAdaptee(ctx).clearAllMutex();
        }
        catch (BOSException e) {
            this.error("\u6e05\u7a7a\u6240\u6709\u529f\u80fd\u4e92\u65a5\u64cd\u4f5c\u5931\u8d25");
        }
    }

    @Override
    public void delMutex(Context ctx, String id) {
        try {
            this.getAdaptee(ctx).delMutex(id);
        }
        catch (BOSException e) {
            this.error("\u5220\u9664\u529f\u80fd\u4e92\u65a5\u5931\u8d25\uff0cid\u4e3a" + id);
        }
    }

    @Override
    public void releaseObjIDForUpdate(Context ctx, String id) {
        try {
            this.getAdaptee(ctx).releaseObjIDForUpdate(id);
        }
        catch (BOSException e) {
            this.error("\u91ca\u653e\u6570\u636e\u4e92\u65a5\u9501\u5931\u8d25\uff0cid\u4e3a" + id);
        }
    }

    @Override
    public HashMap getObjIDForUpdateList(Context ctx) {
        HashMap map;
        try {
            map = this.getAdaptee(ctx).getObjIDForUpdateList();
        }
        catch (BOSException e) {
            map = new HashMap();
            this.error("\u83b7\u53d6\u6570\u636e\u4e92\u65a5\u5217\u8868\u5931\u8d25");
        }
        return map;
    }

    @Override
    public void delObjIDForUpdate(Context ctx, String id) {
        try {
            this.getAdaptee(ctx).delObjIDForUpdate(id);
        }
        catch (BOSException e) {
            this.error("\u91ca\u653e\u6570\u636e\u4e92\u65a5\u9501\u5931\u8d25\uff0cid\u4e3a" + id);
        }
    }

    @Override
    public boolean requestObjIDForUpdate(Context ctx, String id) {
        boolean retValue = true;
        try {
            retValue = this.getAdaptee(ctx).requestObjIDForUpdate(id);
        }
        catch (BOSException e) {
            this.error("\u7533\u8bf7\u6570\u636e\u4e92\u65a5\u9501\u5931\u8d25\uff0cid\u4e3a" + id);
        }
        return retValue;
    }

    @Override
    public boolean requestBizObjIDForUpdate(Context ctx, String id) {
        boolean retValue = true;
        try {
            retValue = this.getAdaptee(ctx).requestBizObjIDForUpdate(id);
        }
        catch (BOSException e) {
            this.error("\u7533\u8bf7\u6570\u636e\u4e92\u65a5\u9501\u5931\u8d25\uff0cid\u4e3a" + id);
        }
        return retValue;
    }

    @Override
    public boolean requestBizObjIDForUpdate(Context ctx, String id, String objectDescription) {
        return this.requestBizObjIDForUpdate(ctx, id);
    }

    @Override
    public boolean requestObjIDForUpdate(Context ctx, String id, String userId) {
        boolean retValue = true;
        try {
            retValue = this.getAdaptee(ctx).requestObjIDForUpdate(id, userId);
        }
        catch (BOSException e) {
            this.error("\u7533\u8bf7\u6570\u636e\u4e92\u65a5\u9501\u5931\u8d25\uff0cid\u4e3a" + id);
        }
        return retValue;
    }

    @Override
    public boolean requestObjIDForUpdate(Context ctx, String id, String userId, String dcName) {
        boolean retValue = true;
        try {
            retValue = this.getAdaptee(ctx).requestObjIDForUpdate(id, userId, dcName);
        }
        catch (BOSException e) {
            this.error("\u7533\u8bf7\u6570\u636e\u4e92\u65a5\u9501\u5931\u8d25\uff0cid\u4e3a" + id);
        }
        return retValue;
    }

    @Override
    public boolean requestObjIDForUpdate(Context ctx, String id, String userId, String dcName, String objectDescription) {
        boolean retValue = true;
        try {
            retValue = this.getAdaptee(ctx).requestObjIDForUpdate(id, userId, dcName, objectDescription);
        }
        catch (BOSException e) {
            this.error("\u7533\u8bf7\u6570\u636e\u4e92\u65a5\u9501\u5931\u8d25\uff0cid\u4e3a" + id);
        }
        return retValue;
    }

    @Override
    public ObjectUpdateLock requestObjIDForUpdate2(Context ctx, String id, String userId, String dcName, String objectDescription) {
        return this.requestObjIDForUpdate2(ctx, id, userId, null);
    }

    @Override
    public ObjectUpdateLock requestObjIDForUpdate2(Context ctx, String id, String userId, String dcName) {
        boolean success = this.requestObjIDForUpdate(ctx, id, userId, dcName);
        if (success) {
            return null;
        }
        return this.getObjectUpdateLock(ctx, id);
    }

    @Override
    public boolean requestObjIDForUpdate(Context ctx, String id, String userId, Uuid uuid) {
        boolean retValue = true;
        try {
            retValue = this.getAdaptee(ctx).requestObjIDForUpdate(id, userId, uuid);
        }
        catch (BOSException e) {
            this.error("\u7533\u8bf7\u6570\u636e\u4e92\u65a5\u9501\u5931\u8d25\uff0cid\u4e3a" + id);
        }
        return retValue;
    }

    @Override
    public boolean requestObjIDForUpdateWithUuid(Context ctx, String id, String userId, Uuid uuid, String objectDescription) {
        return this.requestObjIDForUpdate(ctx, id, userId, uuid);
    }

    @Override
    public void releaseObjIDForUpdate(Context ctx, String id, Uuid uuid) {
        try {
            this.getAdaptee(ctx).releaseObjIDForUpdate(id, uuid);
        }
        catch (BOSException e) {
            this.error("\u91ca\u653e\u6570\u636e\u4e92\u65a5\u9501\u5931\u8d25\uff0cid\u4e3a" + id);
        }
    }

    @Override
    public long getCurrentTime(Context ctx) {
        return new Date().getTime();
    }

    private void error(String err) {
        this.logger.error((Object)(err + "\uff0c\u8bf7\u68c0\u67e5\u72b6\u6001\u670d\u52a1\u5668\u662f\u5426\u8fde\u63a5\u6b63\u5e38\u3002"));
    }

    public BOSObjectType getType() {
        return null;
    }

    public IObjectValue getDynObject(Context ctx, String objID) {
        try {
            return this.getAdaptee(ctx).getDynObject(objID);
        }
        catch (BOSException e) {
            return null;
        }
    }

    @Override
    public void releaseAllFuncMutexAndObjLocks(Context ctx, String sessionID) {
        try {
            this.getAdaptee(ctx).releaseAllFuncMutexAndObjLocks(sessionID);
        }
        catch (BOSException e) {
            this.error("\u91ca\u653e\u56de\u8bdd" + sessionID + "\u5360\u7528\u7684\u9501\u5931\u8d25");
        }
    }

    @Override
    public void clearAllObjId(Context ctx) {
        try {
            this.getAdaptee(ctx).clearAllObjId();
        }
        catch (BOSException e) {
            this.error("\u6e05\u7a7a\u6570\u636e\u4e92\u65a5\u9501\u5931\u8d25");
        }
    }

    @Override
    public boolean requestObjIDForUpdate(Context ctx, String id, boolean isBatchRequest) {
        boolean retValue = true;
        try {
            retValue = this.getAdaptee(ctx).requestObjIDForUpdate(id, isBatchRequest);
        }
        catch (BOSException e) {
            this.error("\u7533\u8bf7\u6570\u636e\u4e92\u65a5\u9501\u5931\u8d25\uff0cid\u4e3a" + id);
        }
        return retValue;
    }

    @Override
    public boolean requestObjIDForUpdate(Context ctx, String id, boolean isBatchRequest, String objectDescription) {
        return this.requestObjIDForUpdate(ctx, id, isBatchRequest);
    }

    @Override
    public ObjectUpdateLock getObjectUpdateLock(Context ctx, String id) {
        ObjectUpdateLock lock = null;
        try {
            lock = this.getAdaptee(ctx).getObjectUpdateLock(id);
        }
        catch (Exception e) {
            this.error("\u83b7\u53d6\u6570\u636e\u4e92\u65a5\u9501\u5931\u8d25\uff0cid\u4e3a" + id);
        }
        return lock;
    }

    @Override
    public boolean requestObjIDForUpdate(Context ctx, DataLockParameter dataLockParameter, IJudgement iJudgement) {
        return false;
    }

    @Override
    public void releaseAllFuncMutexAndObjLocksWhenRemoveSession(Context ctx, String sessionID) {
    }

    @Override
    public boolean requestMutex2(Context ctx, MutexParameter mutexParameter) {
        return false;
    }

    @Override
    public MutexParameter requestMutex3(Context ctx, MutexParameter mutexParameter) {
        return null;
    }

    @Override
    public void batchReleaseObjIDForUpdate(Context ctx, List idList) {
        for (String strId : idList) {
            this.releaseObjIDForUpdate(ctx, strId);
        }
    }

    @Override
    public Map batchRequestObjIDForUpdate(Context ctx, List idList) {
        HashMap<String, Boolean> batcheResult = new HashMap<String, Boolean>();
        for (String strId : idList) {
            boolean bResult = this.requestObjIDForUpdate(ctx, strId, true);
            batcheResult.put(strId, bResult);
        }
        return batcheResult;
    }

    @Override
    public Map batchRequestObjIDForUpdate(Context ctx, List idList, String description) {
        return this.batchRequestObjIDForUpdate(ctx, idList);
    }

    @Override
    public Map batchRequestBizObjIDForUpdate(Context ctx, List idList, String objectDescription) {
        return this.batchRequestBizObjIDForUpdate(ctx, idList, objectDescription);
    }

    @Override
    public Map batchRequestBizObjIDForUpdate(Context ctx, List idList) {
        HashMap<String, Boolean> batcheResult = new HashMap<String, Boolean>();
        for (String strId : idList) {
            boolean bResult = this.requestBizObjIDForUpdate(ctx, strId);
            batcheResult.put(strId, bResult);
        }
        return batcheResult;
    }
}

