/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.netctrl.dao;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.netctrl.MutexLockType;
import com.kingdee.eas.base.netctrl.MutexParameter;
import com.kingdee.eas.base.netctrl.ObjectUpdateLock;
import com.kingdee.eas.base.netctrl.dao.IMutexServiceDao;
import com.kingdee.eas.util.app.ClusterServiceFactory;
import com.kingdee.eas.util.app.IClusterService;
import com.kingdee.eas.util.app.StatusDBUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.Uuid;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class MutexServiceDaoImpl
implements IMutexServiceDao {
    Logger logger = Logger.getLogger(MutexServiceDaoImpl.class);
    private String sql;
    private Object[] params;
    IRowSet rowset;
    private Context ctx;

    private MutexServiceDaoImpl(Context ctx) {
        this.ctx = ctx;
    }

    public static IMutexServiceDao getInstance(Context ctx) {
        return new MutexServiceDaoImpl(ctx);
    }

    @Override
    public MutexParameter getMutexParameterByID(String strID) throws BOSException {
        MutexParameter retValue = null;
        this.sql = "select * from T_BAS_FunctionMutex where fid = ?";
        this.params = new Object[]{strID};
        this.rowset = StatusDBUtil.executeQuery((String)this.sql, (Object[])this.params);
        try {
            if (this.rowset.next()) {
                retValue = this.getMutexParameter(this.rowset);
            }
        }
        catch (SQLException e) {
            this.logger.error((Object)"\u8bfb\u53d6\u529f\u80fd\u4e92\u65a5\u6570\u636e\u51fa\u9519\uff01");
        }
        return retValue;
    }

    @Override
    public MutexParameter getMutexParameterByRequestID(String strReqID) throws BOSException {
        MutexParameter retValue = null;
        this.sql = "select * from T_BAS_FunctionMutex where FRequestID = ?";
        this.params = new Object[]{strReqID};
        this.rowset = StatusDBUtil.executeQuery((String)this.sql, (Object[])this.params);
        try {
            if (this.rowset.next()) {
                retValue = this.getMutexParameter(this.rowset);
            }
        }
        catch (SQLException e) {
            this.logger.error((Object)"\u8bfb\u53d6\u529f\u80fd\u4e92\u65a5\u6570\u636e\u51fa\u9519\uff01");
        }
        return retValue;
    }

    private MutexParameter getMutexParameter(IRowSet rowset) {
        MutexParameter retParam = null;
        try {
            String userID;
            String requestID;
            retParam = new MutexParameter();
            retParam.setActionName(rowset.getString("FActionName"));
            retParam.setAIX(rowset.getString("FAIS"));
            retParam.setCreateTime(rowset.getDate("FCreateTime"));
            retParam.setDcName(rowset.getString("FDCName"));
            retParam.setDescription(rowset.getString("FDescription"));
            retParam.setMutexLockType(MutexLockType.getEnum(rowset.getInt("FMutexLockType")));
            retParam.setMutexName(rowset.getString("FMutexName"));
            retParam.setSessionID(rowset.getString("FSessionID"));
            String orgUnitID = rowset.getString("FOrgunitID");
            if (orgUnitID != null && orgUnitID.length() > 0) {
                retParam.setOrgUnitID(BOSUuid.read((String)orgUnitID));
            }
            if ((requestID = rowset.getString("FRequestID")) != null && requestID.length() > 0) {
                retParam.setRequestId(Uuid.read((String)requestID));
            }
            if ((userID = rowset.getString("FUserID")) != null && userID.length() > 0) {
                retParam.setUserID(BOSUuid.read((String)userID));
            }
        }
        catch (SQLException e) {
            retParam = null;
        }
        return retParam;
    }

    @Override
    public ObjectUpdateLock getObjectUpdateLockByObjectID(String strObjID) throws BOSException {
        ObjectUpdateLock retValue = null;
        this.sql = "select * from T_BAS_DataUpdateMutex where FObjectID = ?";
        this.params = new Object[]{strObjID};
        this.rowset = StatusDBUtil.executeQuery((String)this.sql, (Object[])this.params);
        try {
            if (this.rowset.next()) {
                retValue = this.getObjectUpdateLock(this.rowset);
            }
        }
        catch (SQLException e) {
            this.logger.error((Object)"\u8bfb\u53d6\u6570\u636e\u4e92\u65a5\u6570\u636e\u51fa\u9519\uff01");
        }
        return retValue;
    }

    private ObjectUpdateLock getObjectUpdateLock(IRowSet rowset) {
        ObjectUpdateLock retLock = null;
        try {
            String objID;
            String uuid;
            String userName = rowset.getString("FUserName");
            String sessionID = rowset.getString("FSessionID");
            java.sql.Date createTime = rowset.getDate("FCreateTime");
            retLock = new ObjectUpdateLock(userName, createTime, sessionID);
            retLock.setAIS(rowset.getString("FAIS"));
            retLock.setDcName(rowset.getString("FDCName"));
            retLock.setObjectDescription(rowset.getString("FDESCRIPTION"));
            retLock.setObjNumber(rowset.getString("FObjNumber"));
            String orgUnitID = rowset.getString("FOrgUnitID");
            if (orgUnitID != null && orgUnitID.length() > 0) {
                retLock.setOrgUnitID(BOSUuid.read((String)orgUnitID));
            }
            if ((uuid = rowset.getString("FUuid")) != null && uuid.length() > 0) {
                retLock.setUuid(Uuid.read((String)uuid));
            }
            if ((objID = rowset.getString("FObjectID")) != null && objID.length() > 0) {
                retLock.setObjectID(objID);
            }
        }
        catch (SQLException e) {
            retLock = null;
        }
        return retLock;
    }

    @Override
    public Map getMutexList() throws BOSException {
        HashMap<String, MutexParameter> retMap = new HashMap<String, MutexParameter>();
        this.sql = "select * from T_BAS_FunctionMutex";
        this.rowset = StatusDBUtil.executeQuery((String)this.sql);
        try {
            while (this.rowset.next()) {
                MutexParameter tmp = this.getMutexParameter(this.rowset);
                if (tmp == null) continue;
                retMap.put(this.rowset.getString("fid"), tmp);
            }
        }
        catch (SQLException e) {
            this.logger.error((Object)"\u8bfb\u53d6\u529f\u80fd\u4e92\u65a5\u5168\u4f53\u6570\u636e\u51fa\u9519!");
        }
        return retMap;
    }

    @Override
    public Map getMutexList(String mutexName, String dcName) throws BOSException {
        HashMap<String, MutexParameter> retMap = new HashMap<String, MutexParameter>();
        this.sql = "select * from T_BAS_FunctionMutex where FMutexName = ? and FDCName = ?";
        this.params = new Object[]{mutexName, dcName};
        this.rowset = StatusDBUtil.executeQuery((String)this.sql, (Object[])this.params);
        try {
            while (this.rowset.next()) {
                MutexParameter tmp = this.getMutexParameter(this.rowset);
                if (tmp == null) continue;
                retMap.put(this.rowset.getString("fid"), tmp);
            }
        }
        catch (SQLException e) {
            this.logger.error((Object)"\u8bfb\u53d6\u529f\u80fd\u4e92\u65a5\u5168\u4f53\u6570\u636e\u51fa\u9519!");
        }
        return retMap;
    }

    @Override
    public Map getObjIDForUpdateList() throws BOSException {
        HashMap<String, ObjectUpdateLock> retMap = new HashMap<String, ObjectUpdateLock>();
        this.sql = "select * from T_BAS_DataUpdateMutex";
        this.rowset = StatusDBUtil.executeQuery((String)this.sql);
        try {
            while (this.rowset.next()) {
                ObjectUpdateLock tmp = this.getObjectUpdateLock(this.rowset);
                if (tmp == null) continue;
                retMap.put(tmp.getObjectID() + tmp.getAIS(), tmp);
            }
        }
        catch (SQLException e) {
            this.logger.error((Object)"\u8bfb\u53d6\u529f\u80fd\u4e92\u65a5\u5168\u4f53\u6570\u636e\u51fa\u9519!");
        }
        return retMap;
    }

    @Override
    public Map getObjIDForUpdateList(String objID) throws BOSException {
        HashMap<String, ObjectUpdateLock> retMap = new HashMap<String, ObjectUpdateLock>();
        this.sql = "select * from T_BAS_DataUpdateMutex where FObjectID = ? and FAIS = ?";
        this.params = new Object[]{objID, this.ctx.getAIS()};
        this.rowset = StatusDBUtil.executeQuery((String)this.sql, (Object[])this.params);
        try {
            while (this.rowset.next()) {
                ObjectUpdateLock tmp = this.getObjectUpdateLock(this.rowset);
                if (tmp == null) continue;
                retMap.put(tmp.getObjectID() + tmp.getAIS(), tmp);
            }
        }
        catch (SQLException e) {
            this.logger.error((Object)"\u8bfb\u53d6\u529f\u80fd\u4e92\u65a5\u5168\u4f53\u6570\u636e\u51fa\u9519!");
        }
        return retMap;
    }

    @Override
    public boolean delObjIDForUpdate(String objID) {
        return false;
    }

    @Override
    public boolean delMutex(String id) throws BOSException {
        this.sql = "delete from T_BAS_FunctionMutex where FID = ?";
        this.params = new Object[]{id};
        StatusDBUtil.execute((String)this.sql, (Object[])this.params);
        return true;
    }

    @Override
    public boolean addNewFuctionMutex(MutexParameter param) throws BOSException {
        this.sql = "Insert Into T_BAS_FunctionMutex (FID,FActionName,FRequestID,FMutexName,FMutexLockType,FOrgUnitID,FUserID,FCreateTime,FDCName,FAIS,FDESCRIPTION,FSessionID,FNODE)Values(?,?,?,?,?,?,?,?,?,?,?,?,?)";
        String strFid = BOSUuid.create((String)"netCtrl").toString();
        String strReqId = param.getRequestId() != null ? param.getRequestId().toString() : "";
        String lockType = param.getMutexLockType() != null ? param.getMutexLockType().getValue() + "" : "0";
        String orgId = param.getOrgUnitID() != null ? param.getOrgUnitID().toString() : "";
        String userId = param.getUserID() != null ? param.getUserID().toString() : "";
        Timestamp createTime = new Timestamp(param.getCreateTime().getTime());
        String actionName = param.getActionName() != null ? param.getActionName() : "";
        String desc = param.getDescription() != null ? param.getDescription() : "";
        this.params = new Object[]{strFid, actionName, strReqId, param.getMutexName(), lockType, orgId, userId, createTime, this.ctx.getAIS(), this.ctx.getAIS(), desc, param.getSessionID(), this.getNodeStr()};
        StatusDBUtil.execute((String)this.sql, (Object[])this.params);
        return true;
    }

    @Override
    public boolean addNewObjUpdateMutex(ObjectUpdateLock objLock) throws BOSException {
        this.sql = "Insert Into T_BAS_DataUpdateMutex(FID,FObjectID,FUuid,FDCName,FAIS,FOrgUnitID,FUserName,FCreateTime,FDESCRIPTION,FObjNumber,FSessionID,FNODE)Values(?,?,?,?,?,?,?,?,?,?,?,?)";
        String strFid = BOSUuid.create((String)"netCtrl").toString();
        String objID = objLock.getObjectID() != null ? objLock.getObjectID() : "";
        String uuid = objLock.getUuid() != null ? objLock.getUuid().toString() : "";
        String orgID = objLock.getOrgUnitID() != null ? objLock.getOrgUnitID().toString() : "";
        String userName = objLock.getUserName() != null ? objLock.getUserName() : "";
        Timestamp createTime = new Timestamp(objLock.getCreatedTime().getTime());
        String desc = objLock.getObjectDescription() != null ? objLock.getObjectDescription() : "";
        String objNumber = objLock.getObjNumber() != null ? objLock.getObjNumber() : "";
        this.params = new Object[]{strFid, objID, uuid, this.ctx.getAIS(), this.ctx.getAIS(), orgID, userName, createTime, desc, objNumber, objLock.getContextID(), this.getNodeStr()};
        StatusDBUtil.execute((String)this.sql, (Object[])this.params);
        return false;
    }

    @Override
    public boolean isExistFunctionMutex(String key) throws BOSException {
        boolean retValue = false;
        this.sql = "select * from T_BAS_FunctionMutex where fmutexname = ?";
        this.params = new Object[]{key};
        this.rowset = StatusDBUtil.executeQuery((String)this.sql, (Object[])this.params);
        try {
            retValue = this.rowset.next();
        }
        catch (SQLException e) {
            this.logger.error((Object)("\u68c0\u67e5\u662f\u5426\u5b58\u5728\u529f\u80fd\u4e92\u65a5\u9501\uff1a" + key + " \u51fa\u9519\uff01"));
        }
        return retValue;
    }

    @Override
    public boolean isExistObjUpdateMutex(String key) throws BOSException {
        boolean retValue = false;
        this.sql = "select * from T_BAS_DataUpdateMutex where fobjid = ?";
        this.params = new Object[]{key};
        this.rowset = StatusDBUtil.executeQuery((String)this.sql, (Object[])this.params);
        try {
            retValue = this.rowset.next();
        }
        catch (SQLException e) {
            this.logger.error((Object)("\u68c0\u67e5\u662f\u5426\u5b58\u5728\u6570\u636e\u4e92\u65a5\u9501\uff1a" + key + " \u51fa\u9519\uff01"));
        }
        return retValue;
    }

    @Override
    public void releaseMutex(String requestID) throws BOSException {
        this.sql = "delete from T_BAS_FunctionMutex where FRequestID = ?";
        this.params = new Object[]{requestID};
        StatusDBUtil.execute((String)this.sql, (Object[])this.params);
    }

    @Override
    public void clearAllMutex() throws BOSException {
        this.sql = "delete from T_BAS_FunctionMutex";
        StatusDBUtil.execute((String)this.sql);
    }

    @Override
    public void clearAllObjId() throws BOSException {
        this.sql = "delete from T_BAS_DataUpdateMutex";
        StatusDBUtil.execute((String)this.sql);
    }

    @Override
    public void releaseObjIDForUpdate(String objID, String dcName) throws BOSException {
        this.sql = "delete from T_BAS_DataUpdateMutex where FObjectID = ? and FDCName = ?";
        this.params = new Object[]{objID, dcName};
        StatusDBUtil.execute((String)this.sql, (Object[])this.params);
    }

    @Override
    public void releaseAllFuncMutexAndObjLocks(String sessionID) throws BOSException {
        Timestamp delayTime = new Timestamp(new Date().getTime() - 36000000L);
        this.params = new Object[]{sessionID, delayTime};
        this.sql = "delete from T_BAS_DataUpdateMutex where FSessionID = ? or FCreateTime < ?";
        StatusDBUtil.execute((String)this.sql, (Object[])this.params);
        this.sql = "delete from T_BAS_FunctionMutex where FSessionID = ? or FCreateTime < ?";
        StatusDBUtil.execute((String)this.sql, (Object[])this.params);
    }

    @Override
    public void clearAllMutexByNode(String nodeStr) throws BOSException {
        if (StringUtils.isEmpty((String)nodeStr)) {
            this.logger.info((Object)"nodeStr is Null");
            return;
        }
        this.params = new Object[]{nodeStr};
        this.sql = "delete from T_BAS_DataUpdateMutex where FNode = ? ";
        StatusDBUtil.execute((String)this.sql, (Object[])this.params);
        this.sql = "delete from T_BAS_FunctionMutex where FNode = ? ";
        StatusDBUtil.execute((String)this.sql, (Object[])this.params);
    }

    @Override
    public void updateNodeInfoBySessionId(String nodeStr, String sessionId) throws BOSException {
        this.params = new Object[]{nodeStr, sessionId};
        this.sql = "update T_BAS_DataUpdateMutex set fnode = ? where FSessionID = ? ";
        StatusDBUtil.execute((String)this.sql, (Object[])this.params);
        this.params = new Object[]{nodeStr, sessionId};
        this.sql = "update T_BAS_FunctionMutex set fnode = ? where FSessionID = ? ";
        StatusDBUtil.execute((String)this.sql, (Object[])this.params);
    }

    private String getNodeStr() {
        IClusterService iC = ClusterServiceFactory.getLocalInstance();
        if (iC.isCluster()) {
            return iC.getServerName() + iC.getNodeName();
        }
        return "";
    }
}

