/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.security.provider.app;

import com.kingdee.bos.AbstractBOSObject;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.security.provider.IPKIConfig;
import com.kingdee.eas.base.security.provider.util.PKIConfigHelper;
import java.io.File;
import java.util.Properties;
import org.apache.log4j.Logger;

public class PKIConfig
extends AbstractBOSObject
implements IPKIConfig {
    private static Logger logger = Logger.getLogger(PKIConfig.class);
    public static final BOSObjectType BOSTYPE = BOSObjectType.create((String)"PKIC");
    private static Properties caConfigProperties = null;
    private static String clientProperties = null;
    private static String serverProperties = null;

    public PKIConfig() {
        this.registerInterface(IPKIConfig.class, this);
    }

    public PKIConfig(Context ctx) {
        super(ctx);
        this.registerInterface(IPKIConfig.class, this);
    }

    private Properties getCAConfigs() {
        if (caConfigProperties != null) {
            return caConfigProperties;
        }
        PKIConfigHelper helper = new PKIConfigHelper();
        String caConfigPath = System.getProperty("pki.deploy");
        if (caConfigPath == null || caConfigPath.trim().length() == 0) {
            caConfigPath = System.getProperty("EAS_INSTANCE_CONFIG_PATH");
        }
        if (caConfigPath == null || caConfigPath.trim().length() == 0) {
            logger.error((Object)"\u6ca1\u6709\u8bbe\u7f6eCA\u914d\u7f6e\u7684\u8def\u5f84\uff0c\u73af\u5883\u53d8\u91cf\u2018pki.deploy\u2019\u7684\u503c\u4e3a\u7a7a");
        }
        String ctrlFilePath = new StringBuffer().append(caConfigPath).append(File.separator).append(PKIConfigHelper.PKI_CONFIG_FILENAME).toString();
        caConfigProperties = helper.getCAConfigs(ctrlFilePath);
        return caConfigProperties;
    }

    @Override
    public String getConfigItem(String key) {
        if (key.equals("provider.server")) {
            if (serverProperties != null) {
                return serverProperties;
            }
            serverProperties = this.getProvider(key);
            return serverProperties;
        }
        if (clientProperties != null) {
            return clientProperties;
        }
        clientProperties = this.getProvider(key);
        return clientProperties;
    }

    public String getProvider(String key) {
        Properties config = this.getCAConfigs();
        String property = config.getProperty(key);
        if (property != null) {
            property = property.trim();
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("CA\u914d\u7f6e\u4fe1\u606f" + key + " : " + property));
        }
        return property;
    }

    @Override
    public boolean isCAEnabled() {
        Properties properties = this.getCAConfigs();
        String providerServer = properties.getProperty("provider.server");
        String providerClient = properties.getProperty("provider.client");
        return providerServer != null && providerClient != null;
    }

    @Override
    public boolean isItrusProvider() {
        Properties properties = this.getCAConfigs();
        String providerServer = properties.getProperty("provider.server");
        String providerClient = properties.getProperty("provider.client");
        if (providerServer == null || providerClient == null) {
            return false;
        }
        return providerServer.trim().endsWith(".ITrusServerProvider") && providerClient.trim().endsWith(".ItrusPKIClientProvider");
    }

    public BOSObjectType getType() {
        return BOSTYPE;
    }
}

