/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.security.provider.app;

import com.kingdee.bos.AbstractBOSObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.permission.service.helper.UsbKey4LoginInfo;
import com.kingdee.eas.base.security.SecurityAuthParamManagerFactory;
import com.kingdee.eas.base.security.provider.IPKIServerProvider;
import com.kingdee.eas.base.security.provider.app.PKIServerExtFactory;
import com.kingdee.eas.base.security.provider.app.PKISignInfoCache;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.io.UnsupportedEncodingException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import org.apache.log4j.Logger;

@Deprecated
public class PKIServerProvider
extends AbstractBOSObject
implements IPKIServerProvider {
    private static Logger logger = Logger.getLogger(PKIServerProvider.class);
    public static final BOSObjectType BOSTYPE = BOSObjectType.create((String)"PKIS");
    public static byte[] cert_temp = null;

    public PKIServerProvider() {
        this.registerInterface(IPKIServerProvider.class, this);
    }

    public PKIServerProvider(Context ctx) {
        super(ctx);
        this.registerInterface(IPKIServerProvider.class, this);
    }

    @Override
    public byte[] exportCertificate(byte[] userID) throws Exception {
        return PKIServerExtFactory.getExtProvide(this.getContext()).exportCertificate(userID);
    }

    @Override
    public byte[] MessageDecrypt(String pfxFilePath, String password, String keyAlias, byte[] encryptBuf) {
        return PKIServerExtFactory.getExtProvide(this.getContext()).MessageDecrypt(pfxFilePath, password, keyAlias, encryptBuf);
    }

    public byte[] MessageEncrypt(X509Certificate encryptCert, byte[] sourceMsg) {
        return PKIServerExtFactory.getExtProvide(this.getContext()).MessageEncrypt(encryptCert, sourceMsg);
    }

    @Override
    public int verify(byte[] plaintext, byte[] signature, Certificate cert) throws Exception {
        return PKIServerExtFactory.getExtProvide(this.getContext()).verify(plaintext, signature, cert);
    }

    private void debugInfo(String msgInfo) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)msgInfo);
        }
    }

    @Override
    public int verify(byte[] plaintext, byte[] signature, String userNumber) {
        boolean isGetCertFromRAServe = false;
        try {
            isGetCertFromRAServe = SecurityAuthParamManagerFactory.getLocalInstance(null).isGetCertFromRAServe();
        }
        catch (BOSException e1) {
            logger.error((Object)"verify signature error(get parameter isGetCertFromRAServe):", (Throwable)e1);
        }
        if (isGetCertFromRAServe) {
            String serialNumber = userNumber;
            try {
                UsbKey4LoginInfo usbKeyLoginInfo = (UsbKey4LoginInfo)this.getContext().get((Object)"USBKEY_LOGIN");
                if (usbKeyLoginInfo != null && usbKeyLoginInfo.getUsbKeyNo() != null) {
                    serialNumber = usbKeyLoginInfo.getUsbKeyNo();
                } else {
                    String sql = "select FSERIALNO from t_pm_usbkey where fid=(select FUSBKEYID from t_pm_usbkeyusermap where fuserid=(select FID from t_pm_user where FNumber=?))";
                    Object[] params = new Object[]{userNumber};
                    IRowSet rowSet = DbUtil.executeQuery((Context)this.getContext(), (String)sql, (Object[])params);
                    if (rowSet.next()) {
                        serialNumber = rowSet.getString(1);
                    }
                }
                return -1;
            }
            catch (Exception e) {
                logger.error((Object)"verify signature error(cert from RA Server):", (Throwable)e);
                return -1;
            }
        }
        byte[] cert = PKISignInfoCache.getInstance().getCert(this.getContext(), userNumber);
        if (cert != null) {
            try {
                Certificate newCert = PKIServerExtFactory.getExtProvide(this.getContext()).transCert(cert);
                return PKIServerExtFactory.getExtProvide(this.getContext()).verify(plaintext, signature, newCert);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return -1;
    }

    @Override
    public void cacheSignInfo(String userNumber, byte[] userCert) {
        if (userNumber != null && userCert != null) {
            if (cert_temp == null) {
                cert_temp = userCert;
                PKISignInfoCache.getInstance().putSignInfo(this.getContext(), userNumber, userCert);
                try {
                    logger.info((Object)("cacheSignInfo userCert=" + new String(userCert, "utf-8")));
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            } else if (!cert_temp.equals(userCert)) {
                cert_temp = userCert;
                PKISignInfoCache.getInstance().putSignInfo(this.getContext(), userNumber, userCert);
            }
        } else {
            logger.info((Object)("cacheSignInfo did nothing userNumber=" + userNumber + "::userCert=" + userCert));
        }
    }

    @Override
    public byte[] MessageEncrypt(Certificate encryptCert, byte[] sourceMsg) {
        return null;
    }

    @Override
    public int verifyCert(Certificate userCert) {
        return PKIServerExtFactory.getExtProvide(this.getContext()).verifyCert(userCert);
    }

    public BOSObjectType getType() {
        return BOSTYPE;
    }
}

