/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.ssccommon.xhstrategy;

import com.kingdee.bos.Context;
import com.kingdee.eas.base.ssccommon.utils.httputils.HttpPostUtil;
import com.kingdee.eas.base.ssccommon.xhstrategy.IParamBaseInfo;
import com.kingdee.eas.base.ssccommon.xhstrategy.Strategy;
import com.kingdee.eas.base.ssccommon.xhstrategy.bean.BaseParam;
import com.kingdee.eas.base.ssccommon.xhstrategy.bean.JWTParam;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.util.HashMap;
import net.sf.json.JSONObject;
import org.apache.log4j.Logger;

public class StrategyByJWT
extends Strategy {
    private Logger logger = Logger.getLogger(StrategyByJWT.class);
    public Context ctx = null;
    public JWTParam postParm;

    public StrategyByJWT(Context ctx, IParamBaseInfo postParm) throws EASBizException {
        super(ctx, postParm);
        if (null == postParm) {
            throw new EASBizException(new NumericExceptionSubItem("", "\u8bf7\u51fa\u521d\u59cb\u5316JWTParam\u53c2\u6570\uff01"));
        }
        this.ctx = ctx;
        this.postParm = (JWTParam)postParm;
    }

    @Override
    public BaseParam login() throws EASBizException {
        JSONObject map = new JSONObject();
        map.put((Object)"appSecret", (Object)this.postParm.getAppSecret());
        map.put((Object)"appId", (Object)this.postParm.getAppId());
        map.put((Object)"user", (Object)this.postParm.getUser());
        map.put((Object)"usertype", (Object)this.postParm.getUsertype());
        map.put((Object)"tenantid", (Object)this.postParm.getTenantid());
        map.put((Object)"accountId", (Object)this.postParm.getAccountId());
        map.put((Object)"keytype", (Object)this.postParm.getKeytype());
        String result = null;
        try {
            result = HttpPostUtil.postInterface(this.postParm.getAccessTokenUrl(), map.toString(), true);
        }
        catch (Exception e) {
            throw new EASBizException(new NumericExceptionSubItem("00", "\u8bf7\u6c42\u7cfb\u7edf\u83b7\u53d6accessToken\u5f02\u5e38:{0}"), (Throwable)e, new Object[]{e.getMessage() == null ? "\u5f02\u5e38\u4fe1\u606f\u4e3a\u7a7a" : e.getMessage()});
        }
        JSONObject resultJson = JSONObject.fromObject((Object)result);
        String errorCode = resultJson.get("errorCode") + "";
        String state = resultJson.get("state") + "";
        if ("401".equals(errorCode) || !"success".equals(state)) {
            this.postParm.setSuccess(false);
            this.postParm.setMsg("StratyByappTokenPostError");
            this.logger.error((Object)("StratyByappToken initAccessToken error:" + resultJson));
            throw new EASBizException(new NumericExceptionSubItem("00", "\u8bf7\u6c42\u7cfb\u7edf\u83b7\u53d6accessToken\u5f02\u5e38:{0}"), new Object[]{resultJson});
        }
        Object obj = resultJson.get("data");
        String accessToken = ((JSONObject)obj).get("access_token").toString();
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("jwt", accessToken);
        header.put("appId", this.postParm.getAppId());
        if (!StringUtils.isEmpty((String)this.postParm.getAccountId())) {
            header.put("accountId", this.postParm.getAccountId());
        }
        this.postParm.setHeader(header);
        this.postParm.setSuccess(true);
        return this.postParm;
    }
}

