/*
 * Decompiled with CFR 0.152.
 */
package com.tool.classfile;

public class ByteCodeWriter {
    private byte[] bytes;
    private int current_pc = 0;

    public ByteCodeWriter() {
        this(512);
    }

    public ByteCodeWriter(int initSize) {
        this.bytes = new byte[initSize];
    }

    private void growsize(int size) {
        if (this.bytes.length <= size) {
            byte[] temp = new byte[size * 3 / 2];
            System.arraycopy(this.bytes, 0, temp, 0, this.current_pc);
            this.bytes = temp;
        }
    }

    public int current_pc() {
        return this.current_pc;
    }

    public void writeu1(int v) {
        this.growsize(this.current_pc + 1);
        this.bytes[this.current_pc++] = (byte)(v & 0xFF);
    }

    public void writeu2(int v) {
        this.writeu1((v & 0xFF00) >> 8);
        this.writeu1(v);
    }

    public void writeu4(int v) {
        this.writeu1((v & 0xFF000000) >> 24);
        this.writeu1((v & 0xFF0000) >> 16);
        this.writeu1((v & 0xFF00) >> 8);
        this.writeu1(v);
    }

    public void writeInt(int v) {
        this.writeu4(v);
    }

    public void writeLong(long v) {
        this.writeu4((int)((v & 0xFFFFFFFF00000000L) >> 32));
        this.writeu4((int)(v & 0xFFFFFFFFL));
    }

    public void writeFloat(float v) {
        this.writeInt(Float.floatToIntBits(v));
    }

    public void writeDouble(double v) {
        this.writeLong(Double.doubleToLongBits(v));
    }

    public void write(byte[] b) {
        this.write(b, 0, b.length);
    }

    public void write(byte[] b, int off, int len) {
        this.growsize(this.current_pc + len);
        System.arraycopy(b, off, this.bytes, this.current_pc, len);
        this.current_pc += len;
    }

    public byte[] toByteArray() {
        byte[] b = new byte[this.current_pc];
        System.arraycopy(this.bytes, 0, b, 0, this.current_pc);
        return b;
    }

    public void write(ByteCodeWriter out) {
        this.write(out.bytes, 0, out.current_pc());
    }
}

