/*
 * Decompiled with CFR 0.152.
 */
package com.tool.classfile.binary;

import com.tool.classfile.ByteCodeReader;
import com.tool.classfile.ByteCodeWriter;
import com.tool.classfile.ClassDefinition;
import com.tool.classfile.Const;
import com.tool.classfile.ConstantPool;
import com.tool.classfile.Context;
import com.tool.classfile.ExtraAttribute;
import com.tool.classfile.FieldDefinition;
import com.tool.classfile.InnerClass;
import com.tool.classfile.MethodDefinition;
import com.tool.classfile.binary.Attribute;
import com.tool.classfile.binary.Attributes;
import com.tool.classfile.binary.CodeAttribute;
import com.tool.classfile.binary.ConstantAttribute;
import com.tool.classfile.pcodes.CodesReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;

public class ClassFile {
    public static final ClassDefinition read(String filename) throws IOException {
        return ClassFile.read(ClassFile.readStreamData(new FileInputStream(filename)));
    }

    public static final ClassDefinition read(File classFile) throws IOException {
        return ClassFile.read(ClassFile.readStreamData(new FileInputStream(classFile)));
    }

    private static byte[] readStreamData(InputStream in) throws IOException {
        int r;
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        byte[] buf = new byte[4096];
        while ((r = in.read(buf)) > 0) {
            bout.write(buf, 0, r);
        }
        in.close();
        return bout.toByteArray();
    }

    public static final ClassDefinition read(byte[] data) {
        Attributes attrs;
        ByteCodeReader in = new ByteCodeReader(data);
        int magic = in.readu4();
        int minor_version = in.readu2();
        int major_version = in.readu2();
        ConstantPool pool = new ConstantPool(in);
        int access_flags = in.readu2() & 0xFFFFFFDF;
        String this_class = pool.getClass(in.readu2());
        String super_class = pool.getClass(in.readu2());
        int len = in.readu2();
        String[] interfaces = new String[len];
        int i = 0;
        while (i < interfaces.length) {
            interfaces[i] = pool.getClass(in.readu2());
            ++i;
        }
        ClassDefinition def = new ClassDefinition(this_class, super_class, access_flags, interfaces);
        def.magic = magic;
        def.major_version = major_version;
        def.minor_version = minor_version;
        def.pool = pool;
        len = in.readu2();
        int i2 = 0;
        while (i2 < len) {
            access_flags = in.readu2();
            String name = pool.getString(in.readu2());
            String type = pool.getString(in.readu2());
            FieldDefinition field = def.declareField(name, type, access_flags);
            attrs = new Attributes(in);
            int j = 0;
            while (j < attrs.count()) {
                Attribute attr = attrs.getAttribute(j);
                name = pool.getString(attr.name_index);
                if (name.equals("Deprecated")) {
                    field.deprecated = true;
                } else if (name.equals("Synthetic")) {
                    field.synthetic = true;
                } else if (name.equals("ConstantValue")) {
                    field.initValue = (Const)pool.get(((ConstantAttribute)attr.createSpecial((String)name)).index);
                } else {
                    field.extra_attributes.addElement(new ExtraAttribute(name, attr.info));
                }
                ++j;
            }
            ++i2;
        }
        len = in.readu2();
        int i3 = 0;
        while (i3 < len) {
            String[] exceptions;
            access_flags = in.readu2();
            String name = pool.getString(in.readu2());
            String descriptor = pool.getString(in.readu2());
            attrs = new Attributes(in);
            Attribute ex = attrs.lookup(pool, "Exceptions");
            if (ex == null) {
                exceptions = new String[]{};
            } else {
                ByteCodeReader in1 = new ByteCodeReader(ex.info);
                int ecount = in1.readu2();
                exceptions = new String[ecount];
                int j = 0;
                while (j < exceptions.length) {
                    exceptions[j] = pool.getClass(in1.readu2());
                    ++j;
                }
            }
            MethodDefinition method = def.declareMethod(name, descriptor, access_flags, exceptions);
            int j = 0;
            while (j < attrs.count()) {
                Attribute attr = attrs.getAttribute(j);
                name = pool.getString(attr.name_index);
                if (name.equals("Deprecated")) {
                    method.deprecated = true;
                } else if (name.equals("Synthetic")) {
                    method.synthetic = true;
                } else if (name.equals("Code")) {
                    method.setCodes(new CodesReader(method, (CodeAttribute)attr.createSpecial("Code")));
                } else if (!name.equals("Exceptions")) {
                    method.extra_attributes.addElement(new ExtraAttribute(name, attr.info));
                }
                ++j;
            }
            ++i3;
        }
        Attributes attrs2 = new Attributes(in);
        int i4 = 0;
        while (i4 < attrs2.count()) {
            Attribute attr = attrs2.getAttribute(i4);
            String name = pool.getString(attr.name_index);
            if (name.equals("Deprecated")) {
                def.deprecated = true;
            } else if (name.equals("SourceFile")) {
                def.sourceFile = pool.getString(((ConstantAttribute)attr.createSpecial((String)name)).index);
            } else if (name.equals("SourceDir")) {
                def.sourceDir = pool.getString(((ConstantAttribute)attr.createSpecial((String)name)).index);
            } else if (name.equals("InnerClasses")) {
                ClassFile.readInnerClasses(def, attr.info);
            } else {
                def.extra_attributes.addElement(new ExtraAttribute(name, attr.info));
            }
            ++i4;
        }
        return def;
    }

    private static void readInnerClasses(ClassDefinition def, byte[] info) {
        ConstantPool pool = def.pool;
        ByteCodeReader in = new ByteCodeReader(info);
        int len = in.readu2();
        int i = 0;
        while (i < len) {
            InnerClass cls = new InnerClass();
            cls.inner_class = pool.getClass(in.readu2());
            cls.outer_class = pool.getClass(in.readu2());
            cls.inner_name = pool.getString(in.readu2());
            cls.access_flags = in.readu2();
            def.inner_classes.addElement(cls);
            ++i;
        }
    }

    public static final byte[] toByteArray(ClassDefinition def) {
        ByteCodeWriter out = new ByteCodeWriter();
        ClassFile.write(def, out);
        return out.toByteArray();
    }

    public static final void write(ClassDefinition def, ByteCodeWriter out) {
        boolean debug = Context.isDebug();
        if (debug) {
            System.out.println(def.getDeclareString());
        }
        ConstantPool pool = def.pool;
        Context.setConstantPool(pool);
        out.writeu4(def.magic);
        out.writeu2(def.minor_version);
        out.writeu2(def.major_version);
        ByteCodeWriter out1 = new ByteCodeWriter();
        out1.writeu2(def.access_flags | 0x20);
        out1.writeu2(pool.getClass(def.className));
        out1.writeu2(pool.getClass(def.superClassName));
        out1.writeu2(def.interfaces.length);
        int i = 0;
        while (i < def.interfaces.length) {
            out1.writeu2(pool.getClass(def.interfaces[i]));
            ++i;
        }
        FieldDefinition[] fields = def.getFields();
        out1.writeu2(fields.length);
        int i2 = 0;
        while (i2 < fields.length) {
            if (debug) {
                System.out.println(fields[i2].getDeclareString());
            }
            ClassFile.writeField(fields[i2], out1);
            ++i2;
        }
        MethodDefinition[] methods = def.getMethods();
        out1.writeu2(methods.length);
        int i3 = 0;
        while (i3 < methods.length) {
            if (debug) {
                System.out.println(methods[i3].getDeclareString());
            }
            ClassFile.writeMethod(methods[i3], out1);
            ++i3;
        }
        int attr_count = 0;
        ByteCodeWriter out2 = new ByteCodeWriter();
        if (def.sourceDir != null) {
            attr_count += ClassFile.writeConstantAttribute(pool, "SourceDir", def.sourceDir, out2);
        }
        if (def.sourceFile != null) {
            attr_count += ClassFile.writeConstantAttribute(pool, "SourceFile", def.sourceFile, out2);
        }
        if (def.deprecated) {
            attr_count += ClassFile.writeBooleanAttribute(pool, "Deprecated", out2);
        }
        if (def.inner_classes.size() > 0) {
            ++attr_count;
            out2.writeu2(pool.getString("InnerClasses"));
            int inner_class_count = def.inner_classes.size();
            out2.writeu4(2 + 8 * inner_class_count);
            out2.writeu2(inner_class_count);
            int i4 = 0;
            while (i4 < inner_class_count) {
                InnerClass cls = (InnerClass)def.inner_classes.elementAt(i4);
                out2.writeu2(pool.getClass(cls.inner_class));
                out2.writeu2(pool.getClass(cls.outer_class));
                out2.writeu2(pool.getString(cls.inner_name));
                out2.writeu2(cls.access_flags);
                ++i4;
            }
        }
        out1.writeu2(attr_count += ClassFile.writeExtraAttributes(pool, def.extra_attributes, out2));
        out1.write(out2);
        pool.write(out);
        out.write(out1);
    }

    private static int writeExtraAttributes(ConstantPool pool, Vector eas, ByteCodeWriter out) {
        int i = 0;
        while (i < eas.size()) {
            ExtraAttribute attr = (ExtraAttribute)eas.elementAt(i);
            out.writeu2(pool.getString(attr.name));
            byte[] info = attr.getInfo();
            out.writeu4(info.length);
            if (info.length > 0) {
                out.write(info);
            }
            ++i;
        }
        return eas.size();
    }

    private static int writeBooleanAttribute(ConstantPool pool, String name, ByteCodeWriter out) {
        out.writeu2(pool.getString(name));
        out.writeu4(0);
        return 1;
    }

    private static int writeConstantAttribute(ConstantPool pool, String name, String value, ByteCodeWriter out) {
        out.writeu2(pool.getString(name));
        out.writeu4(2);
        out.writeu2(pool.getString(value));
        return 1;
    }

    private static int writeConstantAttribute(ConstantPool pool, String name, Const value, ByteCodeWriter out) {
        out.writeu2(pool.getString(name));
        out.writeu4(2);
        out.writeu2(pool.get(value));
        return 1;
    }

    private static void writeField(FieldDefinition def, ByteCodeWriter out) {
        ConstantPool pool = def.parent.pool;
        out.writeu2(def.access_flags);
        out.writeu2(pool.getString(def.name));
        out.writeu2(pool.getString(def.type));
        ByteCodeWriter out1 = new ByteCodeWriter();
        int attr_count = 0;
        if (def.deprecated) {
            attr_count += ClassFile.writeBooleanAttribute(pool, "Deprecated", out1);
        }
        if (def.synthetic) {
            attr_count += ClassFile.writeBooleanAttribute(pool, "Synthetic", out1);
        }
        if (def.initValue != null && def.initValue.value != null) {
            attr_count += ClassFile.writeConstantAttribute(pool, "ConstantValue", def.initValue, out1);
        }
        out.writeu2(attr_count += ClassFile.writeExtraAttributes(pool, def.extra_attributes, out1));
        out.write(out1);
    }

    private static void writeMethod(MethodDefinition def, ByteCodeWriter out) {
        ConstantPool pool = def.parent.pool;
        out.writeu2(def.access_flags);
        out.writeu2(pool.getString(def.name));
        out.writeu2(pool.getString(def.descriptor));
        ByteCodeWriter out1 = new ByteCodeWriter();
        int attr_count = 0;
        if (def.exceptions != null && def.exceptions.length > 0) {
            ++attr_count;
            out1.writeu2(pool.getString("Exceptions"));
            out1.writeu4(2 + def.exceptions.length * 2);
            out1.writeu2(def.exceptions.length);
            int i = 0;
            while (i < def.exceptions.length) {
                out1.writeu2(pool.getClass(def.exceptions[i]));
                ++i;
            }
        }
        if (def.deprecated) {
            attr_count += ClassFile.writeBooleanAttribute(pool, "Deprecated", out1);
        }
        if (def.synthetic) {
            attr_count += ClassFile.writeBooleanAttribute(pool, "Synthetic", out1);
        }
        if (def.getCodes() != null) {
            ++attr_count;
            byte[] info = def.getCodes().buildInfo(pool);
            out1.writeu2(pool.getString("Code"));
            out1.writeu4(info.length);
            out1.write(info);
        }
        out.writeu2(attr_count += ClassFile.writeExtraAttributes(pool, def.extra_attributes, out1));
        out.write(out1);
    }
}

