/*
 * Decompiled with CFR 0.152.
 */
package com.tool.simplecode;

import com.tool.classfile.CodeException;
import com.tool.classfile.MethodRef;
import com.tool.classfile.sc;
import com.tool.simplecode.BuildEnv;
import com.tool.simplecode.New;
import com.tool.simplecode.Unit;
import com.tool.simplecode.Value;
import java.io.IOException;
import java.util.Vector;

public class StringMaker
extends Unit {
    Vector items = new Vector();
    private static final String C_STRINGBUFFER = "java/lang/StringBuffer";
    private static final String STRINGBUFFER = "Ljava/lang/StringBuffer;";
    private static final String APPEND = "append";
    private static final String CHAR_ARRAY = "[C";
    private static final MethodRef APPEND_BOOLEAN = StringMaker.append_method("Z");
    private static final MethodRef APPEND_CHAR = StringMaker.append_method("C");
    private static final MethodRef APPEND_CHAR_ARRAY = StringMaker.append_method("[C");
    private static final MethodRef APPEND_DOUBLE = StringMaker.append_method("D");
    private static final MethodRef APPEND_FLOAT = StringMaker.append_method("F");
    private static final MethodRef APPEND_INT = StringMaker.append_method("I");
    private static final MethodRef APPEND_LONG = StringMaker.append_method("J");
    private static final MethodRef APPEND_STRING = StringMaker.append_method("Ljava/lang/String;");
    private static final MethodRef APPEND_OBJECT = StringMaker.append_method("Ljava/lang/Object;");
    private static final MethodRef TOSTRING = new MethodRef("java/lang/Object", "toString", "()Ljava/lang/String;");

    public StringMaker() {
        super(1);
    }

    public StringMaker(String initValue) {
        this();
        this.append(initValue);
    }

    public StringMaker(Unit initValue) {
        this();
        this.append(initValue);
    }

    public StringMaker append(Unit item) {
        this.items.addElement(Unit.toUnit(item));
        return this;
    }

    public StringMaker append(String s) {
        this.append(new Value(s));
        return this;
    }

    public StringMaker append(char c) {
        this.append(new Value(c));
        return this;
    }

    public StringMaker append(int v) {
        this.append(new Value(v));
        return this;
    }

    private static final MethodRef append_method(String type) {
        return new MethodRef(STRINGBUFFER, APPEND, "(" + type + ")" + STRINGBUFFER);
    }

    protected String genCodes(BuildEnv env, String requiredType) throws IOException {
        new New(C_STRINGBUFFER).genCodes(env, "Ljava/lang/Object;");
        int i = 0;
        while (i < this.items.size()) {
            Unit item = (Unit)this.items.elementAt(i);
            String type = item.buildCodes(env, "VALUE");
            if (sc.isBoolean(type)) {
                env.current_block._invokevirtual(APPEND_BOOLEAN);
            } else if (sc.isChar(type)) {
                env.current_block._invokevirtual(APPEND_CHAR);
            } else if (type.equals(CHAR_ARRAY)) {
                env.current_block._invokevirtual(APPEND_CHAR_ARRAY);
            } else if (sc.isDouble(type)) {
                env.current_block._invokevirtual(APPEND_DOUBLE);
            } else if (sc.isFloat(type)) {
                env.current_block._invokevirtual(APPEND_FLOAT);
            } else if (sc.isLong(type)) {
                env.current_block._invokevirtual(APPEND_LONG);
            } else if (type.equals("Ljava/lang/String;")) {
                env.current_block._invokevirtual(APPEND_STRING);
            } else if (sc.isByte(type) || sc.isShort(type) || sc.isInteger(type)) {
                env.current_block._convert(type, "I");
                env.current_block._invokevirtual(APPEND_INT);
            } else if (sc.isObject(type)) {
                env.current_block._invokevirtual(APPEND_OBJECT);
            } else {
                CodeException.assertThat(false);
            }
            ++i;
        }
        env.current_block._invokevirtual(TOSTRING);
        return "Ljava/lang/String;";
    }

    protected void genSource(BuildEnv env) throws IOException {
        int i = 0;
        while (i < this.items.size()) {
            Unit item = (Unit)this.items.elementAt(i);
            if (i > 0) {
                env.out.writeString(" + ");
            }
            item.buildSource(env, 4);
            ++i;
        }
    }
}

