/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.autoupdater;

import com.kingdee.eas.cp.autoupdater.DownloadTraceInfo;
import com.kingdee.eas.cp.autoupdater.EasComponents;
import com.kingdee.eas.cp.autoupdater.FileVersion;
import com.kingdee.eas.cp.autoupdater.util.FileLists;
import com.kingdee.eas.cp.autoupdater.util.MD5Util;
import com.kingdee.util.StringUtils;
import com.twmacinta.util.MD5;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import org.apache.log4j.Logger;

public class CreateJnlpResourcesBean {
    private static final Logger logger = Logger.getLogger(CreateJnlpResourcesBean.class);
    private static final String JAR_TAG = "jar";
    private static final String JAR_EXT_NAME = ".jar";
    private static final String NATIVELIB_TAG = "nativelib";
    private static boolean modified = false;
    private static final String FIRSTDOWNRES_FILENAME = "FirstDownRes.properties";

    public static boolean isModified() {
        return modified;
    }

    public static void setModified(boolean bmodified) {
        modified = bmodified;
    }

    public static String getJnlpResources(String configDir, String pathPrefix, String extName, String pathSuffixStr, String seperator, String itemsExcluded) {
        if (pathSuffixStr == null || "".equals(pathSuffixStr)) {
            System.out.println("[EAS web client] jnlp resx path is null.");
            return null;
        }
        if (pathPrefix == null || "".equals(pathPrefix)) {
            pathPrefix = "";
        }
        if (seperator == null || "".equals(seperator)) {
            seperator = ",";
        }
        pathPrefix = pathPrefix.replace('\\', '/');
        pathPrefix = pathPrefix.replaceAll("//", "/");
        pathSuffixStr = pathSuffixStr.replace('\\', '/');
        pathSuffixStr = pathSuffixStr.replaceAll("//", "/");
        String pathStr = pathPrefix + pathSuffixStr;
        pathStr = pathStr.replaceAll(seperator, seperator + pathPrefix);
        String[] resxPaths = pathStr.split(seperator);
        if (itemsExcluded == null) {
            itemsExcluded = "";
        }
        String[] items = itemsExcluded.split(seperator);
        return CreateJnlpResourcesBean.getJnlpResources(configDir, pathPrefix, extName, resxPaths, items);
    }

    public static String getJnlpResources(String configDir, String pathPrefix, String extName, String[] pathArray, String[] itemsExcludedArray) {
        if (pathArray == null || pathArray.length == 0) {
            System.out.println("[EAS web client] jnlp resx path array is empty.");
            return null;
        }
        List<String> paths = Arrays.asList(pathArray);
        return CreateJnlpResourcesBean.getJnlpResources(configDir, pathPrefix, extName, paths, itemsExcludedArray);
    }

    public static String getJnlpResources(String configDir, String pathPrefix, String extName, Collection paths, String[] itemExcluded) {
        if (paths == null || paths.isEmpty()) {
            System.out.println("[EAS web client] jnlp resx path collection is empty.");
            return null;
        }
        if (pathPrefix == null) {
            pathPrefix = "";
        }
        StringBuffer fileSB = new StringBuffer("");
        Collection allResx = CreateJnlpResourcesBean.getResources(extName, paths);
        if ((allResx = CreateJnlpResourcesBean.getFitResources(allResx, itemExcluded)) == null) {
            return "";
        }
        Iterator fIterator = allResx.iterator();
        Properties md5 = CreateJnlpResourcesBean.getTheRightMD5(configDir);
        EasComponents easComponents = null;
        try {
            easComponents = EasComponents.getInstance();
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        long startTime = System.currentTimeMillis();
        while (fIterator.hasNext()) {
            String fileName = (String)fIterator.next();
            if (fileName == null) continue;
            String tagType = CreateJnlpResourcesBean.getTagType(fileName);
            long lastModified = CreateJnlpResourcesBean.getFileLastModified(fileName);
            String fileUrl = fileName.replaceAll(pathPrefix, "");
            try {
                FileVersion version = CreateJnlpResourcesBean.getFileVersion(md5, fileName, lastModified, fileUrl, easComponents);
                CreateJnlpResourcesBean.createJnlpRecord(fileSB, version, tagType, lastModified, fileUrl);
            }
            catch (Exception e) {
                System.out.println("make md5 or get md5 error.");
                e.printStackTrace();
            }
        }
        long endTime = System.currentTimeMillis();
        logger.info((Object)("create jnlp record cost time:" + (endTime - startTime) / 1000L + "s"));
        logger.info((Object)("\u5237\u65b0jnlp \u8017\u65f6:" + (endTime - startTime) / 1000L + "\u79d2"));
        if (modified) {
            MD5Util.storeMD5(configDir);
        }
        return fileSB.toString();
    }

    private static FileVersion getFileVersion(Properties md5, String fileName, long lastModified, String fileUrl, EasComponents easComponents) throws Exception {
        long md5lastmodified = MD5Util.getLastModified(md5, fileUrl);
        if (fileName.indexOf("metasindex.jar") >= 0) {
            System.out.println("metasindex lastModified get From File:" + lastModified + " get From properties:" + md5lastmodified);
            return CreateJnlpResourcesBean.generatorMD5(md5, fileName, lastModified, fileUrl);
        }
        if (lastModified != md5lastmodified) {
            return CreateJnlpResourcesBean.generatorMD5(md5, fileName, lastModified, fileUrl);
        }
        return CreateJnlpResourcesBean.getExistVersionFromMD5Properties(md5, fileName, lastModified, fileUrl, easComponents);
    }

    private static FileVersion getExistVersionFromMD5Properties(Properties md5, String fileName, long lastModified, String fileUrl, EasComponents easComponents) throws Exception {
        String md5VersionAndMd5VersionNew = MD5Util.getMD5Version(md5, fileUrl);
        if (md5VersionAndMd5VersionNew == null) {
            return CreateJnlpResourcesBean.generatorMD5(md5, fileName, lastModified, fileUrl);
        }
        if (md5VersionAndMd5VersionNew.indexOf(",") < 0) {
            return CreateJnlpResourcesBean.generatorMD5(md5, fileName, lastModified, fileUrl);
        }
        String md5Version = md5VersionAndMd5VersionNew.substring(0, md5VersionAndMd5VersionNew.indexOf(","));
        String md5VersionNew = md5VersionAndMd5VersionNew.substring(md5VersionAndMd5VersionNew.indexOf(",") + 1);
        FileVersion version = new FileVersion(fileName, md5Version, md5VersionNew);
        if (easComponents.validate(fileUrl, md5Version)) {
            return version;
        }
        return CreateJnlpResourcesBean.generatorMD5(md5, fileName, lastModified, fileUrl);
    }

    private static FileVersion generatorMD5(Properties md5, String fileName, long lastModified, String fileUrl) {
        CreateJnlpResourcesBean.setModified(true);
        String md5Version = CreateJnlpResourcesBean.reviseMd5(new File(fileName));
        String md5VersionNew = CreateJnlpResourcesBean.reviseMd5New(new File(fileName));
        FileVersion version = new FileVersion(fileName, md5Version, md5VersionNew);
        if (null == md5) {
            System.out.println("md5 is null.");
        } else {
            md5.setProperty(fileUrl, "" + lastModified + "," + md5Version + "," + md5VersionNew);
        }
        logger.info((Object)("\u9700\u91cd\u65b0\u8ba1\u7b97\u6587\u4ef6\u7684MD5\u503c:" + fileName + "=" + md5Version));
        return version;
    }

    private static void createJnlpRecord(StringBuffer fileSB, FileVersion version, String tagType, long lastModified, String fileUrl) {
        String md5Version = version.getMd5Version();
        String md5VersionNew = version.getMd5VersionNew();
        fileSB.append("\t\t<" + tagType + " href='");
        fileSB.append(fileUrl);
        fileSB.append("'");
        fileSB.append(" lastModified=\"" + lastModified + "\" ");
        fileSB.append(" md5Version=\"" + md5Version + "\" md5VersionNew=\"" + md5VersionNew + "\"");
        fileSB.append("/>\n");
    }

    private static long getFileLastModified(String fileName) {
        File fl = new File(fileName);
        long lastModified = 0L;
        if (fl.exists()) {
            lastModified = fl.lastModified();
        }
        return lastModified;
    }

    private static String getTagType(String fileName) {
        String tagType = fileName.endsWith(JAR_EXT_NAME) ? JAR_TAG : NATIVELIB_TAG;
        return tagType;
    }

    private static Properties getTheRightMD5(String configDir) {
        Properties md5 = MD5Util.getMD5(configDir);
        return md5;
    }

    private static String reviseMd5(File fileName) {
        String md5 = "";
        try {
            md5 = MD5.asHex(MD5.getHash(fileName));
        }
        catch (IOException e1) {
            System.out.println("make md5 or get md5 error.");
            md5 = "";
            e1.printStackTrace();
        }
        for (int num = 0; md5 != null && md5.length() < 32 && num < 3; ++num) {
            try {
                md5 = MD5.asHex(MD5.getHash(fileName));
                continue;
            }
            catch (IOException e) {
                System.out.println("make md5 or get md5 error.");
                md5 = "";
                e.printStackTrace();
            }
        }
        if (md5 != null && md5.length() < 32) {
            System.out.println("make [" + fileName + "] md5 error,the md5 length is less than 32:" + md5);
        }
        return md5;
    }

    private static String reviseMd5New(File fileName) {
        String md5 = "";
        try {
            md5 = MD5.getMD5(fileName);
        }
        catch (IOException e1) {
            System.out.println("make md5 or get md5 error.");
            md5 = "";
            e1.printStackTrace();
        }
        for (int num = 0; md5 != null && md5.length() < 32 && num < 3; ++num) {
            try {
                md5 = MD5.getMD5(fileName);
                continue;
            }
            catch (IOException e) {
                System.out.println("make md5 or get md5 error.");
                md5 = "";
                e.printStackTrace();
            }
        }
        if (md5 != null && md5.length() < 32) {
            System.out.println("make [" + fileName + "] md5 error,the md5 length is less than 32:" + md5);
        }
        return md5;
    }

    public static Collection getResources(String pathPrefix, String extName, String pathSuffixStr, String seperator) {
        if (pathSuffixStr == null || "".equals(pathSuffixStr)) {
            System.out.println("[EAS web client] jnlp resx path is null.");
            return null;
        }
        if (pathPrefix == null) {
            pathPrefix = "";
        }
        if (seperator == null || "".equals(seperator)) {
            seperator = ",";
        }
        pathPrefix = pathPrefix.replace('\\', '/');
        pathPrefix = pathPrefix.replaceAll("//", "/");
        pathSuffixStr = pathSuffixStr.replace('\\', '/');
        pathSuffixStr = pathSuffixStr.replaceAll("//", "/");
        String pathStr = pathPrefix + pathSuffixStr;
        pathStr = pathStr.replaceAll(seperator, seperator + pathPrefix);
        String[] resxPaths = pathStr.split(seperator);
        List<String> paths = Arrays.asList(resxPaths);
        return CreateJnlpResourcesBean.getResources(extName, paths);
    }

    public static Collection getFitResources(Collection resxs, String[] itemsExcluded) {
        Collection result = resxs;
        Object[] resxsStrs = result.toArray();
        String key = "";
        for (int i = 0; i < resxsStrs.length; ++i) {
            key = (String)resxsStrs[i];
            for (int j = 0; j < itemsExcluded.length; ++j) {
                if ((key == null || !key.endsWith(itemsExcluded[j]) || "".equals(itemsExcluded[j])) && !key.startsWith(itemsExcluded[j])) continue;
                result.remove(key);
            }
        }
        return result;
    }

    public static Collection getResources(String extName, Collection paths) {
        assert (paths != null);
        Iterator pathIterator = paths.iterator();
        String path = "";
        ArrayList result = new ArrayList();
        while (pathIterator.hasNext()) {
            path = (String)pathIterator.next();
            try {
                FileLists.getFileLists(path, extName, result);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public static String createJnlpString(HashMap args) {
        String configDir = (String)args.get("configDir");
        String pathPrefix = (String)args.get("pathPrefix");
        String extName = (String)args.get("extName");
        String pathSuffixStr = (String)args.get("pathSuffixStr");
        pathPrefix = pathPrefix.replace('\\', '/');
        pathPrefix = pathPrefix.replaceAll("//", "/");
        pathSuffixStr = pathSuffixStr.replace('\\', '/');
        pathSuffixStr = pathSuffixStr.replaceAll("//", "/");
        String seperator = (String)args.get("seperator");
        String easJnlpFileName = (String)args.get("easJnlpFileName");
        String easJnlpCodeBase = (String)args.get("easJnlpCodeBase");
        String itemsExcluded = (String)args.get("itemExcluded");
        String str = CreateJnlpResourcesBean.getJnlpResources(configDir, pathPrefix, extName, pathSuffixStr, seperator, itemsExcluded);
        logger.info((Object)("\u751f\u6210\u7684\u6587\u4ef6\u5217\u8868\u5927\u5c0f\u4e3a" + str.length()));
        if (str.length() < 2000) {
            logger.warn((Object)"\u751f\u6210\u7684\u6587\u4ef6\u5217\u8868\u5927\u5c0f\u8fc7\u5c0f\uff0c\u66f4\u65b0\u670d\u52a1\u6709\u95ee\u9898");
        }
        StringBuffer sb = new StringBuffer("");
        long createTime = System.currentTimeMillis();
        sb.append(" lastModified=\"" + createTime + "\">\r\n");
        sb.append("\t\t<application-desc main-class=\"com.kingdee.eas.base.uiframe.client.LoginFrame\"/>\r\n");
        sb.append("\t\t\t<information>\r\n");
        sb.append("\t\t\t\t<title>client-update</title>\r\n");
        sb.append("\t\t\t\t<vendor>Kingdee</vendor>\r\n");
        sb.append("\t\t\t\t<description>Client of EAS</description>\r\n");
        sb.append("\t\t\t\t<description kind=\"short\">EAS</description>\r\n");
        sb.append("\t\t\t\t<offline-allowed/>\r\n");
        sb.append("\t\t\t</information>\r\n");
        sb.append("\t\t<resources >\r\n");
        sb.append("\t\t" + str + "\r\n");
        sb.append("\t\t</resources>\r\n");
        sb.append("</jnlp>\r\n");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createProxyCache(HashMap args) {
        Object path;
        String configDir = (String)args.get("baseDir");
        String extName = (String)args.get("extName");
        String itemExcluded = (String)args.get("itemExcluded");
        String pathPrefix = (String)args.get("pathPrefix");
        String pathSuffixStr = (String)args.get("pathSuffixStr");
        String seperator = ",";
        pathPrefix = pathPrefix.replace('\\', '/');
        pathPrefix = pathPrefix.replaceAll("//", "/");
        String pathStr = pathPrefix + pathSuffixStr;
        pathStr = pathStr.replaceAll(seperator, seperator + pathPrefix);
        String[] resxPaths = pathStr.split(seperator);
        Collection<String> result = Arrays.asList(resxPaths);
        String[] items = itemExcluded.split(",");
        result = CreateJnlpResourcesBean.getResources(extName, result);
        result = CreateJnlpResourcesBean.getFitResources(result, items);
        Iterator<String> fIterator = result.iterator();
        Properties properties = new Properties();
        while (fIterator.hasNext()) {
            String fileName = fIterator.next();
            path = fileName.substring(configDir.length());
            String md5Version = MD5Util.getMD5(configDir).getProperty((String)path);
            if (md5Version != null) {
                md5Version = md5Version.split(",")[1];
            }
            properties.put(md5Version, path);
        }
        File updateFile = new File(configDir, "ProxyCache.properties");
        try {
            if (updateFile.exists()) {
                updateFile.delete();
            }
            updateFile.createNewFile();
            path = updateFile;
            synchronized (path) {
                FileOutputStream fos = new FileOutputStream(updateFile);
                properties.store(fos, null);
                fos.close();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void createFile(HashMap args, String fileCon) throws IOException {
        boolean rewrite = new Boolean((String)args.get("rewrite"));
        String baseDir = (String)args.get("baseDir");
        String fileName = (String)args.get("fileName");
        assert (fileCon != null);
        File fl = new File(baseDir, fileName);
        if (!fl.exists() || rewrite) {
            FileWriter fw = new FileWriter(fl);
            fw.write(fileCon);
            fw.flush();
            fw.close();
        }
    }

    public static String createEntriesString(HashMap args) {
        String pathPrefix = (String)args.get("pathPrefix");
        String extName = (String)args.get("extName");
        String pathSuffixStr = (String)args.get("pathSuffixStr");
        pathPrefix = pathPrefix.replace('\\', '/');
        pathPrefix = pathPrefix.replaceAll("//", "/");
        pathSuffixStr = pathSuffixStr.replace('\\', '/');
        pathSuffixStr = pathSuffixStr.replaceAll("//", "/");
        String seperator = (String)args.get("seperator");
        String easJnlpFileName = (String)args.get("easJnlpFileName");
        String easJnlpCodeBase = (String)args.get("easJnlpCodeBase");
        Collection resx = CreateJnlpResourcesBean.getResources(pathPrefix, extName, pathSuffixStr, seperator);
        StringBuffer sb = new StringBuffer("");
        sb.append("<localCache  LASTMODIFIED=\"0\" codebase=\"" + easJnlpCodeBase + "\" href=\"" + easJnlpFileName + "\">\r\n");
        Iterator ite = resx.iterator();
        String resxItem = "";
        File fl = null;
        long fLastModified = 0L;
        String resxName = "";
        while (ite.hasNext()) {
            resxItem = (String)ite.next();
            fl = new File(resxItem);
            if (!fl.exists()) continue;
            fLastModified = fl.lastModified();
            resxName = resxItem.replaceAll(pathPrefix, "");
            sb.append("\t\t<resource LASTMODIFIED=\"" + fLastModified + "\" HREF=\"" + resxName + "\"/>\r\n");
        }
        sb.append("</localCache>\r\n");
        return sb.toString();
    }

    public static void createJnlp(HashMap args) throws IOException {
        String jnlpStr = CreateJnlpResourcesBean.createJnlpString(args);
        StringBuffer sb = new StringBuffer("");
        String easJnlpFileName = (String)args.get("easJnlpFileName");
        String easJnlpCodeBase = (String)args.get("easJnlpCodeBase");
        sb.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>\r\n");
        sb.append("\t\t<jnlp spec=\"1.0+\" codebase=\"" + easJnlpCodeBase + "\" href=\"" + easJnlpFileName + "\" ");
        jnlpStr = sb.toString() + jnlpStr;
        CreateJnlpResourcesBean.createFile(args, jnlpStr);
    }

    public static void createEntries(HashMap args) throws IOException {
        String entriesStr = CreateJnlpResourcesBean.createEntriesString(args);
        CreateJnlpResourcesBean.createFile(args, entriesStr);
    }

    public static void test() {
        String pathPrev = "E:/EAS4.1/eas/deploy/apusic/webclient/easWebClient/";
        String extName = "";
        String jnlpResxPaths = "deploy/client/ctrlhome/server/storage/eas/kdnote/template/FI/AP/InitPurInvoice/";
        String seperator = ",";
        String str = CreateJnlpResourcesBean.getJnlpResources("W:/eas/Server/server/deploy/portalConfig", pathPrev, extName, jnlpResxPaths, seperator, "eas_help.jar");
        System.out.println("resources:");
        System.out.println(str);
        Collection resx = CreateJnlpResourcesBean.getResources(pathPrev, extName, jnlpResxPaths, seperator);
        Iterator ite = resx.iterator();
        String resxItem = "";
        System.out.println("resources list:");
        File fl = null;
        long fLastModified = 0L;
        while (ite.hasNext()) {
            resxItem = (String)ite.next();
            fl = new File(resxItem);
            if (!fl.exists()) continue;
            fLastModified = fl.lastModified();
        }
        String baseDir = pathPrev;
        String fileName = "eas.jnlp";
        String easJnlpPath = "http://localhost:6888/easWebClient/";
        HashMap<String, String> fileArgs = new HashMap<String, String>();
        fileArgs.put("pathPrefix", pathPrev);
        fileArgs.put("extName", extName);
        fileArgs.put("pathSuffixStr", jnlpResxPaths);
        fileArgs.put("seperator", seperator);
        fileArgs.put("fileName", fileName);
        fileArgs.put("easJnlpCodeBase", easJnlpPath);
        fileArgs.put("baseDir", baseDir);
        fileArgs.put("rewrite", "true");
        fileArgs.put("easJnlpFileName", "eas.jnlp");
        fileArgs.put("itemExcluded", "");
        try {
            CreateJnlpResourcesBean.createJnlp(fileArgs);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        fileArgs.put("fileName", "kdjnlp.entries");
        try {
            CreateJnlpResourcesBean.createEntries(fileArgs);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static String addToArray(Vector vect, String str) {
        StringBuffer buf = new StringBuffer(str);
        if (vect.size() > 0) {
            Iterator it = vect.iterator();
            String tempStr = null;
            while (it.hasNext()) {
                tempStr = (String)it.next();
                buf.append(",");
                buf.append(tempStr);
            }
        }
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Vector getFirstLoadRes(String path) {
        Vector<String> FirstDownResVect = new Vector<String>();
        File FirstDownResFile = new File(path + FIRSTDOWNRES_FILENAME);
        if (FirstDownResFile.exists()) {
            BufferedReader in = null;
            try {
                in = new BufferedReader(new InputStreamReader(new FileInputStream(FirstDownResFile)));
                String line = null;
                while (true) {
                    try {
                        line = in.readLine();
                    }
                    catch (IOException e) {
                        System.out.println("file FirstDownRes.properties has a bad line!");
                    }
                    if (line == null) {
                        break;
                    }
                    line = StringUtils.trim((String)line);
                    FirstDownResVect.add(line);
                }
            }
            catch (FileNotFoundException e) {
                System.out.println("file FirstDownRes.properties not found!");
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        System.out.println("IOException when closing!");
                    }
                }
            }
        }
        return FirstDownResVect;
    }

    private static String parseJnlpName(String version) {
        StringBuffer buff = new StringBuffer();
        version = version.replace('.', '_');
        buff.append("eas_");
        buff.append(version);
        buff.append(".jnlp");
        return buff.toString();
    }

    public static Properties toProp(DownloadTraceInfo traceInfo) {
        Properties properties = new Properties();
        properties.setProperty("downloadCompleted", new Boolean(traceInfo.isDownloadCompleted()).toString());
        properties.setProperty("jnlpVersionFiles", traceInfo.getJnlpVersionFiles());
        properties.setProperty("jnlpVersion", traceInfo.getJnlpVersion());
        properties.setProperty("ondemandjnlpversion", traceInfo.getOndemandjnlpversion());
        properties.setProperty("fulljnlpversion", traceInfo.getFulljnlpversion());
        return properties;
    }

    public static void storeTraceInfo(DownloadTraceInfo traceInfo) {
        Properties prop = CreateJnlpResourcesBean.toProp(traceInfo);
        CreateJnlpResourcesBean.modifyDownLoadFiles(traceInfo.getBaseDir(), traceInfo.getTraceFileName(), prop);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void modifyDownLoadFiles(File baseDir, String updateTraceFileName, Properties properties) {
        if (properties == null) {
            throw new NullPointerException();
        }
        try {
            File updateFile = new File(baseDir, updateTraceFileName);
            if (!updateFile.exists()) {
                updateFile.createNewFile();
            }
            File file = updateFile;
            synchronized (file) {
                FileOutputStream fos = new FileOutputStream(updateFile);
                properties.store(fos, null);
                fos.close();
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        DownloadTraceInfo traceInfo;
        if (args.length != 5) {
            System.out.println("please provide 5 args,for example:");
            System.out.println("java -classpath cp_autoupdater.jar com.kingdee.eas.cp.autoupdater.CreateJnlpResourcesBean E:/EAS4.1/eas/deploy/apusic/webclient/easWebClient/ deploy/,bin/,classloader/ lib/sp/,lib/industry,lib/patch/,lib/common/,lib/client/,metas/sp-bim-metas.jar,metas/sp/,metas/industry,metas/patch/,metas/  5.4.0.0  eas_help.jar");
            return;
        }
        String pathPrev = args[0];
        String jnlpResxPaths = args[1];
        String version = args[3];
        String itemExcluded = args[4];
        String seperator = ",";
        String baseDir = pathPrev;
        String fileName = CreateJnlpResourcesBean.parseJnlpName(version);
        String easJnlpPath = "http://127.0.0.1:6888/easWebClient/";
        String extName = "";
        HashMap<String, String> fileArgs = new HashMap<String, String>();
        Vector FirstDownResVect = CreateJnlpResourcesBean.getFirstLoadRes(pathPrev + "/bin/");
        jnlpResxPaths = CreateJnlpResourcesBean.addToArray(FirstDownResVect, jnlpResxPaths);
        fileArgs.put("pathPrefix", pathPrev);
        fileArgs.put("extName", extName);
        fileArgs.put("pathSuffixStr", jnlpResxPaths);
        fileArgs.put("seperator", seperator);
        fileArgs.put("fileName", fileName);
        fileArgs.put("easJnlpCodeBase", easJnlpPath);
        fileArgs.put("baseDir", baseDir);
        fileArgs.put("rewrite", "true");
        fileArgs.put("easJnlpFileName", fileName);
        fileArgs.put("itemExcluded", itemExcluded);
        File file = new File(pathPrev);
        try {
            CreateJnlpResourcesBean.createJnlp(fileArgs);
            traceInfo = new DownloadTraceInfo(file, "update.properties", true);
            traceInfo.setJnlpVersion(version);
            traceInfo.setOndemandjnlpversion("");
            traceInfo.setFulljnlpversion("");
            traceInfo.setJnlpVersionFiles("eas.jnlp," + fileName);
            CreateJnlpResourcesBean.storeTraceInfo(traceInfo);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        pathPrev = args[0];
        jnlpResxPaths = args[2];
        seperator = ",";
        baseDir = pathPrev;
        fileName = "resource.lst";
        easJnlpPath = "http://127.0.0.1:6888/easWebClient/";
        extName = "";
        fileArgs = new HashMap();
        itemExcluded = CreateJnlpResourcesBean.addToArray(FirstDownResVect, itemExcluded);
        fileArgs.put("pathPrefix", pathPrev);
        fileArgs.put("extName", extName);
        fileArgs.put("pathSuffixStr", jnlpResxPaths);
        fileArgs.put("seperator", seperator);
        fileArgs.put("fileName", fileName);
        fileArgs.put("easJnlpCodeBase", easJnlpPath);
        fileArgs.put("baseDir", baseDir);
        fileArgs.put("rewrite", "true");
        fileArgs.put("easJnlpFileName", "resource.lst");
        fileArgs.put("itemExcluded", itemExcluded);
        try {
            CreateJnlpResourcesBean.createJnlp(fileArgs);
            traceInfo = new DownloadTraceInfo(file, "onDemandTrace.properties", true);
            traceInfo.setJnlpVersion(version);
            traceInfo.setOndemandjnlpversion("");
            traceInfo.setFulljnlpversion("");
            traceInfo.setJnlpVersionFiles("resource.lst");
            CreateJnlpResourcesBean.storeTraceInfo(traceInfo);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        jnlpResxPaths = args[1] + "," + args[2];
        fileArgs.put("pathSuffixStr", jnlpResxPaths);
        CreateJnlpResourcesBean.createProxyCache(fileArgs);
    }
}

