/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.autoupdater.util;

import java.math.BigInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BigIntegerAddition {
    public static void main(String[] args) {
        String x = "23456789000000000888";
        String y = "9876543218888888888";
        BigInteger a = new BigInteger(x);
        BigInteger b = new BigInteger(y);
        BigInteger c = a.add(b);
        System.out.println(c.toString());
        String d = BigIntegerAddition.add(x, y);
        System.out.println(d);
    }

    public static String add(String x, String y) {
        if (x == null || y == null) {
            return null;
        }
        if (!BigIntegerAddition.isNumeric(x) || !BigIntegerAddition.isNumeric(y)) {
            return null;
        }
        if (x.equals("0")) {
            return y;
        }
        if (y.equals("0")) {
            return x;
        }
        if (x.length() > y.length()) {
            String tmp = x;
            x = y;
            y = tmp;
        }
        x = BigIntegerAddition.addZeroToFirst(x, y.length());
        String z = BigIntegerAddition.addHelp(x, y);
        return z;
    }

    public static String addHelp(String x, String y) {
        String z = "";
        int len = x.length();
        int[] a = BigIntegerAddition.toIntArray(x);
        int[] b = BigIntegerAddition.toIntArray(y);
        int[] c = new int[len + 1];
        int d = 0;
        for (int i = 0; i < len; ++i) {
            int tmpSum = a[len - 1 - i] + b[len - 1 - i] + d;
            c[len - i] = tmpSum % 10;
            d = tmpSum / 10;
        }
        c[0] = d;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i <= len; ++i) {
            sb.append(c[i]);
        }
        z = c[0] == 0 ? sb.substring(1) : sb.toString();
        return z;
    }

    public static int[] toIntArray(String str) {
        int len = str.length();
        int[] result = new int[len];
        for (int i = 0; i < len; ++i) {
            result[i] = str.charAt(i) - 48;
        }
        return result;
    }

    public static String addZeroToFirst(String str, int length) {
        StringBuilder sb = new StringBuilder();
        for (int diff = length - str.length(); diff > 0; --diff) {
            sb.append("0");
        }
        sb.append(str);
        return sb.toString();
    }

    public static boolean isNumeric(String str) {
        Pattern p = Pattern.compile("[0-9]*");
        Matcher isNum = p.matcher(str);
        return isNum.matches();
    }
}

