/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.autoupdater.util;

import com.kingdee.eas.cp.autoupdater.util.MD5Util;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class DownloadUtil {
    private static String[] coreClientFiles = new String[0];
    private static String configDir;
    private static Properties md5;
    private static String entryName;
    private static String fileMD5Split;
    private static String fileSplit;
    private static String[] initClientFiles;
    private static String[] initClientFilesMd5;
    private static String[] coreClientFilesMd5;

    public static String getFilesAndMd5() {
        for (int i = 0; i < initClientFiles.length; ++i) {
            DownloadUtil.initClientFilesMd5[i] = DownloadUtil.getMd5Version(initClientFiles[i]);
        }
        return DownloadUtil.combinFiles(initClientFiles, initClientFilesMd5);
    }

    public static String getCoreClientFilesAndMd5() {
        for (int i = 0; i < coreClientFiles.length - 1; ++i) {
            DownloadUtil.coreClientFilesMd5[i] = DownloadUtil.getMd5Version(coreClientFiles[i]);
        }
        DownloadUtil.coreClientFilesMd5[DownloadUtil.coreClientFiles.length - 1] = DownloadUtil.getVersionFromJarFile();
        return DownloadUtil.combinFiles(coreClientFiles, coreClientFilesMd5);
    }

    private static String getMd5Version(String file) {
        return MD5Util.getMD5Value(md5, file);
    }

    private static String combinFiles(String[] files, String[] filesMd5) {
        StringBuffer filesSB = new StringBuffer();
        for (int i = 0; i < files.length; ++i) {
            filesSB.append(files[i]);
            filesSB.append(fileMD5Split);
            filesSB.append(filesMd5[i]);
            if (i == files.length - 1) continue;
            filesSB.append(fileSplit);
        }
        return filesSB.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getVersionFromJarFile() {
        ZipFile jarFile = null;
        try {
            jarFile = new JarFile(System.getProperty("EAS_HOME") + "/server/deploy/fileserver.ear/easWebClient/classloader/patch/kdupdater.jar");
            ZipEntry zipEntry = ((JarFile)jarFile).getEntry(entryName);
            InputStream is = ((JarFile)jarFile).getInputStream(zipEntry);
            Properties prop = new Properties();
            prop.load(is);
            String ver = prop.getProperty("version");
            String string = ver == null ? "" : ver;
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    static {
        File file = new File(System.getProperty("EAS_HOME") + "/server/deploy/fileserver.ear/easWebClient/classloader/patch/");
        String[] files = file.list(new FilenameFilter(){

            @Override
            public boolean accept(File arg0, String arg1) {
                return arg1.endsWith(".jar");
            }
        });
        coreClientFiles = new String[files.length + 3];
        for (int i = 0; i < files.length; ++i) {
            DownloadUtil.coreClientFiles[i] = "classloader/patch/" + files[i];
        }
        DownloadUtil.coreClientFiles[DownloadUtil.coreClientFiles.length - 3] = "bin/clientStartup.bat";
        DownloadUtil.coreClientFiles[DownloadUtil.coreClientFiles.length - 2] = "bin/launcher.exe";
        DownloadUtil.coreClientFiles[DownloadUtil.coreClientFiles.length - 1] = "bodyguardVersion";
        configDir = System.getProperty("EAS_HOME") + "/server/properties/";
        md5 = MD5Util.getMD5(configDir);
        entryName = "com/kingdee/eas/tools/bodyguard/bodyguardVersion.properties";
        fileMD5Split = ":";
        fileSplit = ",";
        initClientFiles = new String[]{"bin/clientStartup.bat", "bin/launcher.exe", "bin/set-client-env.bat", "bin/client.vmoptions", "bin/client.ico", "classloader/patch/kdupdater.jar", "classloader/patch/apploader.jar", "classloader/patch/log4j-1.2.6.jar", "classloader/patch/foxtrot.jar", "classloader/patch/slf4j-api-1.6.1.jar"};
        initClientFilesMd5 = new String[initClientFiles.length];
        coreClientFilesMd5 = new String[coreClientFiles.length];
    }
}

