/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.autoupdater.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.Properties;

public class JNLPUtil {
    private static Properties jnlpProp = null;
    public static String JNLP_RESOURCE_FILENAME = "jnlp.properties";
    public static String FILE_LAST_MODIFITIME = "";

    public static Properties getJNLPProperties(String localDir) {
        if (jnlpProp == null) {
            JNLPUtil.loadJNLPProperties(localDir);
        } else {
            String modifitime = String.valueOf(new File(localDir, JNLP_RESOURCE_FILENAME).lastModified());
            if (!FILE_LAST_MODIFITIME.equalsIgnoreCase(modifitime)) {
                JNLPUtil.loadJNLPProperties(localDir);
            }
        }
        return jnlpProp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadJNLPProperties(String localDir) {
        File resourceFileHandler = new File(localDir, JNLP_RESOURCE_FILENAME);
        if (!resourceFileHandler.exists()) {
            try {
                if (!resourceFileHandler.createNewFile()) {
                    System.out.println("create " + JNLP_RESOURCE_FILENAME + " error.");
                }
            }
            catch (IOException e) {
                System.out.println("create " + JNLP_RESOURCE_FILENAME + " error.");
                e.printStackTrace();
            }
        }
        if (resourceFileHandler.exists()) {
            BufferedInputStream bs = null;
            try {
                bs = new BufferedInputStream(new FileInputStream(resourceFileHandler));
                jnlpProp = new Properties();
                jnlpProp.load(bs);
                FILE_LAST_MODIFITIME = String.valueOf(resourceFileHandler.lastModified());
            }
            catch (Exception e) {
                System.out.println("load " + JNLP_RESOURCE_FILENAME + " error.");
                resourceFileHandler.delete();
                e.printStackTrace();
            }
            finally {
                try {
                    if (bs != null) {
                        bs.close();
                    }
                }
                catch (IOException ex1) {
                    System.out.println("IOException when closing!");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void storeJNLPProperties(String localDir) {
        if (jnlpProp != null) {
            File resourceFileHandler = new File(localDir, JNLP_RESOURCE_FILENAME);
            if (resourceFileHandler.exists()) {
                resourceFileHandler.delete();
            } else {
                try {
                    if (!resourceFileHandler.createNewFile()) {
                        System.out.println("create " + JNLP_RESOURCE_FILENAME + " error.");
                    }
                }
                catch (IOException e) {
                    System.out.println("create " + JNLP_RESOURCE_FILENAME + " error.");
                    e.printStackTrace();
                }
            }
            FilterOutputStream bs = null;
            try {
                bs = new BufferedOutputStream(new FileOutputStream(resourceFileHandler));
                jnlpProp.store(bs, null);
            }
            catch (Exception e) {
                System.out.println("store " + JNLP_RESOURCE_FILENAME + " error.");
                resourceFileHandler.delete();
                e.printStackTrace();
            }
            finally {
                try {
                    if (bs != null) {
                        bs.close();
                    }
                }
                catch (IOException e) {
                    System.out.println("IOException when closing!");
                }
            }
        }
    }
}

