/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.bicomponent;

import com.kingdee.bos.ctrl.analysis.AnalysisException;
import com.kingdee.bos.ctrl.analysis.IExceptionHandler;
import com.kingdee.bos.ctrl.analysis.bicomponent.BIComponent;
import com.kingdee.bos.ctrl.analysis.bicomponent.BIComponentResource;
import com.kingdee.bos.ctrl.analysis.bicomponent.CellItem;
import com.kingdee.bos.ctrl.analysis.bicomponent.ComponentConfig;
import com.kingdee.bos.ctrl.analysis.bicomponent.DimensionNavigator;
import com.kingdee.bos.ctrl.analysis.bicomponent.HierarchyCellItem;
import com.kingdee.bos.ctrl.analysis.bicomponent.OlapModelUtil;
import com.kingdee.bos.ctrl.analysis.bicomponent.event.CellItemClickEvent;
import com.kingdee.bos.ctrl.analysis.bicomponent.event.CellItemClickListener;
import com.kingdee.bos.ctrl.analysis.modelcore.ModelChangeEvent;
import com.kingdee.bos.ctrl.analysis.olap.Axis;
import com.kingdee.bos.ctrl.analysis.olap.AxisMembersHelper;
import com.kingdee.bos.ctrl.analysis.olap.ChangeSlicer;
import com.kingdee.bos.ctrl.analysis.olap.Dimension;
import com.kingdee.bos.ctrl.analysis.olap.DrillExpandMember;
import com.kingdee.bos.ctrl.analysis.olap.DrillExpandPosition;
import com.kingdee.bos.ctrl.analysis.olap.DrillReplace;
import com.kingdee.bos.ctrl.analysis.olap.Hierarchy;
import com.kingdee.bos.ctrl.analysis.olap.Member;
import com.kingdee.bos.ctrl.analysis.olap.MemberTree;
import com.kingdee.bos.ctrl.analysis.olap.NonEmpty;
import com.kingdee.bos.ctrl.analysis.olap.OlapException;
import com.kingdee.bos.ctrl.analysis.olap.OlapModel;
import com.kingdee.bos.ctrl.analysis.olap.Position;
import com.kingdee.bos.ctrl.analysis.util.Displayable;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.olap.mdx.Exp;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

public abstract class BIComponentBase
implements BIComponent {
    protected OlapModel olapModel;
    protected ComponentConfig config;
    protected DimensionNavigator dimensionNavigator;
    private ArrayList listCellItemClickListener = new ArrayList();
    IExceptionHandler exceptionHandler;
    Action actionMoveToTop = new AbstractAction(BIComponentResource.getString(BIComponentResource.class, (String)"ColumnHeader")){

        @Override
        public void actionPerformed(ActionEvent e) {
            HierarchyCellItem hci = (HierarchyCellItem)BIComponentBase.this.popupCellItem;
            BIComponentBase.this.moveToTop(hci.getHierarchy());
        }
    };
    Action actionMoveToLeft = new AbstractAction(BIComponentResource.getString(BIComponentResource.class, (String)"RowHeader")){

        @Override
        public void actionPerformed(ActionEvent e) {
            HierarchyCellItem hci = (HierarchyCellItem)BIComponentBase.this.popupCellItem;
            BIComponentBase.this.moveToLeft(hci.getHierarchy());
        }
    };
    Action actionMoveToSlice = new AbstractAction(BIComponentResource.getString(BIComponentResource.class, (String)"Slicer")){

        @Override
        public void actionPerformed(ActionEvent e) {
            HierarchyCellItem hci = (HierarchyCellItem)BIComponentBase.this.popupCellItem;
            BIComponentBase.this.moveToSlice(hci.getHierarchy());
        }
    };
    Action actionSwapAxis = new AbstractAction(BIComponentResource.getString(BIComponentResource.class, (String)"SwapRowColumn")){

        @Override
        public void actionPerformed(ActionEvent e) {
            BIComponentBase.this.swapAxis();
        }
    };
    Action actionMemberSelect = new AbstractAction(BIComponentResource.getString(BIComponentResource.class, (String)"MemberSelector")){

        @Override
        public void actionPerformed(ActionEvent e) {
        }
    };
    protected CellItem popupCellItem;
    protected JPopupMenu popupMenuForHierarchy;
    protected JMenu menuMove = new JMenu(BIComponentResource.getString(BIComponentResource.class, (String)"MoveTo"));
    protected JMenu menuMoveBefore = new JMenu(BIComponentResource.getString(BIComponentResource.class, (String)"MoveToBefore"));
    protected JMenu menuMoveAfter = new JMenu(BIComponentResource.getString(BIComponentResource.class, (String)"MoveToAfter"));
    protected JMenu menuSwap = new JMenu(BIComponentResource.getString(BIComponentResource.class, (String)"Swap"));
    protected HashMap mapMove = new HashMap();
    protected HashMap mapMoveBefore = new HashMap();
    protected HashMap mapMoveAfter = new HashMap();
    protected HashMap mapSwap = new HashMap();

    public BIComponentBase(ComponentConfig config) {
        if (config == null) {
            config = ComponentConfig.getConfig();
        }
        this.config = config;
        this.addCellItemClickListener(new CellItemClickListener(){

            @Override
            public void cellItemClicked(CellItemClickEvent event) {
                if (event.doubleClick && event.cellItem instanceof HierarchyCellItem) {
                    BIComponentBase.this.showDimensionNavigator(((HierarchyCellItem)event.cellItem).getHierarchy());
                }
            }
        });
    }

    @Override
    public OlapModel getOlapModel() {
        return this.olapModel;
    }

    @Override
    public void setModel(OlapModel olapModel) {
        this.setModel(olapModel, true);
    }

    public void setModel(OlapModel olapModel, boolean fireModelChangeEvent) {
        if (this.olapModel == olapModel) {
            return;
        }
        if (this.olapModel != null) {
            this.olapModel.removeModelChangeListener(this);
        }
        this.olapModel = olapModel;
        olapModel.addModelChangeListener(this);
        NonEmpty nonEmpty = (NonEmpty)olapModel.getExtension("nonEmpty");
        if (this.config.useNonEmpty) {
            nonEmpty.setNonEmptyForColumn(this.config.nonEmptyForColumn);
            nonEmpty.setNonEmptyForRow(this.config.nonEmptyForRow);
        }
        if (this.dimensionNavigator != null) {
            this.dimensionNavigator.setOlapModel(olapModel);
        }
        if (fireModelChangeEvent) {
            this.modelChanged(new ModelChangeEvent(olapModel));
        }
    }

    public void fireModelChangeEvent() {
        if (this.olapModel != null) {
            this.modelChanged(new ModelChangeEvent(this.olapModel));
        }
    }

    public DimensionNavigator getDimensionNavigator() {
        if (this.dimensionNavigator == null) {
            this.dimensionNavigator = this.createDimensionNavigator();
            this.dimensionNavigator.setOlapModel(this.olapModel);
        }
        return this.dimensionNavigator;
    }

    public void setDimensionNavigator(DimensionNavigator dimensionNavigator) {
        this.dimensionNavigator = dimensionNavigator;
    }

    protected void showDimensionNavigator(Hierarchy hierarchy) {
        if (this.config.showDimensionNavigator) {
            if (this.dimensionNavigator == null) {
                this.dimensionNavigator = this.createDimensionNavigator();
                this.dimensionNavigator.setOlapModel(this.olapModel);
                WindowUtil.makeCneterBounds((Window)((Object)this.dimensionNavigator));
            }
            if (this.dimensionNavigator.showForHierarchy(hierarchy)) {
                try {
                    this.setHierarchyMembers(hierarchy, this.dimensionNavigator.getSelectedMembers());
                }
                catch (OlapException e) {
                    this.handleException(e);
                }
            }
        }
    }

    protected DimensionNavigator createDimensionNavigator() {
        Window window = SwingUtilities.getWindowAncestor(this.getJComponent());
        if (window instanceof JDialog) {
            return new DimensionNavigator((JDialog)window, this.config);
        }
        if (window instanceof JFrame) {
            return new DimensionNavigator((JFrame)window, this.config);
        }
        return new DimensionNavigator(this.config);
    }

    @Override
    public void modelChanged(ModelChangeEvent e) {
        this.refresh();
    }

    public void structureChanged(ModelChangeEvent e) {
        this.refresh();
    }

    public void addCellItemClickListener(CellItemClickListener l) {
        this.listCellItemClickListener.add(l);
    }

    public void removeCellItemClickListener(CellItemClickListener l) {
        this.listCellItemClickListener.remove(l);
    }

    public void fireCellItemClicked(CellItemClickEvent e) {
        Iterator it = this.listCellItemClickListener.iterator();
        while (it.hasNext()) {
            ((CellItemClickListener)it.next()).cellItemClicked(e);
        }
    }

    @Override
    public void beforeRender() {
    }

    @Override
    public void afterRender() {
    }

    @Override
    public void refresh() {
        this.beforeRender();
        this.render();
        this.afterRender();
    }

    protected void showEmptyWhenException(AnalysisException e) {
    }

    public void setConfig(ComponentConfig config) {
        this.config = config;
    }

    public ComponentConfig getConfig() {
        return this.config;
    }

    public Hierarchy[] getTopAxisHies() throws OlapException {
        return OlapModelUtil.getTopAxis(this.olapModel).getHierarchies();
    }

    public Hierarchy[] getLeftAxisHies() throws OlapException {
        return OlapModelUtil.getLeftAxis(this.olapModel).getHierarchies();
    }

    protected MemberTree getMemberTree() {
        if (this.olapModel != null) {
            return (MemberTree)this.olapModel.getExtension("memberTree");
        }
        return null;
    }

    protected ChangeSlicer getChangeSlicer() {
        if (this.olapModel != null) {
            return (ChangeSlicer)this.olapModel.getExtension("changeSlicer");
        }
        return null;
    }

    public Member[] getSliceMembers() {
        return this.getChangeSlicer().getSlicer();
    }

    protected Member getParentMember(Member member) {
        return this.getMemberTree().getParent(member);
    }

    public void setExceptionHandler(IExceptionHandler eh) {
        this.exceptionHandler = eh;
    }

    protected void handleException(Exception e) {
        if (this.exceptionHandler != null) {
            this.exceptionHandler.handleException(e);
        } else {
            WindowUtil.alert((Component)this.getJComponent(), (String)e.getMessage());
        }
    }

    protected List getSliceHierarchy() {
        Member[] sliceMembers = this.getSliceMembers();
        ArrayList<Hierarchy> list = new ArrayList<Hierarchy>();
        for (int i = 0; i < sliceMembers.length; ++i) {
            list.add(sliceMembers[i].getLevel().getHierarchy());
        }
        return list;
    }

    protected List getAllHierarchy() {
        Dimension[] dims = this.olapModel.getDimensions();
        ArrayList<Hierarchy> list = new ArrayList<Hierarchy>();
        for (int i = 0; i < dims.length; ++i) {
            list.addAll(Arrays.asList(dims[i].getHierarchies()));
        }
        return list;
    }

    protected Member[] getAllMeasure() {
        return this.olapModel.getMeasures();
    }

    public void setHierarchyMembers(Hierarchy hier, List memberList) throws OlapException {
        OlapModelUtil.changeHierarchyMembers(this.olapModel, hier, memberList);
    }

    protected void rollup(Position position, Member member, boolean replace) {
        if (replace) {
            DrillReplace drill = (DrillReplace)this.olapModel.getExtension("drillReplace");
            drill.drillUp(member.getHierarchy());
        } else if (this.config.expandMode == 0) {
            DrillExpandMember drill = (DrillExpandMember)this.olapModel.getExtension("drillExpandMember");
            drill.collapse(member);
        } else {
            DrillExpandPosition drill = (DrillExpandPosition)this.olapModel.getExtension("drillExpandPosition");
            drill.setUseExpandStateCache(this.config.useExpandStateCache);
            drill.collapse(position, member);
        }
    }

    protected void drilldown(Position position, Member member, boolean replace) {
        if (replace) {
            DrillReplace drill = (DrillReplace)this.olapModel.getExtension("drillReplace");
            drill.drillDown(member);
        } else if (this.config.expandMode == 0) {
            DrillExpandMember drill = (DrillExpandMember)this.olapModel.getExtension("drillExpandMember");
            drill.expand(member);
        } else {
            DrillExpandPosition drill = (DrillExpandPosition)this.olapModel.getExtension("drillExpandPosition");
            drill.setUseExpandStateCache(this.config.useExpandStateCache);
            drill.expand(position, member);
        }
    }

    public void swapAxis() {
        OlapModelUtil.swapAxis(this.olapModel);
    }

    protected void moveToTop(Hierarchy hie) {
        OlapModelUtil.moveToTop(this.olapModel, hie);
    }

    protected void moveToLeft(Hierarchy hie) {
        OlapModelUtil.moveToLeft(this.olapModel, hie);
    }

    protected void moveToSlice(Hierarchy hie) {
        OlapModelUtil.moveToSlice(this.olapModel, hie);
    }

    protected void swap(Hierarchy hie, Hierarchy hie2) {
        OlapModelUtil.swap(this.olapModel, hie, hie2);
    }

    protected void moveBefore(Hierarchy hie, Hierarchy tohie) {
        OlapModelUtil.moveBefore(this.olapModel, hie, tohie);
    }

    protected void moveAfter(Hierarchy hie, Hierarchy tohie) {
        OlapModelUtil.moveAfter(this.olapModel, hie, tohie);
    }

    protected void hideMe(Member member) {
        Axis axis = null;
        try {
            axis = OlapModelUtil.getAxisOfHierarchy(this.olapModel, member.getHierarchy());
        }
        catch (OlapException e) {
            e.printStackTrace();
        }
        AxisMembersHelper amh = (AxisMembersHelper)this.olapModel.getExtension("axisMembersHelper");
        List memberList = amh.findVisibleMembers(member.getHierarchy());
        memberList.remove(member);
        OlapModelUtil.hierarchize(this.olapModel, memberList);
        Exp object = amh.createMemberExpression(memberList);
        Hierarchy[] hierarchies = axis.getHierarchies();
        Exp[] memberExpressions = new Exp[hierarchies.length];
        for (int i = 0; i < hierarchies.length; ++i) {
            memberExpressions[i] = hierarchies[i].equals(member.getHierarchy()) ? object : amh.createMemberExpression(hierarchies[i]);
        }
        amh.setQueryAxis(axis, hierarchies, memberExpressions);
    }

    protected void showOnlyMe(Member member) {
        Axis axis = null;
        try {
            axis = OlapModelUtil.getAxisOfHierarchy(this.olapModel, member.getHierarchy());
        }
        catch (OlapException e) {
            e.printStackTrace();
        }
        AxisMembersHelper amh = (AxisMembersHelper)this.olapModel.getExtension("axisMembersHelper");
        ArrayList<Member> memberList = new ArrayList<Member>();
        memberList.add(member);
        Exp object = amh.createMemberExpression(memberList);
        Hierarchy[] hierarchies = axis.getHierarchies();
        Exp[] memberExpressions = new Exp[hierarchies.length];
        for (int i = 0; i < hierarchies.length; ++i) {
            memberExpressions[i] = hierarchies[i].equals(member.getHierarchy()) ? object : amh.createMemberExpression(hierarchies[i]);
        }
        amh.setQueryAxis(axis, hierarchies, memberExpressions);
    }

    public JPopupMenu getPopupMenuForHierarchy() {
        if (this.popupMenuForHierarchy == null) {
            this.popupMenuForHierarchy = new JPopupMenu();
            this.menuMove.removeAll();
            this.popupMenuForHierarchy.add(this.menuMove);
            this.menuMoveBefore.removeAll();
            this.popupMenuForHierarchy.add(this.menuMoveBefore);
            this.menuMoveAfter.removeAll();
            this.popupMenuForHierarchy.add(this.menuMoveAfter);
            this.menuSwap.removeAll();
            this.popupMenuForHierarchy.add(this.menuSwap);
            this.mapMove.clear();
            this.mapMoveBefore.clear();
            this.mapMoveAfter.clear();
            this.mapSwap.clear();
            this.menuMove.add(this.actionMoveToTop);
            this.menuMove.add(this.actionMoveToLeft);
            this.menuMove.add(this.actionMoveToSlice);
            this.mapMove.put("top", this.actionMoveToTop);
            this.mapMove.put("left", this.actionMoveToLeft);
            this.mapMove.put("slice", this.actionMoveToSlice);
            List allHies = this.getAllHierarchy();
            int count = allHies.size();
            for (int i = 0; i < count; ++i) {
                Hierarchy hie = (Hierarchy)allHies.get(i);
                BaseElementAction moveBeforeAction = new BaseElementAction(hie){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        HierarchyCellItem hci = (HierarchyCellItem)BIComponentBase.this.popupCellItem;
                        BIComponentBase.this.moveBefore(hci.getHierarchy(), (Hierarchy)this.element);
                    }
                };
                this.menuMoveBefore.add(moveBeforeAction);
                this.mapMoveBefore.put(hie, moveBeforeAction);
                BaseElementAction moveAfterAction = new BaseElementAction(hie){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        HierarchyCellItem hci = (HierarchyCellItem)BIComponentBase.this.popupCellItem;
                        BIComponentBase.this.moveAfter(hci.getHierarchy(), (Hierarchy)this.element);
                    }
                };
                this.menuMoveAfter.add(moveAfterAction);
                this.mapMoveAfter.put(hie, moveAfterAction);
                BaseElementAction swapAction = new BaseElementAction(hie){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        HierarchyCellItem hci = (HierarchyCellItem)BIComponentBase.this.popupCellItem;
                        BIComponentBase.this.swap(hci.getHierarchy(), (Hierarchy)this.element);
                    }
                };
                this.menuSwap.add(swapAction);
                this.mapSwap.put(hie, swapAction);
            }
            this.popupMenuForHierarchy.addSeparator();
            this.popupMenuForHierarchy.add(this.actionSwapAxis);
        }
        return this.popupMenuForHierarchy;
    }

    public void popupForHierarchy(HierarchyCellItem hci, Component parent, int x, int y) {
        this.popupCellItem = hci;
        JPopupMenu menu = this.getPopupMenuForHierarchy();
        Hierarchy hie = hci.getHierarchy();
        Iterator iter = this.mapMove.values().iterator();
        while (iter.hasNext()) {
            ((Action)iter.next()).setEnabled(true);
        }
        iter = this.mapMoveBefore.values().iterator();
        while (iter.hasNext()) {
            ((Action)iter.next()).setEnabled(true);
        }
        iter = this.mapMoveAfter.values().iterator();
        while (iter.hasNext()) {
            ((Action)iter.next()).setEnabled(true);
        }
        iter = this.mapSwap.values().iterator();
        while (iter.hasNext()) {
            ((Action)iter.next()).setEnabled(true);
        }
        boolean onlyone = false;
        try {
            if (hci.inColumns() && OlapModelUtil.getTopAxisHies(this.olapModel).length == 1) {
                onlyone = true;
            } else if (hci.inRows() && OlapModelUtil.getLeftAxisHies(this.olapModel).length == 1) {
                onlyone = true;
            }
        }
        catch (OlapException e) {
            e.printStackTrace();
        }
        if (onlyone) {
            Iterator iter2 = this.mapMove.values().iterator();
            while (iter2.hasNext()) {
                ((Action)iter2.next()).setEnabled(false);
            }
            iter2 = this.mapMoveBefore.values().iterator();
            while (iter2.hasNext()) {
                ((Action)iter2.next()).setEnabled(false);
            }
            iter2 = this.mapMoveAfter.values().iterator();
            while (iter2.hasNext()) {
                ((Action)iter2.next()).setEnabled(false);
            }
        }
        ((Action)this.mapMoveBefore.get(hie)).setEnabled(false);
        ((Action)this.mapMoveAfter.get(hie)).setEnabled(false);
        ((Action)this.mapSwap.get(hie)).setEnabled(false);
        if (hci.inSlicer()) {
            ((Action)this.mapMove.get("slice")).setEnabled(false);
        } else if (hci.inColumns()) {
            ((Action)this.mapMove.get("top")).setEnabled(false);
        } else if (hci.inRows()) {
            ((Action)this.mapMove.get("left")).setEnabled(false);
        }
        if (hci.inSlicer()) {
            List listHies = this.getSliceHierarchy();
            for (Object o : listHies) {
                ((Action)this.mapMoveBefore.get(o)).setEnabled(false);
                ((Action)this.mapMoveAfter.get(o)).setEnabled(false);
                ((Action)this.mapSwap.get(o)).setEnabled(false);
            }
        }
        menu.show(parent, x, y);
    }

    abstract class BaseElementAction
    extends AbstractAction {
        protected Displayable element;

        public BaseElementAction(Displayable element) {
            super(element.getLabel());
            this.element = element;
        }
    }
}

