/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.bicomponent;

import com.kingdee.bos.ctrl.analysis.bicomponent.CellItem;
import com.kingdee.bos.ctrl.analysis.bicomponent.style.Attribute;
import com.kingdee.bos.ctrl.analysis.bicomponent.style.Cstyle;
import com.kingdee.bos.ctrl.analysis.bicomponent.style.ExecuteContext;
import com.kingdee.bos.ctrl.analysis.olap.Cell;
import com.kingdee.bos.ctrl.analysis.olap.Member;
import com.kingdee.bos.ctrl.analysis.olap.OlapModel;
import com.kingdee.bos.ctrl.kdf.export.IExportObject;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;

public class DataCellItem
extends CellItem
implements IExportObject {
    private Cell cell;

    DataCellItem(OlapModel model, Cell cell) {
        super(model, 2, 3);
        this.cell = cell;
    }

    public Object getValue() {
        return this.cell.getValue();
    }

    public String getFormattedValue() {
        return this.cell.getFormattedValue();
    }

    @Override
    public Color getForeColor() {
        Color c = this.cell.getForeColor();
        if (c == null) {
            c = super.getForeColor();
        }
        return c;
    }

    @Override
    public Color getBgColor() {
        Color c = this.cell.getBgColor();
        if (c == null) {
            c = super.getBgColor();
        }
        return c;
    }

    public String getTrend() {
        String trend = this.cell.getTrend();
        if (trend == null) {
            return null;
        }
        if ("1".equals(trend = trend.trim())) {
            trend = "up";
        } else if ("-1".equals(trend)) {
            trend = "down";
        } else if ("0".equals(trend)) {
            trend = "equal";
        }
        return trend;
    }

    public String getStatus() {
        String status = this.cell.getStatus();
        if (status == null) {
            return null;
        }
        if ("1".equals(status = status.trim())) {
            status = "good";
        } else if ("-1".equals(status)) {
            status = "bad";
        } else if ("0".equals(status)) {
            status = "equal";
        }
        return status;
    }

    public String toString() {
        String value = this.getFormattedValue();
        if (value != null) {
            return value.toString();
        }
        return "";
    }

    public Member[] getMemberContext() {
        if (this.cell != null) {
            return this.cell.getMemberContext();
        }
        return null;
    }

    public void applyStyle(Cstyle style, ICell kdCell) {
        this.applyStyle(new Cstyle[]{style}, kdCell);
    }

    public void applyStyle(Cstyle[] styles, ICell kdCell) {
        MyExecuteContext context = new MyExecuteContext();
        HashMap<Attribute, Object> map = new HashMap<Attribute, Object>();
        for (int index = 0; index < styles.length; ++index) {
            Cstyle.StyleItem[][] siss = styles[index].execute(context);
            for (int i = 0; i < siss.length; ++i) {
                if (siss[i] == null) continue;
                Cstyle.StyleItem[] sis = siss[i];
                for (int j = 0; j < sis.length; ++j) {
                    if (sis[j].getValue() == null) {
                        map.put(sis[j].getAttribute(), Boolean.TRUE);
                        continue;
                    }
                    map.put(sis[j].getAttribute(), sis[j].getValue());
                }
            }
        }
        this.apply(map, kdCell);
    }

    private void apply(Map map, ICell kdCell) {
        for (Map.Entry entry : map.entrySet()) {
            Attribute attr = (Attribute)entry.getKey();
            attr.apply(kdCell, entry.getValue());
        }
    }

    @Override
    public Styles.HorizontalAlignment getHorizontalAlignment() {
        return Styles.HorizontalAlignment.RIGHT;
    }

    public Object getContent() {
        return this.cell.getValue();
    }

    public String getFormatString() {
        return this.cell.getFormatString();
    }

    private class MyExecuteContext
    implements ExecuteContext {
        private MyExecuteContext() {
        }

        @Override
        public OlapModel getOlapModel() {
            return DataCellItem.this.model;
        }

        @Override
        public Object getValue() {
            return DataCellItem.this.getValue();
        }

        @Override
        public String getFormattedValue() {
            return DataCellItem.this.getFormattedValue();
        }

        @Override
        public Member[] getMembers() {
            return DataCellItem.this.getMemberContext();
        }
    }
}

