/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.cubemodel.designer.wizard.ui;

import com.kingdee.bos.ctrl.analysis.cubemodel.CubeModelResource;
import com.kingdee.bos.ctrl.analysis.cubemodel.designer.wizard.WizardContext;
import com.kingdee.bos.ctrl.common.layout.table.Cell;
import com.kingdee.bos.ctrl.common.layout.table.TableLayout;
import com.kingdee.bos.ctrl.common.ui.stepwizard.IWizardStep;
import com.kingdee.bos.ctrl.common.ui.stepwizard.WizardDialog;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDSeparator;
import com.kingdee.bos.ctrl.swing.KDTextArea;
import com.kingdee.bos.ctrl.swing.MessageDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public abstract class AbstractWizardStep
extends KDPanel
implements IWizardStep {
    protected WizardDialog.StepsManager manager;
    protected WizardContext context;
    protected IWizardStep oldNextStep;
    KDTextArea ta;

    public AbstractWizardStep(WizardContext context) {
        this.context = context;
    }

    public JComponent getContent() {
        return this;
    }

    public boolean isReturnable() {
        return true;
    }

    public void initStep(WizardDialog.StepsManager manager) {
        this.manager = manager;
    }

    public void intoThisStep(IWizardStep prevStep, boolean isOppose) {
        if (isOppose) {
            this.oldNextStep = prevStep;
        }
        this.manager.setFinishEnabled(this.enableFinish());
        this.manager.setNextStepEnabled(true);
        this.manager.setPreviousStepEnabled(true);
    }

    public void destroy(boolean isFinished) {
        if (isFinished) {
            this.context.put("Finish", Boolean.TRUE);
        }
    }

    protected boolean enableFinish() {
        Boolean bool = (Boolean)this.context.get("EnableFinish");
        return bool == null ? false : bool;
    }

    protected void alert(String message) {
        MessageDialog.show((Component)((Object)this), (Object)message, (String)CubeModelResource.getString(CubeModelResource.class, (String)"Information"), (int)-1);
    }

    protected KDPanel makeSubTitlePanel(String title) {
        KDPanel panel = new KDPanel();
        KDLabel label = new KDLabel(title);
        KDSeparator sp = new KDSeparator();
        TableLayout layout = TableLayout.split((int)2, (int)1);
        panel.setLayout((LayoutManager)layout);
        panel.add((Component)label, (Object)layout.cell(0));
        panel.add((Component)sp, (Object)layout.cell(1));
        return panel;
    }

    protected KDPanel makeDescPanel(String desc) {
        this.ta = new KDTextArea();
        if (desc != null) {
            this.ta.setText(desc);
        }
        this.ta.setEditable(false);
        this.ta.setBorder(null);
        this.ta.setFocusable(false);
        KDPanel panel = new KDPanel();
        panel.setBorder((Border)new TitledBorder(CubeModelResource.getString(CubeModelResource.class, (String)"Description")));
        panel.setLayout((LayoutManager)new BorderLayout());
        panel.add((Component)this.ta);
        return panel;
    }

    protected void setDesc(String desc) {
        if (this.ta != null) {
            this.ta.setText(desc);
        }
    }

    protected Cell layout(String subTitle, String desc) {
        TableLayout layout = TableLayout.split((int)3, (int)1);
        layout.rowStyle(0).lockHeight(40);
        layout.rowStyle(1).setPriY(1);
        if (desc != null) {
            layout.rowStyle(2).lockHeight(100);
        }
        this.setLayout((LayoutManager)layout);
        this.add((Component)this.makeSubTitlePanel(subTitle), layout.cell(0));
        if (desc != null) {
            this.add((Component)this.makeDescPanel(desc), layout.cell(2));
        }
        return layout.cell(1);
    }
}

