/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.cubemodel.designer.wizard.ui;

import com.kingdee.bos.ctrl.analysis.cubemodel.CubeModelResource;
import com.kingdee.bos.ctrl.analysis.cubemodel.designer.data.model.Column;
import com.kingdee.bos.ctrl.analysis.cubemodel.designer.data.model.Table;
import com.kingdee.bos.ctrl.analysis.cubemodel.designer.wizard.WizardContext;
import com.kingdee.bos.ctrl.analysis.cubemodel.designer.wizard.ui.AbstractWizardStep;
import com.kingdee.bos.ctrl.analysis.cubemodel.designer.wizard.ui.Dim_DefineFactTableJoin;
import com.kingdee.bos.ctrl.analysis.cubemodel.designer.wizard.ui.Dim_Finish;
import com.kingdee.bos.ctrl.analysis.cubemodel.designer.wizard.ui.property.PropertyPanel;
import com.kingdee.bos.ctrl.analysis.xmlutil.Names;
import com.kingdee.bos.ctrl.analysis.xmlutil.StringPair;
import com.kingdee.bos.ctrl.common.ui.stepwizard.IWizardStep;
import com.kingdee.bos.ctrl.common.ui.stepwizard.WizardDialog;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.res.Resource;
import com.kingdee.bos.ctrl.swing.DefaultKingdeeListCellRenderer;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDList;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;

public class Dim_Std_CreateLevel
extends AbstractWizardStep {
    Table table;
    private KDList listColumns = new KDList();
    private KDTable tableLevels;
    private KDLabelContainer lcColumns = new KDLabelContainer();
    private KDLabelContainer lcLevels = new KDLabelContainer();
    private KDWorkButton btnSelect;
    private KDWorkButton btnDelete;
    private KDWorkButton btnUp;
    private KDWorkButton btnDown;
    private KDComboBox cbKey = new KDComboBox();
    private KDComboBox cbName = new KDComboBox();
    private KDComboBox cbAlias = new KDComboBox();
    private KDComboBox cbOrderBy = new KDComboBox();
    private KDComboBox cbOrderMethod = new KDComboBox();
    private PropertyPanel pp = new PropertyPanel();
    private Map selectedColumn = new HashMap();
    private ActionListener selectAction = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            Dim_Std_CreateLevel.this.doSelect();
        }
    };
    private ActionListener deleteAction = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            Dim_Std_CreateLevel.this.doDelete();
        }
    };
    private ActionListener upAction = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            Dim_Std_CreateLevel.this.doUp();
        }
    };
    private ActionListener downAction = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            Dim_Std_CreateLevel.this.doDown();
        }
    };

    public Dim_Std_CreateLevel(WizardContext context) {
        super(context);
    }

    public IWizardStep outThisStep(boolean isOppose) {
        if (!isOppose) {
            WizardContext.LevelInfo levelInfo = this.getLevelResult();
            if (levelInfo == null) {
                return this;
            }
            this.context.put("LevelInfo", levelInfo);
            Table dtable = (Table)this.context.get("DimensionTable");
            Table ftable = (Table)this.context.get("FactTable");
            if (!dtable.equals(ftable)) {
                return new Dim_DefineFactTableJoin(this.context);
            }
            return new Dim_Finish(this.context);
        }
        return null;
    }

    @Override
    public void intoThisStep(IWizardStep prevStep, boolean isOppose) {
        super.intoThisStep(prevStep, isOppose);
        if (!isOppose && this.table == null) {
            this.table = (Table)this.context.get("DimensionTable");
            Column[] columns = this.table.getColumns();
            this.pp.setColumn(columns);
            for (int i = 0; i < columns.length; ++i) {
                this.cbKey.addItem((Object)columns[i]);
                this.cbName.addItem((Object)columns[i]);
                this.cbAlias.addItem((Object)columns[i]);
                this.cbOrderBy.addItem((Object)columns[i]);
                this.listColumns.addElement((Object)columns[i]);
            }
            WizardContext.LevelInfo levelInfo = (WizardContext.LevelInfo)this.context.get("LevelInfo");
            HashMap<String, Column> colMap = new HashMap<String, Column>();
            ListModel lm = this.listColumns.getModel();
            for (int j = 0; j < lm.getSize(); ++j) {
                Column col = (Column)lm.getElementAt(j);
                colMap.put(col.getName(), col);
            }
            if (levelInfo != null) {
                WizardContext.ALevel[] alevels = levelInfo.levels;
                int n = alevels.length;
                for (int i = 0; i < n; ++i) {
                    Column key = (Column)colMap.get(alevels[i].columnKey.getName());
                    this.selectedColumn.put(key, alevels[i].properties);
                    IRow row = this.tableLevels.addRow();
                    row.getCell(0).setValue((Object)alevels[i].name);
                    row.getCell(1).setValue((Object)alevels[i].alias);
                    row.getCell(2).setValue((Object)key);
                    row.getCell(3).setValue(colMap.get(alevels[i].columnName.getName()));
                    row.getCell(4).setValue(colMap.get(alevels[i].columnAlias.getName()));
                    StringPair sp = StringPair.getStringPair(alevels[i].orderMethod, Names.OrderMethods.getOrderMethods());
                    if (sp == null) {
                        sp = Names.OrderMethods.getEmptyOrderBy();
                    }
                    row.getCell(5).setValue((Object)sp);
                    row.getCell(6).setValue(colMap.get(alevels[i].orderBy));
                }
                this.tableLevels.getSelectManager().select(0, 0);
            }
        }
    }

    public WizardContext.LevelInfo getLevelResult() {
        int count = this.tableLevels.getRowCount();
        if (count == 0) {
            this.alert(CubeModelResource.getString(CubeModelResource.class, (String)"LevelNotNull"));
            return null;
        }
        if (!this.updateCurrentProperty()) {
            return null;
        }
        WizardContext.ALevel[] ret = new WizardContext.ALevel[count];
        for (int i = 0; i < count; ++i) {
            IRow row = this.tableLevels.getRow(i);
            String name = (String)row.getCell(0).getValue();
            String alias = (String)row.getCell(1).getValue();
            if (name == null || name.trim().length() == 0) {
                this.alert(CubeModelResource.getString(CubeModelResource.class, (String)"LevelNameNotNull"));
                return null;
            }
            if (alias == null || alias.trim().length() == 0) {
                this.alert(CubeModelResource.getString(CubeModelResource.class, (String)"LevelAliasNotNull"));
                return null;
            }
            Column columnKey = (Column)row.getCell(2).getValue();
            Column columnName = (Column)row.getCell(3).getValue();
            Column columnAlias = (Column)row.getCell(4).getValue();
            String orderMethod = ((StringPair)row.getCell(5).getValue()).getValue();
            Column orderCol = (Column)row.getCell(6).getValue();
            String orderBy = orderCol == null ? "" : orderCol.getName();
            ret[i] = new WizardContext.ALevel(name, alias, columnKey, columnName, columnAlias, orderBy, orderMethod);
            List list = (List)this.selectedColumn.get(columnKey);
            if (list == null) continue;
            ret[i].properties.addAll(list);
        }
        return new WizardContext.LevelInfo(ret);
    }

    private boolean updateCurrentProperty(int row) {
        Column c = (Column)this.tableLevels.getCell(row, 2).getValue();
        this.selectedColumn.put(c, Arrays.asList(this.pp.getProperties()));
        return this.pp.vertify();
    }

    private boolean updateCurrentProperty() {
        KDTSelectBlock b = this.tableLevels.getSelectManager().get();
        if (b != null) {
            return this.updateCurrentProperty(b.getTop());
        }
        return true;
    }

    private void showCurrentProperty() {
        KDTSelectBlock b = this.tableLevels.getSelectManager().get();
        if (b == null) {
            this.pp.setProperties((List)null);
        } else {
            this.showCurrentProperty(b.getTop());
        }
    }

    private void showCurrentProperty(int row) {
        List properties = (List)this.selectedColumn.get(this.tableLevels.getCell(row, 2).getValue());
        this.pp.setProperties(properties);
    }

    @Override
    public void initStep(WizardDialog.StepsManager manager) {
        super.initStep(manager);
        this.lcColumns.setBoundLabelText(CubeModelResource.getString(CubeModelResource.class, (String)"AvailableColumn1"));
        this.lcLevels.setBoundLabelText(CubeModelResource.getString(CubeModelResource.class, (String)"DimLevel"));
        this.lcColumns.setBoundLabelAlignment(8);
        this.lcLevels.setBoundLabelAlignment(8);
        this.btnSelect = new KDWorkButton((Icon)Resource.ICON_MOVE_LEFT);
        this.btnDelete = new KDWorkButton((Icon)Resource.ICON_MOVE_RIGHT);
        this.btnUp = new KDWorkButton((Icon)Resource.ICON_MOVE_TOP);
        this.btnDown = new KDWorkButton((Icon)Resource.ICON_MOVE_DOWN);
        this.tableLevels = new KDTable(7, 1, 0);
        this.listColumns.setAutoscrolls(true);
        this.tableLevels.setAutoscrolls(true);
        JScrollPane sp = new JScrollPane((Component)this.listColumns);
        this.lcColumns.setBoundEditor((JComponent)sp);
        this.lcLevels.setBoundEditor((JComponent)this.tableLevels);
        this.lcColumns.setMinimumSize(new Dimension(10, 10));
        this.lcLevels.setMinimumSize(new Dimension(10, 10));
        String desc = CubeModelResource.getString(CubeModelResource.class, (String)"DefineLevelDesc") + CubeModelResource.getString(CubeModelResource.class, (String)"DefineLevelDesc2") + CubeModelResource.getString(CubeModelResource.class, (String)"StepDesc11") + "\uff08" + CubeModelResource.getString(CubeModelResource.class, (String)"StepDesc12") + "/" + CubeModelResource.getString(CubeModelResource.class, (String)"StepDesc13") + "(" + CubeModelResource.getString(CubeModelResource.class, (String)"English") + ")\uff09" + CubeModelResource.getString(CubeModelResource.class, (String)"StepDesc14") + "Id" + CubeModelResource.getString(CubeModelResource.class, (String)"StepDesc15") + "(" + CubeModelResource.getString(CubeModelResource.class, (String)"StepDesc16") + "(" + CubeModelResource.getString(CubeModelResource.class, (String)"Chinese") + "))" + CubeModelResource.getString(CubeModelResource.class, (String)"StepDesc17") + CubeModelResource.getString(CubeModelResource.class, (String)"StepDesc18");
        com.kingdee.bos.ctrl.common.layout.table.Table tl = this.layout(CubeModelResource.getString(CubeModelResource.class, (String)"CreateLevel"), desc).split(1, 3);
        tl.colStyle(0).setWidth(-25);
        tl.colStyle(1).lockWidth(40);
        tl.colStyle(1).setMarginLeft(3);
        tl.colStyle(1).setMarginRight(5);
        tl.colStyle(2).setWidth(-85);
        this.add((Component)this.lcColumns, tl.cell(0));
        KDPanel btnPanel = new KDPanel();
        btnPanel.add((Component)new KDLabel(" "));
        btnPanel.add((Component)this.btnSelect);
        btnPanel.add((Component)this.btnDelete);
        btnPanel.add((Component)this.btnUp);
        btnPanel.add((Component)this.btnDown);
        this.add((Component)btnPanel, tl.cell(1));
        com.kingdee.bos.ctrl.common.layout.table.Table r = tl.cell(2).split(2, 1);
        this.lcLevels.setPreferredSize(new Dimension(200, 200));
        this.add((Component)this.lcLevels, r.cell(0));
        this.add((Component)((Object)this.pp), r.cell(1));
        IRow headRow = this.tableLevels.getHeadRow(0);
        headRow.getCell(0).setValue((Object)CubeModelResource.getString(CubeModelResource.class, (String)"LevelName"));
        headRow.getCell(1).setValue((Object)CubeModelResource.getString(CubeModelResource.class, (String)"LevelAlias"));
        headRow.getCell(2).setValue((Object)CubeModelResource.getString(CubeModelResource.class, (String)"MemberKey"));
        headRow.getCell(3).setValue((Object)CubeModelResource.getString(CubeModelResource.class, (String)"MemberName"));
        headRow.getCell(4).setValue((Object)CubeModelResource.getString(CubeModelResource.class, (String)"MemberAlias"));
        headRow.getCell(5).setValue((Object)"\u6392\u5e8f");
        headRow.getCell(6).setValue((Object)"\u6392\u5e8f\u5b57\u6bb5");
        this.tableLevels.getColumn(3).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)this.cbName));
        this.tableLevels.getColumn(4).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)this.cbAlias));
        this.tableLevels.getColumn(6).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)this.cbOrderBy));
        this.tableLevels.getColumn(5).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)this.cbOrderMethod));
        this.tableLevels.getColumn(0).setWidth(80);
        this.tableLevels.getColumn(0).setWidth(80);
        this.tableLevels.getColumn(2).setWidth(80);
        this.tableLevels.getColumn(3).setWidth(80);
        this.tableLevels.getColumn(4).setWidth(80);
        this.tableLevels.getColumn(5).setWidth(80);
        this.tableLevels.getColumn(6).setWidth(80);
        this.tableLevels.getColumn(2).getStyleAttributes().setLocked(true);
        this.tableLevels.getIndexColumn().getStyleAttributes().setHided(true);
        this.btnSelect.addActionListener(this.selectAction);
        this.btnDelete.addActionListener(this.deleteAction);
        this.btnUp.addActionListener(this.upAction);
        this.btnDown.addActionListener(this.downAction);
        this.cbOrderMethod.addItem((Object)Names.OrderMethods.getEmptyOrderBy());
        this.cbOrderMethod.addItems((Object[])Names.OrderMethods.getOrderMethods());
        this.tableLevels.addKDTEditListener(new KDTEditListener(){

            public void editStarting(KDTEditEvent e) {
            }

            public void editStarted(KDTEditEvent e) {
            }

            public void editValueChanged(KDTEditEvent e) {
                StringPair sp;
                if (e.getColIndex() == 5 && (sp = (StringPair)e.getValue()).getValue() == null) {
                    ICell cell = Dim_Std_CreateLevel.this.tableLevels.getCell(e.getRowIndex(), e.getColIndex() + 1);
                    cell.setValue((Object)"");
                    cell.getStyleAttributes().setLocked(true);
                }
            }

            public void editStopping(KDTEditEvent e) {
            }

            public void editStopped(KDTEditEvent e) {
            }

            public void editCanceled(KDTEditEvent e) {
            }
        });
        this.tableLevels.getSelectManager().addKDTSelectListener(new KDTSelectListener(){
            private int lastSelected = -1;

            public void tableSelectChanged(KDTSelectEvent e) {
                int r;
                KDTSelectBlock b = e.getSelectBlock();
                if (b != null && b.getTop() == this.lastSelected) {
                    return;
                }
                KDTSelectBlock old = e.getPrevSelectBlock();
                if (old != null && this.lastSelected == (r = old.getTop())) {
                    this.lastSelected = -1;
                    if (!Dim_Std_CreateLevel.this.updateCurrentProperty(r)) {
                        Dim_Std_CreateLevel.this.tableLevels.getSelectManager().select(r, 0);
                        return;
                    }
                }
                if (b != null && this.lastSelected != (r = b.getTop())) {
                    this.lastSelected = r;
                    Dim_Std_CreateLevel.this.showCurrentProperty(r);
                }
            }
        });
        this.listColumns.setCellRenderer((ListCellRenderer)new DefaultKingdeeListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component cp = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                boolean used = Dim_Std_CreateLevel.this.selectedColumn.containsKey(value);
                Color c = null;
                c = isSelected ? (used ? Color.GRAY.brighter() : Color.WHITE) : (used ? Color.RED.darker() : Color.BLACK);
                this.setForeground(c);
                return cp;
            }
        });
    }

    private void doSelect() {
        Object column = this.listColumns.getSelectedValue();
        if (column == null) {
            return;
        }
        if (this.selectedColumn.containsKey(column)) {
            this.alert(CubeModelResource.getString(CubeModelResource.class, (String)"ColumnDuplicate"));
            return;
        }
        this.selectedColumn.put(column, null);
        IRow row = this.tableLevels.addRow();
        row.getCell(0).setValue((Object)column.toString());
        row.getCell(1).setValue((Object)column.toString());
        row.getCell(2).setValue(column);
        row.getCell(3).setValue(column);
        row.getCell(4).setValue(column);
        row.getCell(5).setValue((Object)Names.OrderMethods.getEmptyOrderBy());
        row.getCell(6).setValue(column);
        this.tableLevels.getSelectManager().select(row.getRowIndex(), 0);
        this.listColumns.updateUI();
    }

    private void doDelete() {
        if (this.tableLevels.getSelectManager().get() != null) {
            int index = this.tableLevels.getSelectManager().get().getTop();
            IRow row = this.tableLevels.removeRow(index);
            this.selectedColumn.remove(row.getCell(2).getValue());
            this.listColumns.updateUI();
            this.showCurrentProperty();
        }
    }

    private void doUp() {
        if (this.tableLevels.getSelectManager().get() != null) {
            int index = this.tableLevels.getSelectManager().get().getTop();
            if (index == 0) {
                return;
            }
            IRow row = this.tableLevels.getRow(index);
            IRow upRow = this.tableLevels.getRow(index - 1);
            Object levelName = upRow.getCell(0).getValue();
            Object levelAlias = upRow.getCell(1).getValue();
            Object keyCol = upRow.getCell(2).getValue();
            Object nameCol = upRow.getCell(3).getValue();
            Object aliasCol = upRow.getCell(3).getValue();
            upRow.getCell(0).setValue(row.getCell(0).getValue());
            upRow.getCell(1).setValue(row.getCell(1).getValue());
            upRow.getCell(2).setValue(row.getCell(2).getValue());
            upRow.getCell(3).setValue(row.getCell(3).getValue());
            upRow.getCell(4).setValue(row.getCell(4).getValue());
            row.getCell(0).setValue(levelName);
            row.getCell(1).setValue(levelAlias);
            row.getCell(2).setValue(keyCol);
            row.getCell(3).setValue(nameCol);
            row.getCell(4).setValue(aliasCol);
            this.tableLevels.getSelectManager().select(index - 1, -1);
        }
    }

    private void doDown() {
        if (this.tableLevels.getSelectManager().get() != null) {
            int index = this.tableLevels.getSelectManager().get().getTop();
            if (index == this.tableLevels.getRowCount() - 1) {
                return;
            }
            IRow row = this.tableLevels.getRow(index);
            IRow downRow = this.tableLevels.getRow(index + 1);
            Object levelName = downRow.getCell(0).getValue();
            Object levelAlias = downRow.getCell(1).getValue();
            Object keyCol = downRow.getCell(2).getValue();
            Object nameCol = downRow.getCell(3).getValue();
            Object aliasCol = downRow.getCell(4).getValue();
            downRow.getCell(0).setValue(row.getCell(0).getValue());
            downRow.getCell(1).setValue(row.getCell(1).getValue());
            downRow.getCell(2).setValue(row.getCell(2).getValue());
            downRow.getCell(3).setValue(row.getCell(3).getValue());
            downRow.getCell(4).setValue(row.getCell(4).getValue());
            row.getCell(0).setValue(levelName);
            row.getCell(1).setValue(levelAlias);
            row.getCell(2).setValue(keyCol);
            row.getCell(3).setValue(nameCol);
            row.getCell(4).setValue(aliasCol);
            this.tableLevels.getSelectManager().select(index + 1, -1);
        }
    }
}

