/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.report.ui.style;

import com.kingdee.bos.ctrl.analysis.bicomponent.style.AttributeValue;
import com.kingdee.bos.ctrl.analysis.bicomponent.style.Cstyle;
import com.kingdee.bos.ctrl.analysis.report.ui.style.AttributeModel;
import com.kingdee.bos.ctrl.analysis.report.ui.style.IPropertyChangeListener;
import com.kingdee.bos.ctrl.analysis.report.ui.style.LabelValueBean;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.BeforeActionEvent;
import com.kingdee.bos.ctrl.kdf.table.event.BeforeActionListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDPanel;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JScrollBar;
import javax.swing.SwingUtilities;

public class DataStyleAttributePanel
extends KDPanel {
    private KDTable tbl = null;
    private AttributeModel am = new AttributeModel();
    private KDComboBox cbName = new KDComboBox();
    private IPropertyChangeListener pl = null;
    private String sampleStyleFontFamily = null;
    private int sampleStyleFontSize = 0;
    private static final int COL_ATTR = 0;
    private static final int COL_VALUE = 1;
    private static final int COL_SAMPLE = 2;
    private static Map colorMap = new HashMap();
    private ItemListener valueListener = new ItemListener(){

        @Override
        public void itemStateChanged(ItemEvent arg0) {
            DataStyleAttributePanel.this.setSampleStyle();
        }
    };

    DataStyleAttributePanel() {
        this.init();
    }

    private void init() {
        this.setLayout(new CardLayout());
        this.tbl = new KDTable(3, 1, 8);
        this.tbl.getLayoutManager().setVerticalScrollBar(new JScrollBar(1));
        this.tbl.getLayoutManager().setHorizonScrollBar(new JScrollBar(0));
        this.add((Component)this.tbl, "");
        IRow row = this.tbl.getHeadRow(0);
        row.getCell(0).setValue((Object)"\u5c5e\u6027");
        row.getCell(1).setValue((Object)"\u503c");
        row.getCell(2).setValue((Object)"\u793a\u4f8b");
        this.tbl.getColumn(0).setWidth(80);
        this.tbl.getColumn(1).setWidth(80);
        this.tbl.getColumn(2).setWidth(80);
        this.tbl.getMergeManager().mergeBlock(0, 2, this.tbl.getRowCount() - 1, 2);
        this.tbl.getCell(0, 2).setValue((Object)"\u793a\u4f8babc123");
        this.tbl.getCell(0, 2).getStyleAttributes().setLocked(true);
        this.tbl.setAfterAction(new BeforeActionListener(){

            public void beforeAction(BeforeActionEvent e) {
                DataStyleAttributePanel.this.setSampleStyle();
            }
        });
        this.tbl.getEditManager().addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editValueChanged(KDTEditEvent e) {
                DataStyleAttributePanel.this.changeValueList((LabelValueBean)e.getValue(), e.getRowIndex());
            }
        });
        this.sampleStyleFontSize = this.tbl.getCell(0, 2).getStyleAttributes().getFontSize();
        this.sampleStyleFontFamily = this.tbl.getCell(0, 2).getStyleAttributes().getFontName();
        int n = this.tbl.getRowCount();
        for (int i = 0; i < n; ++i) {
            this.tbl.getCell(i, 0).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)this.cbName));
            KDComboBox bb = new KDComboBox();
            this.tbl.getCell(i, 1).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)bb));
            bb.addItemListener(this.valueListener);
        }
        this.cbName.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent arg0) {
                KDTSelectBlock b = DataStyleAttributePanel.this.tbl.getSelectManager().get();
                if (b != null) {
                    int r = b.getTop();
                    DataStyleAttributePanel.this.changeValueList((LabelValueBean)arg0.getItem(), r);
                }
            }
        });
        this.loadInitAttribute();
        this.cbName.addItems(new Vector(this.am.getAttributeList()));
    }

    private void changeValueList(LabelValueBean attr, int r) {
        if (attr != null) {
            KDComboBox cb = (KDComboBox)((KDTDefaultCellEditor)this.tbl.getCell(r, 1).getEditor()).getComponent();
            List valueList = this.am.getValueList(attr);
            cb.removeAllItems();
            cb.addItems(new Vector(valueList));
            if (this.cbName.getSelectedItem() != null) {
                this.tbl.getCell(r, 1).setValue(cb.getItemAt(0));
            }
        }
    }

    public void setPropertyChangeListener(IPropertyChangeListener pl) {
        this.pl = pl;
    }

    private void setSampleStyle() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DataStyleAttributePanel.this.resetSampleStyle();
                int r = DataStyleAttributePanel.this.tbl.getRowCount();
                for (int i = 0; i < r; ++i) {
                    LabelValueBean attr = (LabelValueBean)DataStyleAttributePanel.this.tbl.getCell(i, 0).getValue();
                    LabelValueBean v = (LabelValueBean)DataStyleAttributePanel.this.tbl.getCell(i, 1).getValue();
                    if (attr == null || v == null) continue;
                    DataStyleAttributePanel.this.doSetSampleStyle((String)attr.getValue(), v.getValue());
                }
                if (DataStyleAttributePanel.this.pl != null) {
                    DataStyleAttributePanel.this.pl.propertyChanged();
                }
            }
        });
    }

    private void resetSampleStyle() {
        StyleAttributes sa = this.tbl.getCell(0, 2).getStyleAttributes();
        sa.setFontColor(Color.BLACK);
        sa.setFontSize(this.sampleStyleFontSize);
        sa.setItalic(false);
        sa.setUnderline(false);
        sa.setStrikeThrough(false);
        sa.setBold(false);
        sa.setRotation(0);
        sa.setFontName(this.sampleStyleFontFamily);
        sa.setBackground(Color.WHITE);
    }

    private void doSetSampleStyle(String name, Object v) {
        StyleAttributes sa = this.tbl.getCell(0, 2).getStyleAttributes();
        if ("Color".equals(name)) {
            sa.setFontColor((Color)v);
        } else if ("FontSize".equals(name)) {
            sa.setFontSize(((Integer)v).intValue());
        } else if ("Bold".equals(name)) {
            sa.setBold(((Boolean)v).booleanValue());
        } else if ("Italic".equals(name)) {
            sa.setItalic(((Boolean)v).booleanValue());
        } else if ("UnderLine".equals(name)) {
            sa.setUnderline(((Boolean)v).booleanValue());
        } else if ("ThroughLine".equals(name)) {
            sa.setStrikeThrough(((Boolean)v).booleanValue());
        } else if ("Rotation".equals(name)) {
            sa.setRotation(((Integer)v).intValue());
        } else if ("FontName".equals(name)) {
            sa.setFontName((String)v);
        } else if ("BackGround".equals(name)) {
            sa.setBackground((Color)v);
        }
    }

    private void loadInitAttribute() {
        List<Object> colorList = Arrays.asList(new LabelValueBean("\u7ea2\u8272", Color.RED), new LabelValueBean("\u767d\u8272", Color.WHITE), new LabelValueBean("\u9ed1\u8272", Color.BLACK), new LabelValueBean("\u84dd\u8272", Color.BLUE), new LabelValueBean("\u7eff\u8272", Color.GREEN), new LabelValueBean("\u6de1\u7070\u8272", Color.LIGHT_GRAY), new LabelValueBean("\u7070\u8272", Color.GRAY), new LabelValueBean("\u6df1\u7070\u8272", Color.DARK_GRAY), new LabelValueBean("\u7c89\u7ea2\u8272", Color.PINK), new LabelValueBean("\u6854\u9ec4\u8272", Color.ORANGE), new LabelValueBean("\u9ec4\u8272", Color.YELLOW), new LabelValueBean("\u7ea2\u7d2b\u8272", Color.MAGENTA), new LabelValueBean("\u9752\u8272", Color.CYAN));
        String[] fontList = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        ArrayList<LabelValueBean> fontNameList = new ArrayList<LabelValueBean>();
        int n = fontList.length;
        for (int i = 0; i < n; ++i) {
            fontNameList.add(new LabelValueBean(fontList[i], fontList[i]));
        }
        this.am.addItem(new LabelValueBean("\u5b57\u4f53\u540d\u79f0", "FontName"), fontNameList);
        this.am.addItem(new LabelValueBean("\u5b57\u4f53\u5927\u5c0f", "FontSize"), Arrays.asList(new LabelValueBean("8", new Integer(8)), new LabelValueBean("9", new Integer(9)), new LabelValueBean("10", new Integer(10)), new LabelValueBean("11", new Integer(11)), new LabelValueBean("12", new Integer(12)), new LabelValueBean("13", new Integer(13)), new LabelValueBean("14", new Integer(14)), new LabelValueBean("15", new Integer(15)), new LabelValueBean("16", new Integer(16))));
        this.am.addItem(new LabelValueBean("\u5b57\u4f53\u989c\u8272", "Color"), colorList);
        this.am.addItem(new LabelValueBean("\u80cc\u666f\u989c\u8272", "BackGround"), colorList);
        this.am.addItem(new LabelValueBean("\u7c97\u4f53", "Bold"), Arrays.asList(new LabelValueBean("\u662f", Boolean.TRUE), new LabelValueBean("\u5426", Boolean.FALSE)));
        this.am.addItem(new LabelValueBean("\u659c\u4f53", "Italic"), Arrays.asList(new LabelValueBean("\u662f", Boolean.TRUE), new LabelValueBean("\u5426", Boolean.FALSE)));
        this.am.addItem(new LabelValueBean("\u4e0b\u5212\u7ebf", "UnderLine"), Arrays.asList(new LabelValueBean("\u662f", Boolean.TRUE), new LabelValueBean("\u5426", Boolean.FALSE)));
        this.am.addItem(new LabelValueBean("\u5220\u9664\u7ebf", "ThroughLine"), Arrays.asList(new LabelValueBean("\u662f", Boolean.TRUE), new LabelValueBean("\u5426", Boolean.FALSE)));
        this.am.addItem(new LabelValueBean("\u65cb\u8f6c", "Rotation"), Arrays.asList(new LabelValueBean("0\u5ea6", new Integer(0)), new LabelValueBean("\u987a\u65f6\u948845\u5ea6", new Integer(45)), new LabelValueBean("\u987a\u65f6\u948890\u5ea6", new Integer(90)), new LabelValueBean("\u9006\u65f6\u948845\u5ea6", new Integer(-45)), new LabelValueBean("\u9006\u65f6\u948890\u5ea6", new Integer(-90))));
    }

    public void setAttributeStyleItems(List list) {
        Cstyle.StyleItem si = null;
        LabelValueBean lvb = null;
        block0: for (int i = 0; list != null && i < list.size(); ++i) {
            si = (Cstyle.StyleItem)list.get(i);
            IRow row = this.tbl.getRow(i);
            KDComboBox cb = (KDComboBox)row.getCell(0).getEditor().getComponent();
            String name = si.getAttribute().getName().toLowerCase(Locale.ENGLISH);
            for (int j = 0; j < cb.getItemCount(); ++j) {
                lvb = (LabelValueBean)cb.getItemAt(j);
                if (lvb == null || !name.equals(String.valueOf(lvb.getValue()).toLowerCase(Locale.ENGLISH))) continue;
                row.getCell(0).setValue((Object)lvb);
                this.changeValueList(lvb, i);
                break;
            }
            cb = (KDComboBox)row.getCell(1).getEditor().getComponent();
            String value = ((AttributeValue)si.getValue()).getValue().toString().toLowerCase(Locale.ENGLISH);
            if ("fontname".equals(name)) {
                int n = value.length();
                if (value.charAt(0) == '\'' && value.charAt(n - 1) == '\'') {
                    value = value.substring(1, n - 1);
                }
            }
            for (int j = 0; j < cb.getItemCount(); ++j) {
                lvb = (LabelValueBean)cb.getItemAt(j);
                if (lvb == null || !value.equals(String.valueOf(lvb.getValue()).toLowerCase(Locale.ENGLISH))) continue;
                row.getCell(1).setValue((Object)lvb);
                continue block0;
            }
        }
    }

    public String getAttributeScript() {
        StringBuilder sb = new StringBuilder();
        int r = this.tbl.getRowCount();
        for (int i = 0; i < r; ++i) {
            LabelValueBean attr = (LabelValueBean)this.tbl.getCell(i, 0).getValue();
            LabelValueBean v = (LabelValueBean)this.tbl.getCell(i, 1).getValue();
            if (attr == null || v == null) continue;
            Object vv = v.getValue();
            if (vv instanceof Color) {
                Color c = (Color)vv;
                vv = colorMap.containsKey(vv) ? colorMap.get(vv) : "RGB(" + c.getRed() + "," + c.getGreen() + "," + c.getBlue() + ")";
            } else if ("fontname".equals(((String)attr.getValue()).toLowerCase(Locale.ENGLISH))) {
                vv = "'" + vv + "'";
            }
            sb.append(attr.getValue()).append(":").append(vv).append(",");
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
            return "(" + sb.toString() + ")";
        }
        return "";
    }

    public void clear() {
        int n = this.tbl.getRowCount();
        for (int i = 0; i < n; ++i) {
            int k = this.tbl.getColumnCount() - 1;
            for (int j = 0; j < k; ++j) {
                this.tbl.getCell(i, j).setValue(null);
            }
        }
        this.resetSampleStyle();
    }

    static {
        colorMap.put(Color.RED, "RED");
        colorMap.put(Color.WHITE, "WHITE");
        colorMap.put(Color.BLACK, "BLACK");
        colorMap.put(Color.BLUE, "BLUE");
        colorMap.put(Color.GREEN, "GREEN");
        colorMap.put(Color.LIGHT_GRAY, "LIGHT_GRAY");
        colorMap.put(Color.GRAY, "GRAY");
        colorMap.put(Color.DARK_GRAY, "DARK_GRAY");
        colorMap.put(Color.PINK, "PINK");
        colorMap.put(Color.ORANGE, "ORANGE");
        colorMap.put(Color.YELLOW, "YELLOW");
        colorMap.put(Color.MAGENTA, "MAGENTA");
        colorMap.put(Color.CYAN, "CYAN");
    }
}

