/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.report.ui.style;

import com.kingdee.bos.ctrl.analysis.bicomponent.BIComponentResource;
import com.kingdee.bos.ctrl.analysis.bicomponent.OlapModelUtil;
import com.kingdee.bos.ctrl.analysis.olap.AxisMembersHelper;
import com.kingdee.bos.ctrl.analysis.olap.Hierarchy;
import com.kingdee.bos.ctrl.analysis.olap.Member;
import com.kingdee.bos.ctrl.analysis.olap.MemberTree;
import com.kingdee.bos.ctrl.analysis.olap.OlapModel;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.NonIcon;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;

public class HierarchyTreeModel
extends DefaultTreeModel
implements TreeModel {
    private Hierarchy hierarchy;
    private OlapModel model;
    DefaultKingdeeTreeNode visibleMembersFolderNode;
    DefaultKingdeeTreeNode hierarchyFolderNode;
    DefaultKingdeeTreeNode calculateFolderNode;

    public HierarchyTreeModel(OlapModel model, Hierarchy hie) {
        super(null, true);
        this.hierarchy = hie;
        this.model = model;
        this.setRoot(this.createRoot(this.hierarchy));
        this.expandRoot();
    }

    private TreeNode createRoot(Hierarchy hierarchy) {
        this.root = new DefaultKingdeeTreeNode((Object)hierarchy);
        ((DefaultKingdeeTreeNode)this.root).setText(hierarchy.getLabel());
        this.visibleMembersFolderNode = new DefaultKingdeeTreeNode((Object)"\u53ef\u89c1\u6210\u5458");
        this.hierarchyFolderNode = new DefaultKingdeeTreeNode((Object)"\u7ef4\u5ea6\u7ed3\u6784");
        ((DefaultKingdeeTreeNode)this.root).add((MutableTreeNode)this.visibleMembersFolderNode);
        ((DefaultKingdeeTreeNode)this.root).add((MutableTreeNode)this.hierarchyFolderNode);
        return this.root;
    }

    private void expandRoot() {
        this.expandVisibleMembers();
        this.expandHierarchy();
    }

    private void expandVisibleMembers() {
        AxisMembersHelper amh = (AxisMembersHelper)this.model.getExtension("axisMembersHelper");
        List list = amh.findVisibleMembers(this.hierarchy);
        if (list != null) {
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                this.visibleMembersFolderNode.add((MutableTreeNode)this.createMemberNode((Member)iter.next(), false));
            }
        }
    }

    private void expandHierarchy() {
        int i;
        Member[] members = this.getMemberTree().getRootMembers(this.hierarchy);
        ArrayList<Member> calMemberList = new ArrayList<Member>();
        for (i = 0; i < members.length; ++i) {
            if (members[i].isCalculated()) {
                calMemberList.add(members[i]);
                continue;
            }
            this.hierarchyFolderNode.add((MutableTreeNode)this.createMemberNode(members[i], true));
        }
        this.hierarchyFolderNode.add((MutableTreeNode)this.createCalculateFolder());
        for (i = 0; i < calMemberList.size(); ++i) {
            this.calculateFolderNode.add((MutableTreeNode)this.createMemberNode((Member)calMemberList.get(i), false));
        }
    }

    private MemberTree getMemberTree() {
        return OlapModelUtil.getMemberTree(this.model);
    }

    private DefaultKingdeeTreeNode createCalculateFolder() {
        this.calculateFolderNode = new DefaultKingdeeTreeNode((Object)BIComponentResource.getString(BIComponentResource.class, (String)"CalMember"));
        return this.calculateFolderNode;
    }

    private DefaultKingdeeTreeNode createMemberNode(Member member, boolean children) {
        DefaultKingdeeTreeNode node = new DefaultKingdeeTreeNode((Object)member);
        node.setText(member.getLabel());
        if (children) {
            node.setAllowsChildren(OlapModelUtil.getMemberTree(this.model).hasChildren(member));
        } else {
            node.setAllowsChildren(false);
        }
        node.setCustomIcon((Icon)NonIcon.getInstance());
        return node;
    }
}

