/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.web.dashboard;

import com.kingdee.bos.ctrl.analysis.web.ajax.Constants;
import com.kingdee.bos.ctrl.analysis.web.dashboard.DashBoard;
import com.kingdee.bos.ctrl.analysis.web.dashboard.DashBoardException;
import com.kingdee.bos.ctrl.analysis.web.dashboard.DashBoardPage;
import com.kingdee.bos.ctrl.analysis.web.permission.BIPermission_EAS;
import com.kingdee.bos.ctrl.analysis.web.repository.Repository;
import com.kingdee.bos.ctrl.analysis.web.solution.BISystem;
import com.kingdee.bos.ctrl.analysis.web.solution.util.IDGenerator;
import com.kingdee.bos.ctrl.common.util.CommonLogger;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.dom4j.DocumentException;

public class DashBoardPageManager {
    public static final String DASHBOARD_PATH = "dashboard_path";
    private static final Logger log = CommonLogger.getLogger(DashBoardPageManager.class);
    private static Map map = new HashMap();

    static DashBoardPage create(HttpServletRequest request, HttpServletResponse response) throws DashBoardException {
        String path = request.getParameter(DASHBOARD_PATH);
        String from = request.getParameter("from");
        String dashboardXML = "";
        try (Repository rep = null;){
            String itemID;
            BIPermission_EAS permission;
            rep = BISystem.getRepository(request);
            if (BISystem.isEAS() && !"portlet".equals(from) && !(permission = new BIPermission_EAS(BISystem.getContext(request))).hasDataPermission(Constants.PERMISSION_NAME_DASHBOARD_CONFIG, itemID = rep.getNodePropertyByPath("DBD", path, "permissionID"))) {
                throw new DashBoardException("\u5bf9\u4e0d\u8d77\uff0c\u60a8\u65e0\u6743\u9650\u6253\u5f00\u6b64\u4eea\u8868\u677f!");
            }
            dashboardXML = rep.getDashboardXML(path);
            log.info((Object)("DashboardURL: " + DashBoardPageManager.getDashboardAccessURL(path, request)));
        }
        return DashBoardPageManager.create(dashboardXML);
    }

    static DashBoardPage create(String dashboardXML) throws DashBoardException {
        DashBoard board = null;
        try {
            board = new DashBoard(dashboardXML);
        }
        catch (DocumentException e) {
            throw new DashBoardException(e);
        }
        String pageId = IDGenerator.getID();
        DashBoardPage page = new DashBoardPage(pageId, board);
        map.put(pageId, page);
        return page;
    }

    static DashBoardPage get(String pageId) {
        return (DashBoardPage)map.get(pageId);
    }

    private static String getDashboardAccessURL(String path, HttpServletRequest request) {
        StringBuffer sb = new StringBuffer();
        String ctxPath = request.getContextPath();
        sb.append("http://");
        sb.append(request.getServerName());
        sb.append(":" + request.getServerPort());
        sb.append(ctxPath);
        sb.append("/biweb/dashboard/show_dashboard.htm?requestType=get&url=");
        sb.append(request.getRequestURL());
        sb.append("?");
        sb.append("servletType");
        sb.append("=");
        sb.append("BIDashBoard");
        sb.append("&");
        sb.append(DASHBOARD_PATH);
        sb.append("=");
        sb.append(path);
        return sb.toString();
    }
}

