/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.web.dashboard;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.analysis.web.dashboard.DashBoardException;
import com.kingdee.bos.ctrl.analysis.web.solution.AbstractVarProvider;
import com.kingdee.bos.ctrl.analysis.web.solution.BISystem;
import com.kingdee.bos.ctrl.analysis.web.solution.ScriptSQL;
import com.kingdee.bos.ctrl.analysis.web.solution.exception.BIReportException;
import com.kingdee.bos.ctrl.analysis.web.variant.BaseVarProvider;
import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.util.db.SQLUtils;
import java.lang.reflect.UndeclaredThrowableException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class SQLUtil {
    private static final Logger logger = CommonLogger.getLogger(SQLUtil.class);

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object handleResultSet(HttpServletRequest req, String datacenter, String sql, ResultSetHandler handler, String errorMessage) throws BIReportException {
        Object object;
        Connection con = null;
        PreparedStatement pst = null;
        ResultSet rs = null;
        try {
            Context ctx = BISystem.getContext(req);
            con = BISystem.getJdbcConnection(ctx, datacenter);
            sql = SQLUtil.transSystemVar(req, sql);
            pst = con.prepareStatement(sql);
            rs = pst.executeQuery();
            object = handler.handle(rs);
        }
        catch (SQLException e) {
            try {
                logger.warn((Object)e.getMessage(), (Throwable)e);
                throw new DashBoardException("\u6267\u884csql\u51fa\u9519\uff1a" + e.getMessage(), e);
                catch (UndeclaredThrowableException e2) {
                    logger.warn((Object)e2.getMessage(), (Throwable)e2);
                    if (errorMessage == null) {
                        errorMessage = "SQL\u6267\u884c\u9519\u8bef\u3002" + e2.getMessage();
                    }
                    throw new DashBoardException(errorMessage, e2);
                }
                catch (Exception e3) {
                    logger.warn((Object)e3.getMessage(), (Throwable)e3);
                    throw new DashBoardException("\u6267\u884csql\u51fa\u9519\uff1a" + e3.getMessage(), e3);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pst, con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pst, (Connection)con);
        return object;
    }

    public static List getColumns(HttpServletRequest req, String datacenter, String sql) throws BIReportException {
        Matcher m = Pattern.compile("(.*)(\\sorder\\sby.*)", 2).matcher(sql);
        String orderbyClause = "";
        if (m.find()) {
            sql = m.group(1);
            orderbyClause = m.group(2);
        }
        sql = SQLUtil.transSystemVar(req, sql);
        sql = "select top 1 * from (" + sql + ") as JSBHJKBSWNB" + orderbyClause;
        return (List)SQLUtil.handleResultSet(req, datacenter, sql, new ResultSetHandler(){

            @Override
            public Object handle(ResultSet rs) throws SQLException {
                ArrayList<String> list = new ArrayList<String>();
                int columnCount = rs.getMetaData().getColumnCount();
                for (int i = 1; i <= columnCount; ++i) {
                    ResultSetMetaData md = rs.getMetaData();
                    list.add("({name:\"" + md.getColumnName(i) + "\", type:\"" + md.getColumnTypeName(i) + "\"})");
                }
                return list;
            }
        }, "\u6267\u884cSQL\u51fa\u9519\uff0c\u65e0\u6cd5\u83b7\u53d6\u6570\u636e\u8868\u7684\u5217\u540d");
    }

    public static List getSampleResult(HttpServletRequest req, String datacenter, String sql) throws BIReportException {
        Matcher m = Pattern.compile("(.*)(\\sorder\\sby.*)", 2).matcher(sql);
        String orderbyClause = "";
        if (m.find()) {
            sql = m.group(1);
            orderbyClause = m.group(2);
        }
        sql = SQLUtil.transSystemVar(req, sql);
        sql = "select top 5 * from (" + sql + ") as ASDSHJBVNBHW" + orderbyClause;
        return (List)SQLUtil.handleResultSet(req, datacenter, sql, new ResultSetHandler(){

            @Override
            public Object handle(ResultSet rs) throws SQLException {
                ArrayList list = new ArrayList();
                int columnCount = rs.getMetaData().getColumnCount();
                ArrayList<String> head = new ArrayList<String>();
                for (int i = 1; i <= columnCount; ++i) {
                    head.add(rs.getMetaData().getColumnName(i));
                }
                list.add(head);
                while (rs.next()) {
                    ArrayList<Object> row = new ArrayList<Object>();
                    for (int i = 1; i <= columnCount; ++i) {
                        row.add(rs.getObject(i));
                    }
                    list.add(row);
                }
                return list;
            }
        }, "\u6267\u884cSQL\u51fa\u9519\uff0c\u9884\u89c8\u5931\u8d25");
    }

    public static int getRowConut(HttpServletRequest req, String datacenter, String sql, String whereClause) throws BIReportException {
        Matcher m = Pattern.compile("(.*)(\\sorder\\sby.*)", 2).matcher(sql);
        if (m.find()) {
            sql = m.group(1);
        }
        sql = SQLUtil.transSystemVar(req, sql);
        sql = "select count(*) as count from (" + sql + ") as WDAWUQINSN " + whereClause;
        return ((Number)SQLUtil.handleResultSet(req, datacenter, sql, new ResultSetHandler(){

            @Override
            public Object handle(ResultSet rs) throws SQLException {
                rs.next();
                return rs.getObject(1);
            }
        }, "\u6267\u884cSQL\u51fa\u9519\uff0c\u83b7\u53d6\u603b\u884c\u6570\u5931\u8d25,\u8bf7\u68c0\u67e5\u6b64\u8fc7\u6ee4\u6761\u4ef6\u662f\u5426\u6b63\u786e\uff1a" + whereClause)).intValue();
    }

    public static int getRowConut(HttpServletRequest req, String datacenter, String sql) throws BIReportException {
        return SQLUtil.getRowConut(req, datacenter, sql, "");
    }

    public static String transSystemVar(HttpServletRequest req, String sql) {
        try {
            BaseVarProvider varProvider = new BaseVarProvider(BISystem.getContext(req));
            sql = new ScriptSQL().transSql(sql, (AbstractVarProvider)varProvider, null, null);
        }
        catch (BIReportException e) {
            e.printStackTrace();
        }
        return sql;
    }

    public static interface ResultSetHandler {
        public Object handle(ResultSet var1) throws SQLException;
    }
}

