/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.web.dashboard.dial;

import com.kingdee.bos.ctrl.analysis.web.ajax.json.JSON;
import com.kingdee.bos.ctrl.analysis.web.ajax.json.JSONMap;
import com.kingdee.bos.ctrl.analysis.web.dashboard.DashBoardException;
import com.kingdee.bos.ctrl.analysis.web.dashboard.DataSource;
import com.kingdee.bos.ctrl.analysis.web.dashboard.chart.ChartConfig;
import com.kingdee.bos.ctrl.analysis.web.dashboard.dial.Dial;
import com.kingdee.bos.ctrl.analysis.web.solution.exception.BIReportException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

public class ChartDial
implements Dial {
    private final String id;
    private final DataSource ds;
    private final String chartType;
    private final String[] xs;
    private final String[] ys;
    private final String[] measures;
    private final String title;
    private final boolean isShowTitle;
    private final String name;
    private final int DEFAULT_CHART_WIDTH = 400;
    private final int DEFAULT_CHART_HEIGHT = 300;
    private int width;
    private int height;

    public ChartDial(String id, DataSource ds, String chartType, String[] xs, String[] ys, String[] measures, String title, boolean isShowTitle, String name) {
        this.id = id;
        this.ds = ds;
        this.chartType = chartType;
        this.xs = xs;
        this.ys = ys;
        this.measures = measures;
        this.title = title;
        this.isShowTitle = isShowTitle;
        this.name = name;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String getType() {
        return "chart";
    }

    @Override
    public boolean isShowTitle() {
        return this.isShowTitle;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public JSON init(HttpServletRequest req) throws BIReportException {
        String width = req.getParameter("width");
        this.width = width == null ? 400 : Integer.parseInt(width);
        String height = req.getParameter("height");
        int n = this.height = height == null ? 300 : Integer.parseInt(height);
        if (this.isShowTitle) {
            this.height -= 20;
        }
        return this.toJSON(req);
    }

    public JSON refresh(HttpServletRequest req) throws BIReportException {
        return this.toJSON(req);
    }

    @Override
    public JSON toJSON(final HttpServletRequest req) throws BIReportException {
        String[] filter = req.getParameterValues("filter");
        final List<String> filterList = filter != null ? Arrays.asList(filter) : null;
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", this.getId());
        map.put("type", this.getType());
        map.put("chartType", this.chartType);
        map.put("isShowTitle", new Boolean(this.isShowTitle));
        map.put("title", this.title);
        map.put("name", this.name);
        map.put("isOverflow", new Boolean(this.ds.isOverflow(req, filterList)));
        if (req != null) {
            if (this.ds == null) {
                throw new DashBoardException("\u627e\u4e0d\u5230\u56fe\u8868\u7ed1\u5b9a\u7684\u6570\u636e\u6e90\u3002\u53ef\u80fd\u56fe\u8868\u5c1a\u672a\u7ed1\u5b9a\u6570\u636e\u6e90\u6216\u8005\u8be5\u6570\u636e\u6e90\u5df2\u7ecf\u88ab\u5220\u9664");
            }
            map.put("src", this.ds.getChartSrc(new ChartConfig(){

                @Override
                public DataSource getDataSource() {
                    return ChartDial.this.ds;
                }

                @Override
                public HttpServletRequest getRequest() {
                    return req;
                }

                @Override
                public String getType() {
                    return ChartDial.this.chartType;
                }

                @Override
                public List getFilterList() {
                    return filterList;
                }

                @Override
                public String[] getXColumns() {
                    return ChartDial.this.xs;
                }

                @Override
                public String[] getYColumns() {
                    return ChartDial.this.ys;
                }

                @Override
                public String[] getMeasureColumns() {
                    return ChartDial.this.measures;
                }

                @Override
                public int getWidth() {
                    return ChartDial.this.width;
                }

                @Override
                public int getHeight() {
                    return ChartDial.this.height;
                }
            }));
        }
        return new JSONMap(map);
    }

    @Override
    public String getScript() {
        return "";
    }

    @Override
    public void setScript(String script) {
    }
}

