/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.web.ext.mp.service;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.analysis.web.ext.mp.vo.SubSystemNodeVO;
import com.kingdee.bos.ctrl.analysis.web.ext.util.IDMaker;
import com.kingdee.bos.ctrl.analysis.web.solution.BISystem;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import java.lang.reflect.Method;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;

public class SubSystemService {
    private static final String RESPONSE_CLASS = "com.kingdee.eas.rpts.ctrlreport.model.CommonTreeModel";
    private static final String RESPONSE_METHOD = "getPackageTreeModel";

    public static SubSystemNodeVO getPackageTreeModel(HttpServletRequest request) throws Exception {
        Method method = Class.forName(RESPONSE_CLASS).getDeclaredMethod(RESPONSE_METHOD, Context.class);
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)method.invoke(null, BISystem.getContext(request));
        SubSystemNodeVO sSNode = new SubSystemNodeVO();
        sSNode.setName(root.getText());
        sSNode.setPid(null);
        SubSystemService.convert2SubSystemNode(sSNode, root);
        return sSNode;
    }

    private static void convert2SubSystemNode(SubSystemNodeVO sSNode, DefaultKingdeeTreeNode dNode) {
        Enumeration enu = dNode.children();
        while (enu.hasMoreElements()) {
            DefaultKingdeeTreeNode iNode = (DefaultKingdeeTreeNode)enu.nextElement();
            SubSystemNodeVO node = new SubSystemNodeVO();
            node.setId(IDMaker.getUUID());
            node.setName(iNode.getText());
            node.setPid(sSNode.getName());
            node.setLeaf(iNode.isLeaf());
            sSNode.addChild(node);
            SubSystemService.convert2SubSystemNode(node, iNode);
        }
        if (sSNode.getPid() != null) {
            SubSystemService.addExtReportNode(sSNode);
        }
    }

    private static void addExtReportNode(SubSystemNodeVO sSNode) {
        SubSystemNodeVO node = new SubSystemNodeVO();
        node.setId(IDMaker.getUUID());
        node.setName("\u6a21\u677f");
        node.setPid(sSNode.getName());
        node.setLeaf(true);
        node.setNodeType(2);
        sSNode.setLeaf(false);
        sSNode.setNodeType(1);
        sSNode.addChild(node);
    }
}

