/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.web.solution.tree;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.analysis.web.ajax.Constants;
import com.kingdee.bos.ctrl.analysis.web.bimreport.BIMFactory;
import com.kingdee.bos.ctrl.analysis.web.bimreport.BIMReportNode;
import com.kingdee.bos.ctrl.analysis.web.permission.BIPermission_EAS;
import com.kingdee.bos.ctrl.analysis.web.permission.MetaData_EAS;
import com.kingdee.bos.ctrl.analysis.web.piece.PieceUtil;
import com.kingdee.bos.ctrl.analysis.web.repository.Repository;
import com.kingdee.bos.ctrl.analysis.web.solution.BISolution;
import com.kingdee.bos.ctrl.analysis.web.solution.BISystem;
import com.kingdee.bos.ctrl.analysis.web.solution.exception.BIReportException;
import com.kingdee.bos.ctrl.analysis.web.solution.tree.BIReportTreeNode;
import com.kingdee.bos.ctrl.analysis.web.solution.tree.BIReportTreeNode_EAS;
import com.kingdee.bos.ctrl.analysis.web.solution.tree.BITreeNode;
import com.kingdee.bos.ctrl.analysis.web.solution.tree.DashboardTreeNode;
import com.kingdee.bos.ctrl.analysis.web.solution.tree.KPITreeNode;
import com.kingdee.bos.ctrl.analysis.web.solution.tree.RepositoryTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.util.app.ContextUtil;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import javax.servlet.http.HttpServletRequest;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;

public class BITreeUtil {
    private static final String FieldSeperator = "\u0001";
    private static final String RecordSeperator = "\u0002";

    public static TreeModel getReportTree(int treeType, String solution_path, String subjects_path) throws BIReportException {
        BISystem.initSolutionByFile(solution_path, subjects_path);
        BISolution solution = BISystem.getSolution();
        return solution.getBITree(treeType, null, null);
    }

    public static String createNewNode(String caption, String id, String path, boolean isFolder) {
        StringBuffer sb = new StringBuffer();
        sb.append(caption);
        sb.append(",");
        sb.append(id);
        sb.append(",");
        sb.append(path);
        sb.append(",");
        sb.append(isFolder ? "true" : "false");
        return sb.toString();
    }

    public static String createViewRecord(int treeType, Repository rep, String repPath, HttpServletRequest req) throws BIReportException {
        String rootPath;
        if (treeType == -1) {
            throw new BIReportException("\u672a\u77e5\u6811\u7c7b\u578b" + treeType);
        }
        StringBuffer sb = new StringBuffer();
        String id = "";
        if (treeType == 6) {
            rootPath = "report_tree";
            id = "RPT\u0001" + rootPath + FieldSeperator + rootPath + (repPath.equals("") ? "" : "/" + repPath);
            sb.append("\u540d\u79f0\u0001\u62a5\u8868\u8def\u5f84\u0001\u6570\u636e\u4e2d\u5fc3\u0001Portlet\u0001\u521b\u5efa\u8005\u0001\u4fee\u6539\u8005\u0001\u4fee\u6539\u65f6\u95f4");
        } else if (treeType == 5) {
            rootPath = "dashboard_tree";
            id = "DBD\u0001" + rootPath + FieldSeperator + rootPath + (repPath.equals("") ? "" : "/" + repPath);
            sb.append("\u540d\u79f0\u0001Portlet\u0001\u521b\u5efa\u8005\u0001\u4fee\u6539\u8005\u0001\u4fee\u6539\u65f6\u95f4");
        }
        TreeNode node = (TreeNode)BITreeUtil.getNodeByID(treeType, id, rep, req);
        int nChildCount = 0;
        if (node != null) {
            nChildCount = node.getChildCount();
        }
        BIPermission_EAS permission = new BIPermission_EAS(BISystem.getContext(req));
        boolean dsbUseView = BISystem.isDsbPerUseView(req);
        for (int i = 0; i < nChildCount; ++i) {
            boolean isFolder;
            BITreeNode childNode = (BITreeNode)node.getChildAt(i);
            boolean bl = isFolder = !BITreeUtil.isLeaf(childNode);
            if (childNode == null || treeType == 5 && dsbUseView && !BITreeUtil.hasDatapermission(req, childNode) && !isFolder) continue;
            String nodePath = ((RepositoryTreeNode)childNode).getRelativePath();
            String caption = childNode.getPropertyValue("caption");
            String displayName = caption == null ? childNode.toString() : caption;
            String captionPath = childNode.getPropertyValue("captionPath");
            sb.append(RecordSeperator);
            sb.append("{");
            sb.append("isFolder:" + (isFolder ? "true" : "false") + ",");
            sb.append("path:'" + nodePath + "',");
            sb.append("themeReportType:'");
            if (isFolder) {
                sb.append("folder");
                sb.append("',isThemeAnalysFolder:'" + (treeType == 6 ? "true" : "false"));
            } else if (treeType == 6) {
                String themeReportType = childNode.getPropertyValue("themeReportType");
                if (themeReportType == null) {
                    sb.append("olap");
                } else {
                    sb.append(themeReportType.toString());
                }
            } else if (treeType == 5) {
                sb.append("dashboard");
            }
            sb.append("'}");
            sb.append(FieldSeperator);
            sb.append(displayName);
            sb.append(FieldSeperator);
            if (treeType == 6 && !isFolder) {
                sb.append(captionPath == null ? "" : captionPath);
                sb.append(FieldSeperator);
                String datacenter = childNode.getPropertyValue("datacenter");
                if (datacenter == null) {
                    datacenter = "";
                }
                sb.append(datacenter);
                sb.append(FieldSeperator);
            } else if (treeType == 6) {
                sb.append(FieldSeperator);
                sb.append(FieldSeperator);
            }
            String portletName = childNode.getPropertyValue("portlet_name");
            sb.append(portletName == null ? "" : portletName);
            sb.append(FieldSeperator);
            String perID = childNode.getPropertyValue("permissionID");
            String creator = MetaData_EAS.getTree_Creator(treeType, rep, perID);
            sb.append(creator);
            sb.append(FieldSeperator);
            String lastUpdateUser = MetaData_EAS.getTree_LastUpdateUser(treeType, rep, perID);
            sb.append(lastUpdateUser);
            sb.append(FieldSeperator);
            Calendar c = childNode.getLastModified();
            if (c == null) continue;
            SimpleDateFormat df = new SimpleDateFormat();
            sb.append(df.format(c.getTime()));
        }
        return sb.toString();
    }

    public static Object getNodeByID(int treeType, String nodeID, Repository rep, HttpServletRequest req) throws BIReportException {
        switch (treeType) {
            case 0: {
                return BIReportTreeNode.fromID(nodeID);
            }
            case 9: {
                return BIMFactory.getBIMReportTreeInstance(req).fromID(nodeID);
            }
            case 1: {
                return BIReportTreeNode_EAS.fromID(nodeID, rep);
            }
            case 2: {
                return DashboardTreeNode.fromID(nodeID, rep);
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return RepositoryTreeNode.fromID(nodeID, rep);
            }
        }
        return null;
    }

    public static String getID(Object node) {
        String ID = "";
        if (node instanceof BIReportTreeNode) {
            ID = ((BIReportTreeNode)node).getID();
        } else if (node instanceof BIMReportNode) {
            ID = ((BIMReportNode)node).getModel().getNumber();
        } else if (node instanceof BIReportTreeNode_EAS) {
            ID = ((BIReportTreeNode_EAS)node).getID();
        } else if (node instanceof DashboardTreeNode) {
            ID = ((DashboardTreeNode)node).getID();
        } else if (node instanceof RepositoryTreeNode) {
            ID = ((RepositoryTreeNode)node).getID();
        } else if (node instanceof KPITreeNode) {
            ID = ((KPITreeNode)node).getID();
        }
        return ID;
    }

    public static String getProperyValue(Object node, String propertyName) {
        if (node instanceof BIReportTreeNode) {
            return ((BIReportTreeNode)node).getPropertyValue(propertyName);
        }
        if (node instanceof BIReportTreeNode_EAS) {
            return ((BIReportTreeNode_EAS)node).getPropertyValue(propertyName);
        }
        if (node instanceof DashboardTreeNode) {
            return ((DashboardTreeNode)node).getPropertyValue(propertyName);
        }
        if (node instanceof RepositoryTreeNode) {
            return ((RepositoryTreeNode)node).getPropertyValue(propertyName);
        }
        return null;
    }

    public static String getRepositoryPath(Object node) {
        if (node instanceof BIReportTreeNode) {
            return null;
        }
        if (node instanceof BIReportTreeNode_EAS) {
            return ((BIReportTreeNode_EAS)node).getID();
        }
        if (node instanceof DashboardTreeNode) {
            return ((DashboardTreeNode)node).getID();
        }
        if (node instanceof RepositoryTreeNode) {
            return ((RepositoryTreeNode)node).getFullPath();
        }
        return null;
    }

    public static boolean isLeaf(Object node) {
        if (node instanceof BIReportTreeNode) {
            return ((BIReportTreeNode)node).isLeaf();
        }
        if (node instanceof BIMReportNode) {
            return ((BIMReportNode)node).isLeaf();
        }
        if (node instanceof BIReportTreeNode_EAS) {
            return ((BIReportTreeNode_EAS)node).isLeaf();
        }
        if (node instanceof DashboardTreeNode) {
            return ((DashboardTreeNode)node).isLeaf();
        }
        if (node instanceof RepositoryTreeNode) {
            return ((RepositoryTreeNode)node).isLeaf();
        }
        if (node instanceof KPITreeNode) {
            return ((KPITreeNode)node).isLeaf();
        }
        return false;
    }

    public static String createReportRequestURL(HttpServletRequest request, String subjectName, String reportPath) {
        return request.getContextPath() + "/" + Constants.SERVLET_URL + "?" + "servletType" + "=" + "report" + "&" + "subject" + "=" + BITreeUtil.EncodeURL(subjectName) + "&" + "reportPath" + "=" + BITreeUtil.EncodeURL(reportPath);
    }

    public static String createOldReportRequestURL(String contextPath, String subjectName, String reportPath) {
        return contextPath + "/" + Constants.SERVLET_URL + "?" + "subject" + "=" + BITreeUtil.EncodeURL(subjectName) + "&" + "reportPath" + "=" + BITreeUtil.EncodeURL(reportPath);
    }

    public static String getRequstURL(HttpServletRequest request, Object node) {
        String url = "";
        if (node instanceof BIReportTreeNode) {
            url = BITreeUtil.createReportRequestURL(request, BITreeUtil.getProperyValue(node, "subject"), ((BIReportTreeNode)node).getFullPath());
        } else if (node instanceof BIMReportNode) {
            url = ((BIMReportNode)node).getID();
        } else if (node instanceof BIReportTreeNode_EAS) {
            String servletType = "";
            String type = BITreeUtil.getProperyValue(node, "themeReportType");
            if (type == null || "olap".equalsIgnoreCase(type.toString())) {
                servletType = "report";
            } else if ("ext".equalsIgnoreCase(type.toString())) {
                servletType = "extReport";
            } else if ("dupont".equalsIgnoreCase(type.toString())) {
                servletType = "dupontReport";
            } else if ("bimolap".equalsIgnoreCase(type.toString())) {
                servletType = "bimOlapReport";
            } else {
                return null;
            }
            url = BITreeUtil.getBullshitThemeReportRequestURL(request, servletType, BITreeUtil.getID(node));
        } else if (node instanceof DashboardTreeNode) {
            url = BITreeUtil.getDashboardRequestURL(request, BITreeUtil.getID(node));
        } else if (node instanceof RepositoryTreeNode) {
            url = ((RepositoryTreeNode)node).getRelativePath();
        }
        return url;
    }

    public static String getBullshitThemeReportRequestURL(HttpServletRequest request, String servletType, String path) {
        return request.getContextPath() + "/" + Constants.SERVLET_URL + "?" + "servletType" + "=" + servletType + "&" + "repositoryPath" + "=" + BITreeUtil.EncodeURL(path);
    }

    public static String getDashboardRequestURL(HttpServletRequest request, String path) {
        return request.getContextPath() + "/" + Constants.SERVLET_URL + "?" + "servletType" + "=" + "BIDashBoard" + "&dashboard_path=" + BITreeUtil.EncodeURL(path);
    }

    public static String EncodeURL(String str) {
        try {
            return URLEncoder.encode(str, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String loadTree(int treeType, String id, Repository rep, HttpServletRequest req, boolean onlyFolder, String path) throws BIReportException {
        TreeNode node = null;
        String caller = BISystem.getCurrentUser(req);
        if (id.equals("-1")) {
            TreeModel treeModel = BISystem.getSolution().getBITree(treeType, rep, req);
            if (treeModel == null) {
                return "empty";
            }
            node = (TreeNode)treeModel.getRoot();
            if (node == null) {
                return "empty";
            }
            if ("false".equalsIgnoreCase(req.getParameter("virtualMode"))) {
                if (treeType == 8) {
                    if (node == null) {
                        return "empty";
                    }
                    return ((KPITreeNode)node).getAllDescendants();
                }
                throw new BIReportException(treeType + "\u7684\u5b9e\u6a21\u5f0f\u6682\u65f6\u672a\u5b9e\u73b0!");
            }
        } else {
            node = (TreeNode)BITreeUtil.getNodeByID(treeType, id, rep, req);
        }
        int nChildCount = node.getChildCount();
        StringBuffer sb = new StringBuffer();
        BIPermission_EAS permission = new BIPermission_EAS(BISystem.getContext(req));
        for (int i = 0; i < nChildCount; ++i) {
            BITreeNode childNode = (BITreeNode)node.getChildAt(i);
            if (BISystem.isEAS() && (treeType == 1 || treeType == 2) && !MetaData_EAS.hasDataPermission$VerifyExtReport(childNode, treeType, permission, req)) continue;
            String url = "";
            if (BITreeUtil.isLeaf(childNode) && (treeType == 3 || treeType == 10) && (path != null && !path.equals("") && ((url = childNode.getPropertyValue("themeID")) == null || !url.equals(path) || treeType == 10 && !"dynamic".equals(childNode.getPropertyValue("type"))) || BISystem.isPiecePerByUser(req) && !PieceUtil.canUse(caller, childNode)) || onlyFolder && BITreeUtil.isLeaf(childNode)) continue;
            String caption = childNode.getPropertyValue("caption");
            String displayName = caption == null ? childNode.toString() : caption;
            sb.append(displayName).append(",").append(BITreeUtil.getID(childNode)).append(",").append(BITreeUtil.getRequstURL(req, childNode)).append(",").append(BITreeUtil.isLeaf(childNode) ? "false" : "true");
            if (treeType == 3) {
                sb.append(",").append(BITreeUtil.getProperyValue(childNode, "type"));
            } else if (treeType == 1) {
                sb.append(",");
                String themeReportType = childNode.getPropertyValue("themeReportType");
                if (themeReportType == null) {
                    sb.append("olap");
                } else {
                    sb.append(themeReportType.toString());
                }
            }
            sb.append("|");
        }
        if (sb.length() >= 1) {
            sb.deleteCharAt(sb.length() - 1);
        } else {
            sb.append("empty");
        }
        return sb.toString();
    }

    public static String getReportPath(Object node) {
        if (node instanceof BIReportTreeNode) {
            return ((BIReportTreeNode)node).getReportPath();
        }
        if (node instanceof BIReportTreeNode_EAS) {
            return ((BIReportTreeNode_EAS)node).getPropertyValue("reportPath");
        }
        return null;
    }

    public static String getSubjectName(Object node) {
        return ((BIReportTreeNode)node).getSubjectName();
    }

    protected static boolean hasDatapermission(HttpServletRequest req, BITreeNode childNode) throws BIReportException {
        IPermission ipermission = null;
        boolean ret = false;
        try {
            ipermission = PermissionFactory.getLocalInstance((Context)BISystem.getContext(req));
            ObjectStringPK userPK = new ObjectStringPK(ContextUtil.getCurrentUserInfo((Context)BISystem.getContext(req)).getId().toString());
            ObjectStringPK orgPK = new ObjectStringPK(ContextUtil.getCurrentOrgUnit((Context)BISystem.getContext(req)).getId().toString());
            ObjectStringPK dashBoardPK = new ObjectStringPK(childNode.getPropertyValue("permissionID"));
            ret = ipermission.hasDataPermission((IObjectPK)userPK, (IObjectPK)orgPK, "bi_dashboard_design", (IObjectPK)dashBoardPK);
        }
        catch (Exception e) {
            throw new BIReportException(e);
        }
        return ret;
    }
}

