/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.web.worksheet.navi;

import com.kingdee.bos.ctrl.analysis.olap.DrillExpandPosition;
import com.kingdee.bos.ctrl.analysis.olap.DrillReplace;
import com.kingdee.bos.ctrl.analysis.olap.Member;
import com.kingdee.bos.ctrl.analysis.olap.OlapModel;
import com.kingdee.bos.ctrl.analysis.olap.Position;
import com.kingdee.bos.ctrl.analysis.web.worksheet.navi.DrillExpandUI;
import com.kingdee.bos.ctrl.analysis.web.worksheet.span.Span;

public class DrillExpandPositionUI
extends DrillExpandUI {
    public static final String ID = "drillPosition";
    DrillExpandPosition expandPosition;
    DrillReplace drillReplace;

    @Override
    public String getId() {
        return ID;
    }

    @Override
    protected boolean initializeExtension() {
        OlapModel om = this.worksheet.getOlapModel();
        this.expandPosition = (DrillExpandPosition)om.getExtension("drillExpandPosition");
        this.drillReplace = (DrillReplace)om.getExtension("drillReplace");
        return this.expandPosition != null;
    }

    @Override
    protected boolean canExpand(Span span) {
        if (!DrillExpandPositionUI.positionContainsMember(span)) {
            return false;
        }
        return this.expandPosition.canExpand((Position)span.getPosition().getRootDecoree(), (Member)span.getMember().getRootDecoree());
    }

    @Override
    protected boolean canCollapse(Span span) {
        if (!DrillExpandPositionUI.positionContainsMember(span)) {
            return false;
        }
        return this.expandPosition.canCollapse((Position)span.getPosition().getRootDecoree(), (Member)span.getMember().getRootDecoree());
    }

    @Override
    protected void expand(Span span) {
        this.expandPosition.expand((Position)span.getPosition().getRootDecoree(), (Member)span.getMember().getRootDecoree());
    }

    @Override
    protected void collapse(Span span) {
        this.expandPosition.collapse((Position)span.getPosition().getRootDecoree(), (Member)span.getMember().getRootDecoree());
    }

    @Override
    protected String getCollapseImage() {
        return "drill-member-collapse";
    }

    @Override
    protected String getExpandImage() {
        return "drill-member-expand";
    }

    public void doMemberDrill(String id) {
        Span span = (Span)this.spanMap.get(id);
        Member member = span.getMember();
        this.drillReplace.drillDown(member);
    }

    public void doLevelDrill(String id) {
        Span span = (Span)this.spanMap.get(id);
        Member member = span.getMember();
        this.drillReplace.drillDown(member.getLevel());
    }

    public void doDrillUp(String id) {
        Span span = (Span)this.spanMap.get(id);
        Member member = span.getMember();
        this.drillReplace.drillUp(member.getHierarchy());
    }

    public Span getExpandSpan(String id) {
        return (Span)this.spanMap.get(id);
    }
}

