/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.swing.chart;

import com.kingdee.bos.ctrl.swing.KDChart;
import com.kingdee.bos.ctrl.swing.chart.ChartType;
import com.kingdee.bos.ctrl.swing.chart.IKDChartServerData;
import com.kingdee.bos.ctrl.swing.chart.data.CommonChartData;
import com.kingdee.bos.ctrl.swing.chart.data.GanttChartData;
import com.kingdee.bos.ctrl.swing.chart.data.PieChartData;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;

public class KDChartServlet
extends HttpServlet {
    private static final long serialVersionUID = -3395404123937621995L;

    public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
        String className = req.getParameter("dssrc");
        String width = req.getParameter("width");
        String height = req.getParameter("height");
        String title = req.getParameter("title");
        int w = Integer.parseInt(width);
        int h = Integer.parseInt(height);
        res.setContentType("image/jpeg");
        try {
            PieChartData pieChartData = null;
            CommonChartData commonChartData = null;
            GanttChartData ganttChartData = null;
            Class<?> c = Class.forName(className);
            Constructor<?> con = c.getConstructor(null);
            Object obj = con.newInstance(null);
            IKDChartServerData data = (IKDChartServerData)obj;
            KDChart chart = new KDChart();
            chart.setChartType(data.getChartType());
            if (data.getDataType().equals("PieChartData")) {
                pieChartData = (PieChartData)data.getData();
                chart.addChartData(pieChartData);
            } else if (data.getDataType().equals("GanttChartData")) {
                ganttChartData = (GanttChartData)data.getData();
                chart.addChartData(ganttChartData);
            } else {
                commonChartData = (CommonChartData)data.getData();
                chart.addChartData(commonChartData);
            }
            this.setChartTitle(chart, title);
            chart.writeChartAsJPEG((OutputStream)res.getOutputStream(), 100.0f, chart.getDelegate(), w, h, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void setChartTitle(KDChart chart, String title) {
        chart.getChartTitle().setText(title);
    }

    protected void setChartType(KDChart chart, ChartType type) {
        chart.setChartType(type);
    }
}

