/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.swing.chart.panel;

import com.kingdee.bos.ctrl.common.LanguageManager;
import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDColorChooser;
import com.kingdee.bos.ctrl.swing.KDFontChooser;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDOptionPane;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.chart.panel.StrokeChooserPanel;
import com.kingdee.bos.ctrl.swing.chart.panel.StrokeSample;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.border.Border;
import org.jfree.chart.Legend;
import org.jfree.chart.StandardLegend;
import org.jfree.layout.LCBLayout;
import org.jfree.ui.FontDisplayField;
import org.jfree.ui.PaintSample;

public class LegendPropertyEditPanel
extends KDPanel
implements ActionListener {
    public static final long serialVersionUID = 1001001001L;
    private StrokeSample outlineStroke;
    private PaintSample outlinePaint;
    private PaintSample backgroundPaint;
    private Font seriesFont;
    private PaintSample seriesPaint;
    private StrokeSample[] availableStrokeSamples;
    private FontDisplayField fontDisplayField;

    public LegendPropertyEditPanel(Legend legend) {
        StandardLegend l = (StandardLegend)legend;
        this.outlineStroke = new StrokeSample(l.getOutlineStroke());
        this.outlinePaint = new PaintSample(l.getOutlinePaint());
        this.backgroundPaint = new PaintSample(l.getBackgroundPaint());
        this.seriesFont = l.getItemFont();
        this.seriesPaint = new PaintSample(l.getItemPaint());
        this.availableStrokeSamples = new StrokeSample[4];
        this.availableStrokeSamples[0] = new StrokeSample(new BasicStroke(1.0f));
        this.availableStrokeSamples[1] = new StrokeSample(new BasicStroke(2.0f));
        this.availableStrokeSamples[2] = new StrokeSample(new BasicStroke(3.0f));
        this.availableStrokeSamples[3] = new StrokeSample(new BasicStroke(4.0f));
        this.setLayout(new BorderLayout());
        KDPanel general = new KDPanel((LayoutManager)new BorderLayout());
        general.setBorder((Border)BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), LanguageManager.getLangMessage((String)"General", LegendPropertyEditPanel.class, (String)"General")));
        KDPanel interior = new KDPanel((LayoutManager)new LCBLayout(5));
        interior.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        interior.add((Component)new KDLabel(LanguageManager.getLangMessage((String)"Outline", LegendPropertyEditPanel.class, (String)"Outline")));
        interior.add((Component)this.outlineStroke);
        KDButton button = new KDButton(LanguageManager.getLangMessage((String)"Select...", LegendPropertyEditPanel.class, (String)"Select..."));
        button.setActionCommand("OutlineStroke");
        button.addActionListener((ActionListener)this);
        interior.add((Component)button);
        interior.add((Component)new KDLabel(LanguageManager.getLangMessage((String)"Outline_Paint", LegendPropertyEditPanel.class, (String)"Outline Paint")));
        button = new KDButton(LanguageManager.getLangMessage((String)"Select...", LegendPropertyEditPanel.class, (String)"Select..."));
        button.setActionCommand("OutlinePaint");
        button.addActionListener((ActionListener)this);
        interior.add((Component)this.outlinePaint);
        interior.add((Component)button);
        interior.add((Component)new KDLabel(LanguageManager.getLangMessage((String)"Background", LegendPropertyEditPanel.class, (String)"Background")));
        button = new KDButton(LanguageManager.getLangMessage((String)"Select...", LegendPropertyEditPanel.class, (String)"Select..."));
        button.setActionCommand("BackgroundPaint");
        button.addActionListener((ActionListener)this);
        interior.add((Component)this.backgroundPaint);
        interior.add((Component)button);
        interior.add((Component)new KDLabel(LanguageManager.getLangMessage((String)"Series_label_font", LegendPropertyEditPanel.class, (String)"Series label font")));
        button = new KDButton(LanguageManager.getLangMessage((String)"Select...", LegendPropertyEditPanel.class, (String)"Select..."));
        button.setActionCommand("SeriesFont");
        button.addActionListener((ActionListener)this);
        this.fontDisplayField = new FontDisplayField(this.seriesFont);
        interior.add((Component)this.fontDisplayField);
        interior.add((Component)button);
        interior.add((Component)new KDLabel(LanguageManager.getLangMessage((String)"Series_label_paint", LegendPropertyEditPanel.class, (String)"Series label paint")));
        button = new KDButton(LanguageManager.getLangMessage((String)"Select...", LegendPropertyEditPanel.class, (String)"Select..."));
        button.setActionCommand("SeriesPaint");
        button.addActionListener((ActionListener)this);
        interior.add((Component)this.seriesPaint);
        interior.add((Component)button);
        general.add((Component)interior);
        this.add((Component)general, "North");
    }

    public Stroke getOutlineStroke() {
        return this.outlineStroke.getStroke();
    }

    public Paint getOutlinePaint() {
        return this.outlinePaint.getPaint();
    }

    public Paint getBackgroundPaint() {
        return this.backgroundPaint.getPaint();
    }

    public Font getSeriesFont() {
        return this.seriesFont;
    }

    public Paint getSeriesPaint() {
        return this.seriesPaint.getPaint();
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        if (command.equals("OutlineStroke")) {
            this.attemptModifyOutlineStroke();
        } else if (command.equals("OutlinePaint")) {
            this.attemptModifyOutlinePaint();
        } else if (command.equals("BackgroundPaint")) {
            this.attemptModifyBackgroundPaint();
        } else if (command.equals("SeriesFont")) {
            this.attemptModifySeriesFont();
        } else if (command.equals("SeriesPaint")) {
            this.attemptModifySeriesPaint();
        }
    }

    private void attemptModifyOutlineStroke() {
        StrokeChooserPanel panel = new StrokeChooserPanel(this.outlineStroke, this.availableStrokeSamples);
        int result = KDOptionPane.showConfirmDialog((Component)((Object)this), (Object)panel, (String)LanguageManager.getLangMessage((String)"Pen_Stroke_Selection", LegendPropertyEditPanel.class, (String)"Pen Stroke Selection"), (int)2, (int)-1);
        if (result == 0) {
            this.outlineStroke.setStroke(panel.getSelectedStroke());
        }
    }

    private void attemptModifyOutlinePaint() {
        Color c = KDColorChooser.showDialog((Component)((Object)this), (String)LanguageManager.getLangMessage((String)"Outline_Color", LegendPropertyEditPanel.class, (String)"Outline Color"), (Color)Color.blue);
        if (c != null) {
            this.outlinePaint.setPaint((Paint)c);
        }
    }

    private void attemptModifyBackgroundPaint() {
        Color c = KDColorChooser.showDialog((Component)((Object)this), (String)LanguageManager.getLangMessage((String)"Background_Color", LegendPropertyEditPanel.class, (String)"Background Color"), (Color)Color.blue);
        if (c != null) {
            this.backgroundPaint.setPaint((Paint)c);
        }
    }

    public void attemptModifySeriesFont() {
        KDFontChooser panel = new KDFontChooser(this.seriesFont, 2);
        int result = KDOptionPane.showConfirmDialog((Component)((Object)this), (Object)panel, (String)LanguageManager.getLangMessage((String)"Font_Selection", LegendPropertyEditPanel.class, (String)"Font Selection"), (int)2, (int)-1);
        if (result == 0) {
            this.seriesFont = panel.getSelectionFont();
            this.fontDisplayField.setText(this.seriesFont.getFontName() + ", " + this.seriesFont.getSize());
        }
    }

    private void attemptModifySeriesPaint() {
        Color c = KDColorChooser.showDialog((Component)((Object)this), (String)LanguageManager.getLangMessage((String)"Series_Label_Color", LegendPropertyEditPanel.class, (String)"Series Label Color"), (Color)Color.blue);
        if (c != null) {
            this.seriesPaint.setPaint((Paint)c);
        }
    }

    public void setLegendProperties(Legend legend) {
        if (legend instanceof StandardLegend) {
            StandardLegend standard = (StandardLegend)legend;
            standard.setOutlineStroke(this.getOutlineStroke());
            standard.setOutlinePaint(this.getOutlinePaint());
            standard.setBackgroundPaint(this.getBackgroundPaint());
            standard.setItemFont(this.getSeriesFont());
            standard.setItemPaint(this.getSeriesPaint());
        }
    }
}

