/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.common.util.logger;

import com.kingdee.bos.ctrl.common.GlobalLocator;
import com.kingdee.bos.ctrl.common.util.logger.LogReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public class LogViewer {
    public static File LOG_HOME = GlobalLocator.getInstance().locateResourceFolder("/logs");
    private LogReader logReader;

    public static final List listLogFiles() {
        Object[] files = LOG_HOME.list();
        Arrays.sort(files);
        return Arrays.asList(files);
    }

    public static final boolean remove(String logFile) {
        File file = new File(LogViewer.getAbsolutePath(logFile));
        return file.delete();
    }

    public static final String getAbsolutePath(String logFile) {
        return LOG_HOME.getAbsolutePath() + "/" + logFile;
    }

    public LogViewer(String logFile, int pageRows, boolean parse) throws FileNotFoundException, IOException {
        String logHome = LOG_HOME.getAbsolutePath();
        this.logReader = new LogReader(logHome + "/" + logFile, pageRows, parse);
    }

    public int getPageCount() {
        return this.logReader.getPageCount();
    }

    public List viewPage(int page) throws FileNotFoundException, IOException {
        return this.logReader.readPage(page);
    }
}

